/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.compare.valueconvert;

import com.kingdee.bos.qing.data.model.designtime.FilterItem;
import com.kingdee.bos.qing.data.util.valueconvert.PrimaryDataValueHandlerDelegate;
import com.kingdee.bos.qing.datasource.meta.DataType;

public class ComparePrimaryDataValueHandlerDelegate
extends PrimaryDataValueHandlerDelegate {
    private FilterItem.CompareOp op;

    public ComparePrimaryDataValueHandlerDelegate(DataType dataType, FilterItem.CompareOp op) {
        super(dataType);
        this.op = op;
        this.initComparePrimaryDataValueHandlerMap();
    }

    protected final void initComparePrimaryDataValueHandlerMap() {
        this.valueHandlerMap.put(DataType.STRING, new CompareStringValueHandler());
    }

    public class CompareStringValueHandler
    extends PrimaryDataValueHandlerDelegate.StringValueHandler {
        public Object toDbFilterValue(Object runtimValue) {
            if (null == runtimValue) {
                return null;
            }
            String strValue = String.valueOf(runtimValue);
            if (ComparePrimaryDataValueHandlerDelegate.this.op != null) {
                switch (ComparePrimaryDataValueHandlerDelegate.this.op) {
                    case START_WITH: {
                        strValue = strValue + "%";
                        break;
                    }
                    case END_WITH: {
                        strValue = "%" + strValue;
                        break;
                    }
                    case INCLUDE: 
                    case NOT_INCLUDE: {
                        strValue = "%" + strValue + "%";
                        break;
                    }
                }
            }
            return strValue;
        }
    }
}

