/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.db;

import com.kingdee.bos.qing.common.daterange.RelativeDateRange;
import com.kingdee.bos.qing.common.daterange.RuntimeRelativeDateRange;
import com.kingdee.bos.qing.data.model.designtime.FilterItem;
import com.kingdee.bos.qing.data.model.runtime.db.DBCompareFilter;
import com.kingdee.bos.qing.datasource.meta.DataType;
import java.sql.Timestamp;
import java.util.Map;

public class DWCompareFilter
extends DBCompareFilter {
    @Override
    public String getUnpushdownFilterExpress() {
        return this.formatSqlExpressFromObject(this._dataType, this.getRuntimeProperty().getAssociateName(), this.getCompareOp(), this.getComparedValue());
    }

    @Override
    public String getFieldFullName(String leftDelimiter, String rightDelimiter) {
        if (this.getRuntimeProperty().getProperty() != null) {
            Map<String, Object> extensionPropsMap = this.getRuntimeProperty().getProperty().getExtensionProps();
            if (extensionPropsMap != null && extensionPropsMap.get("refFieldName") != null) {
                return extensionPropsMap.get("refFieldName").toString();
            }
            return this.getAssociateName();
        }
        return this.getAssociateName();
    }

    private String formatSqlExpressFromObject(DataType propertyType, String propertyName, FilterItem.CompareOp opt, Object propertyValue) {
        StringBuilder formatSql = new StringBuilder();
        formatSql.append(propertyName).append(" ");
        Timestamp relativeStartDate = null;
        Timestamp relativeEndDate = null;
        if ((propertyType == DataType.DATE || propertyType == DataType.DATETIME) && propertyValue != null) {
            if (propertyValue instanceof RelativeDateRange) {
                RelativeDateRange relativeDateRange = (RelativeDateRange)propertyValue;
                RuntimeRelativeDateRange runtimeRelativeDateRange = new RuntimeRelativeDateRange(relativeDateRange);
                runtimeRelativeDateRange.parseRange();
                relativeStartDate = new Timestamp(runtimeRelativeDateRange.getDateStart());
                relativeEndDate = new Timestamp(runtimeRelativeDateRange.getDateEnd());
            } else {
                propertyValue = new Timestamp(Long.parseLong(propertyValue.toString()));
            }
        }
        switch (opt) {
            case EQUAL: {
                formatSql.append("= ").append(propertyValue);
                break;
            }
            case NOT_EQUAL: {
                formatSql.append("<> ").append(propertyValue);
                break;
            }
            case GREATER: {
                formatSql.append("> ").append(propertyValue);
                break;
            }
            case GREATER_EQUAL: {
                formatSql.append(">= ").append(propertyValue);
                break;
            }
            case LESS: {
                formatSql.append("< ").append(propertyValue);
                break;
            }
            case LESS_EQUAL: {
                formatSql.append("<= ").append(propertyValue);
                break;
            }
            case INCLUDE: {
                formatSql.append("LIKE '%").append(propertyValue).append("%'");
                break;
            }
            case NOT_INCLUDE: {
                formatSql.append("NOT LIKE '%").append(propertyValue).append("%'");
                break;
            }
            case START_WITH: {
                formatSql.append("LIKE '").append(propertyValue).append("%'");
                break;
            }
            case END_WITH: {
                formatSql.append("LIKE '%").append(propertyValue).append("'");
                break;
            }
            case NULL: {
                formatSql.append(" IS NULL ");
                break;
            }
            case NOT_NULL: {
                formatSql.append(" IS NOT NULL ");
                break;
            }
            case IN: {
                formatSql.append("IN ").append(propertyValue);
                break;
            }
            case NOT_IN: {
                formatSql.append("NOT IN ").append(propertyValue);
                break;
            }
            case RELATIVE_DATE_RANGE: {
                formatSql.append(">= ").append(relativeStartDate).append(" AND ").append(propertyName).append(" < ").append(relativeEndDate);
                break;
            }
            case VARIABALE_MATCH: {
                formatSql.append("= ").append(propertyValue);
                break;
            }
            case CUSTOM_VARIABALE_MATCH: {
                formatSql.append("= ").append(propertyValue);
                break;
            }
            default: {
                formatSql.append((Object)opt).append(" ").append(propertyValue);
            }
        }
        return formatSql.toString();
    }
}

