/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.process;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.UnionEntity;
import com.kingdee.bos.qing.data.model.runtime.process.BoxFixScene;
import com.kingdee.bos.qing.data.model.runtime.process.FixBizUnionEntityProcess;
import com.kingdee.bos.qing.data.model.runtime.process.UnionEntityFixContext;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FixBizUnionEntityBatchProcess {
    private QingContext qingContext;
    private BoxFixScene fixScene;

    public FixBizUnionEntityBatchProcess(QingContext qingContext, BoxFixScene boxFixScene) {
        this.qingContext = qingContext;
        this.fixScene = boxFixScene;
    }

    public void fixBizUnionEntity(List<AbstractEntity> bizUnionEntities, Map<String, DesigntimeDataObject> designtimeDataObjectMap, Map<String, AbstractSource> sourcesMap) {
        List<UnionEntity> rootUnionEntities = this.selectRoot(bizUnionEntities);
        if (rootUnionEntities.isEmpty()) {
            return;
        }
        Entity anyRootEntity = rootUnionEntities.get(0).getChildren().get(0);
        AbstractSource source = sourcesMap.get(anyRootEntity.getSource());
        for (UnionEntity root : rootUnionEntities) {
            ArrayList<UnionEntity> unionEntityInSameTree = new ArrayList<UnionEntity>();
            unionEntityInSameTree.add(root);
            this.findEntityInSameTree(root, bizUnionEntities, unionEntityInSameTree);
            UnionEntityFixContext unionEntityFixContext = new UnionEntityFixContext(unionEntityInSameTree, this.fixScene);
            unionEntityFixContext.prepare(this.qingContext, designtimeDataObjectMap, source);
            FixBizUnionEntityProcess unionEntityProcess = new FixBizUnionEntityProcess(this.qingContext, unionEntityFixContext);
            unionEntityProcess.fixUnionEntity();
        }
    }

    private List<UnionEntity> selectRoot(List<AbstractEntity> bizUnionEntities) {
        ArrayList<UnionEntity> rootUnions = new ArrayList<UnionEntity>();
        for (AbstractEntity unionEntity : bizUnionEntities) {
            if (unionEntity.getParentName() != null) continue;
            rootUnions.add((UnionEntity)unionEntity);
        }
        return rootUnions;
    }

    private void findEntityInSameTree(UnionEntity parentUnionEntity, List<AbstractEntity> bizUnionEntities, List<UnionEntity> unionEntityInSameTree) {
        for (AbstractEntity entity : bizUnionEntities) {
            UnionEntity currentUnion = (UnionEntity)entity;
            String parentName = currentUnion.getParentName();
            if (null == parentName || !parentName.equals(parentUnionEntity.getName())) continue;
            unionEntityInSameTree.add(currentUnion);
            this.findEntityInSameTree(currentUnion, bizUnionEntities, unionEntityInSameTree);
        }
    }
}

