/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.process;

import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.FilterItem;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.designtime.formula.FormulaHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FixEntityIllegalPropertyRuntimeProcess {
    public boolean process(AbstractDataSourceDomain sourceDomain, Entity dmEntity, Entity liveEntity) {
        sourceDomain.fixLocalEntityPropertyFromLive(dmEntity, liveEntity, true);
        ArrayList<Property> dmEntityCalculationProperties = new ArrayList<Property>();
        List<Property> dmEntityProperties = dmEntity.getProperties();
        HashMap<String, Property> dmPropertyNameWithPropertyMap = new HashMap<String, Property>(dmEntityProperties.size());
        for (Property dmEntityProperty : dmEntityProperties) {
            if (dmEntityProperty.isCalculation()) {
                dmEntityCalculationProperties.add(dmEntityProperty);
            }
            dmPropertyNameWithPropertyMap.put(dmEntityProperty.getName(), dmEntityProperty);
        }
        this.fixEntityIllegalCalculationProperties(dmEntityProperties, dmEntityCalculationProperties, dmPropertyNameWithPropertyMap);
        if (dmEntityProperties.isEmpty()) {
            return true;
        }
        this.fixEntityFilterItems(dmEntity.getFilters(), dmPropertyNameWithPropertyMap);
        return false;
    }

    private void fixEntityIllegalCalculationProperties(List<Property> dmEntityProperties, List<Property> dmEntityCalculationProperties, Map<String, Property> dmPropertyNameWithPropertyMap) {
        if (dmEntityProperties != null && !dmEntityProperties.isEmpty() && dmEntityCalculationProperties != null && !dmEntityCalculationProperties.isEmpty()) {
            FormulaHelper.handleAll(dmEntityProperties);
            for (Property dmEntityProperty : dmEntityCalculationProperties) {
                if (!dmEntityProperty.isFormulaInvalid()) continue;
                dmEntityProperties.remove(dmEntityProperty);
                dmPropertyNameWithPropertyMap.remove(dmEntityProperty.getName());
            }
        }
    }

    private void fixEntityFilterItems(List<FilterItem> dmFilterItems, Map<String, Property> dmPropertyNameWithPropertyMap) {
        if (dmFilterItems == null || dmFilterItems.isEmpty()) {
            return;
        }
        for (FilterItem dmFilterItem : dmFilterItems) {
            String dmFilterItemPropertyName = dmFilterItem.getProprety();
            Property dmProperty = dmPropertyNameWithPropertyMap.get(dmFilterItemPropertyName);
            if (dmProperty != null) continue;
            Boolean prediction = Boolean.FALSE;
            switch (dmFilterItem.getCompareOp()) {
                case NULL: 
                case NOT_EQUAL: 
                case NOT_INCLUDE: 
                case NOT_IN: {
                    prediction = Boolean.TRUE;
                    break;
                }
            }
            dmFilterItem.setPrediction(prediction);
        }
    }
}

