/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.process;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.EntityErrorInfo;
import com.kingdee.bos.qing.data.model.designtime.EntityErrorState;
import com.kingdee.bos.qing.data.model.runtime.process.BoxFixScene;
import com.kingdee.bos.qing.data.util.EntityErrorHelper;

public class FixIllegalEntityRuntimeProcess {
    private BoxFixScene scene;

    public FixIllegalEntityRuntimeProcess(BoxFixScene scene) {
        this.scene = scene;
    }

    public boolean process(QingContext qingContext, AbstractDataSourceDomain sourceDomain, Entity dmEntity, Entity liveEntity) {
        if (this.scene == BoxFixScene.datamodeling || this.scene == BoxFixScene.preview) {
            if (null == liveEntity || EntityErrorHelper.isErrorExist(liveEntity)) {
                EntityErrorInfo errorInfo = new EntityErrorInfo(EntityErrorState.TABLENOTEXIST);
                String msg = EntityErrorState.TABLENOTEXIST.getI18n(qingContext);
                String errorMsg = msg.replace("#1", dmEntity.getAlias());
                errorInfo.setErrorDesc(errorMsg);
                dmEntity.setErrorInfo(errorInfo);
            }
            return false;
        }
        return (dmEntity.hasDirectModel() || sourceDomain.canEntityChangeOnline() && this.scene == BoxFixScene.extract) && (liveEntity == null || EntityErrorHelper.isErrorExist(liveEntity));
    }
}

