/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.process;

import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.ColumnToRowProperty;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.designtime.Relation;
import com.kingdee.bos.qing.data.model.designtime.TreeProperty;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FixIllegalRelationProcess {
    public static void process(List<Relation> relations, Map<String, AbstractEntity> entitysMap) {
        if (relations == null || relations.isEmpty()) {
            return;
        }
        Iterator<Relation> removeRelationsIterator = relations.iterator();
        while (removeRelationsIterator.hasNext()) {
            Relation relation = removeRelationsIterator.next();
            AbstractEntity fromEntity = entitysMap.get(relation.getFromEntity());
            if (fromEntity == null) {
                removeRelationsIterator.remove();
                continue;
            }
            Property property = FixIllegalRelationProcess.filterRelationProperty(relation.getFromProperty(), fromEntity);
            if (null == property) {
                removeRelationsIterator.remove();
                continue;
            }
            AbstractEntity toEntity = entitysMap.get(relation.getToEntity());
            if (toEntity == null) {
                removeRelationsIterator.remove();
                continue;
            }
            Property property2 = FixIllegalRelationProcess.filterRelationProperty(relation.getToProperty(), toEntity);
            if (null != property2) continue;
            removeRelationsIterator.remove();
        }
    }

    protected static Property filterRelationProperty(String propName, AbstractEntity entity) {
        List<TreeProperty> list;
        List<Property> properties = entity.getProperties();
        for (Property property : properties) {
            if (!property.getName().equals(propName)) continue;
            return property;
        }
        List<ColumnToRowProperty> columnToRowProperties = entity.getColumnToRowProperties();
        if (null != columnToRowProperties) {
            for (ColumnToRowProperty crp : columnToRowProperties) {
                Property property = crp.getProperty(propName);
                if (null == property) continue;
                return property;
            }
        }
        if (null != (list = entity.getTreeNodeProperties())) {
            for (TreeProperty treeProperty : list) {
                Property property = treeProperty.getProperty(propName);
                if (null == property) continue;
                return property;
            }
        }
        return null;
    }
}

