/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.process;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.data.model.designtime.EntityType;
import com.kingdee.bos.qing.data.model.runtime.process.BoxFixScene;
import com.kingdee.bos.qing.data.model.runtime.process.FixAbstractEntityProcess;
import com.kingdee.bos.qing.data.model.runtime.process.FixBizUnionEntityBatchProcess;
import com.kingdee.bos.qing.data.model.runtime.process.FixEntityEnumProcess;
import com.kingdee.bos.qing.data.model.runtime.process.FixIllegalRelationProcess;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import com.kingdee.bos.qing.data.util.EntityNameKeySelector;
import com.kingdee.bos.qing.util.MapUtils;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FixListEntityPropertyProcess {
    private FixAbstractEntityProcess abstractEntityProcess;

    public void process(QingContext qingContext, Box box, BoxFixScene fixScene) {
        this.abstractEntityProcess = new FixAbstractEntityProcess(qingContext, box, fixScene);
        List<AbstractEntity> abstractEntities = box.getEntities();
        List<AbstractSource> sources = box.getSources();
        HashMap<String, DesigntimeDataObject> designtimeDataObjectMap = new HashMap<String, DesigntimeDataObject>();
        Map entitysMap = MapUtils.collectionToMap(abstractEntities, (MapUtils.IMapKeySelector)new EntityNameKeySelector());
        HashMap<String, Boolean> hasFixEntity = new HashMap<String, Boolean>();
        HashMap<String, AbstractSource> sourcesMap = new HashMap<String, AbstractSource>(sources.size());
        for (AbstractSource source : sources) {
            sourcesMap.put(source.getName(), source);
        }
        Iterator<AbstractEntity> abstractEntityIterator = abstractEntities.iterator();
        ArrayList<AbstractEntity> bizUnionEntityList = new ArrayList<AbstractEntity>();
        while (abstractEntityIterator.hasNext()) {
            AbstractEntity abstractEntity = abstractEntityIterator.next();
            String parentName = abstractEntity.getParentName();
            if (StringUtils.isNotEmpty((CharSequence)parentName)) {
                abstractEntity.setParentEntity((AbstractEntity)entitysMap.get(parentName));
            }
            if (abstractEntity.getEntityType() == EntityType.BIZ_UNION) {
                bizUnionEntityList.add(abstractEntity);
                continue;
            }
            boolean isDelete = this.abstractEntityProcess.process(abstractEntity, sourcesMap, designtimeDataObjectMap, entitysMap, hasFixEntity);
            if (!isDelete) continue;
            abstractEntityIterator.remove();
            entitysMap.remove(abstractEntity.getName());
        }
        if (bizUnionEntityList.size() > 0) {
            new FixBizUnionEntityBatchProcess(qingContext, fixScene).fixBizUnionEntity(bizUnionEntityList, designtimeDataObjectMap, sourcesMap);
        }
        FixIllegalRelationProcess.process(box.getRelations(), entitysMap);
        FixEntityEnumProcess.process(abstractEntities);
    }
}

