/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.util.formate;

import com.kingdee.bos.qing.data.util.formate.DateFormateMatchResult;
import com.kingdee.bos.qing.data.util.formate.DatePatternSiginature;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DateFormateHelper {
    private static Map<String, DatePatternSiginature> dateFormateMap = new HashMap<String, DatePatternSiginature>();
    private static Set<Integer> seperators = new HashSet<Integer>();

    public static void initSupportDatePattern(DatePatternSiginature patternSiginature) {
        dateFormateMap.put(patternSiginature.getSignatureCode(), patternSiginature);
    }

    public static DateFormateMatchResult executeMatch(String value) {
        String datePatternSignature = DateFormateHelper.calculateDatePatternSignature(value);
        if (null == datePatternSignature) {
            return DateFormateMatchResult.failMatch();
        }
        DatePatternSiginature patternSiginature = dateFormateMap.get(datePatternSignature);
        if (null == patternSiginature) {
            return DateFormateMatchResult.failMatch();
        }
        return DateFormateMatchResult.succeedMatch(patternSiginature.getFormatePattern(), patternSiginature.isHasTime());
    }

    private static String calculateDatePatternSignature(String value) {
        int length = value.length();
        int index = 0;
        StringBuilder numberBuilder = new StringBuilder();
        StringBuilder result = new StringBuilder();
        while (index < length) {
            char c = value.charAt(index);
            if (c >= '0' && c <= '9') {
                numberBuilder.append(c);
                ++index;
                continue;
            }
            if (DateFormateHelper.isDateTimeSeperatorChar(c)) {
                int numberLength = numberBuilder.length();
                result.append(numberLength == 1 ? 2 : numberLength).append(c);
                numberBuilder.setLength(0);
                ++index;
                continue;
            }
            return null;
        }
        if (numberBuilder.length() > 0) {
            result.append(numberBuilder.length() == 1 ? 2 : numberBuilder.length());
        }
        return result.toString();
    }

    public static boolean isDateTimeSeperatorChar(char c) {
        return seperators.contains(c);
    }

    static {
        seperators.add(47);
        seperators.add(45);
        seperators.add(32);
        seperators.add(58);
        seperators.add(46);
        DateFormateHelper.initSupportDatePattern(new DatePatternSiginature("yyyy/MM/dd", false));
        DateFormateHelper.initSupportDatePattern(new DatePatternSiginature("MM/dd/yyyy", false));
        DateFormateHelper.initSupportDatePattern(new DatePatternSiginature("yyyy-MM-dd", false));
        DateFormateHelper.initSupportDatePattern(new DatePatternSiginature("MM-dd-yyyy", false));
        DateFormateHelper.initSupportDatePattern(new DatePatternSiginature("yyyy/MM/dd HH:mm:ss", true));
        DateFormateHelper.initSupportDatePattern(new DatePatternSiginature("yyyy/MM/dd HH:mm:ss.SSS", true));
        DateFormateHelper.initSupportDatePattern(new DatePatternSiginature("yyyy/MM/dd HH:mm", true));
        DateFormateHelper.initSupportDatePattern(new DatePatternSiginature("MM/dd/yyyy HH:mm:ss", true));
        DateFormateHelper.initSupportDatePattern(new DatePatternSiginature("MM/dd/yyyy HH:mm:ss.SSS", true));
        DateFormateHelper.initSupportDatePattern(new DatePatternSiginature("MM/dd/yyyy HH:mm", true));
        DateFormateHelper.initSupportDatePattern(new DatePatternSiginature("yyyy-MM-dd HH:mm:ss", true));
        DateFormateHelper.initSupportDatePattern(new DatePatternSiginature("yyyy-MM-dd HH:mm:ss.SSS", true));
        DateFormateHelper.initSupportDatePattern(new DatePatternSiginature("yyyy-MM-dd HH:mm", true));
        DateFormateHelper.initSupportDatePattern(new DatePatternSiginature("MM-dd-yyyy HH:mm:ss", true));
        DateFormateHelper.initSupportDatePattern(new DatePatternSiginature("MM-dd-yyyy HH:mm:ss.SSS", true));
        DateFormateHelper.initSupportDatePattern(new DatePatternSiginature("MM-dd-yyyy HH:mm", true));
    }
}

