/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.api.customtable.model;

import com.kingdee.bos.qing.api.customtable.model.FieldMeta;
import com.kingdee.bos.qing.api.customtable.model.FieldType;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FieldData<R, T> {
    private R rawValue;
    private T changedValue;
    private boolean isDirty;
    private FieldMeta fieldMeta;
    private String rawFieldName;
    private String qingFieldName;
    private FieldType fieldType = FieldType.SIMPLE;
    private Set<String> otherQingFieldNames = new HashSet<String>();
    private boolean isNotOrmField;

    public FieldData(String rawFieldName, R rawValue) {
        this.rawFieldName = rawFieldName;
        this.rawValue = rawValue;
    }

    public FieldData(String rawFieldName, String qingFieldName, R rawValue) {
        this.rawValue = rawValue;
        this.rawFieldName = rawFieldName;
        this.qingFieldName = qingFieldName;
    }

    public void addOtherFieldNameForSameRawName(String qingUniqueFieldName) {
        this.otherQingFieldNames.add(qingUniqueFieldName);
    }

    public FieldMeta getFieldMeta() {
        return this.fieldMeta;
    }

    public void setFieldMeta(FieldMeta fieldMeta) {
        this.fieldMeta = fieldMeta;
    }

    public String getQingFieldName() {
        return this.qingFieldName;
    }

    public void bindRawValue(R rawValue) {
        this.rawValue = rawValue;
        this.isDirty = false;
        this.changedValue = null;
    }

    public void clearCurrent() {
        this.bindRawValue(null);
    }

    protected void setFieldType(FieldType fieldType) {
        this.fieldType = fieldType;
    }

    public boolean isNotOrmField() {
        return this.isNotOrmField;
    }

    public void setNotOrmField(boolean nonExist) {
        this.isNotOrmField = nonExist;
    }

    public String getRawFieldName() {
        return this.rawFieldName;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public R getRawValue() {
        return this.rawValue;
    }

    public void changeData(T targetValue) {
        this.changedValue = targetValue;
        this.isDirty = true;
    }

    public T getChangedValue() {
        return this.changedValue;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void flushToMap(Map<String, Object> target) {
        Object flushValue = this.isDirty() ? this.changedValue : this.rawValue;
        target.put(this.getQingFieldName(), flushValue);
        for (String otherQingFieldName : this.otherQingFieldNames) {
            target.put(otherQingFieldName, flushValue);
        }
    }
}

