/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.api.customtable.model;

import com.kingdee.bos.qing.api.customtable.interfaces.ITableRowDeleteListener;
import com.kingdee.bos.qing.api.customtable.model.FieldData;
import com.kingdee.bos.qing.api.customtable.model.FieldMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TableRowObject {
    private boolean isDeleted;
    private List<ITableRowDeleteListener> rowDeleteListeners = new ArrayList<ITableRowDeleteListener>();
    private Map<String, FieldData> fieldDataMap = null;

    public TableRowObject(Map<String, FieldData> fieldDataMap) {
        this.fieldDataMap = fieldDataMap;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDeleted(boolean deleted) {
        this.isDeleted = deleted;
    }

    public void notifyRowDeleteState(boolean deleted) {
        for (ITableRowDeleteListener rowDeleteListener : this.rowDeleteListeners) {
            rowDeleteListener.onRowDeleted(deleted);
        }
    }

    public void addDeleteListener(ITableRowDeleteListener rowDeleteListener) {
        this.rowDeleteListeners.add(rowDeleteListener);
    }

    public FieldData getFieldData(String fieldName) {
        return this.fieldDataMap.get(fieldName);
    }

    public FieldMeta getFieldMeta(String fieldName) {
        FieldData fieldData = this.fieldDataMap.get(fieldName);
        return null == fieldData ? null : fieldData.getFieldMeta();
    }

    public Object getFieldRawValue(String fieldName, boolean ignoreUnExist) {
        FieldData fieldData = this.getFieldData(fieldName);
        if (null == fieldData) {
            if (ignoreUnExist) {
                return null;
            }
            throw new IllegalArgumentException("field not exist,fieldName:" + fieldName);
        }
        return fieldData.getRawValue();
    }

    public boolean existField(String fieldName) {
        return this.fieldDataMap.containsKey(fieldName);
    }

    public <T> T getFieldData(String fieldName, Class<T> type) {
        FieldData fieldData = this.getFieldData(fieldName);
        if (null == fieldData) {
            return null;
        }
        return type.cast(fieldData);
    }

    public void flushToMap(Map<String, Object> target) {
        for (FieldData fieldData : this.fieldDataMap.values()) {
            fieldData.flushToMap(target);
        }
    }
}

