/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.bill.data.provider;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.PropertyRefCollection;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.SubQueryInfo;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.qing.bill.data.QueryDataProvider;
import com.kingdee.bos.qing.bill.preparedata.DefaultFieldInfoHandler;
import com.kingdee.bos.qing.bill.preparedata.IMetaFieldNameBuilder;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.preparedata.exception.PrepareDataException;
import com.kingdee.bos.qing.preparedata.handler.controller.model.EntryEntity;
import com.kingdee.bos.qing.preparedata.handler.controller.model.Field;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingFieldType;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingMeta;
import com.kingdee.bos.qing.preparedata.util.QueryUtil;
import com.kingdee.bos.qing.web.etl.model.QueryPageParameters;
import com.kingdee.bos.sql.ParserException;
import java.util.ArrayList;
import java.util.HashSet;

public class UnConfigurableBillDataProvider
extends QueryDataProvider {
    public UnConfigurableBillDataProvider(QingContext qingContext, QueryPageParameters parameter) {
        super(qingContext, parameter);
        this.fieldHandler = new DefaultFieldInfoHandler(new IMetaFieldNameBuilder(){

            @Override
            public String buildFieldName(Field field) {
                return (String)field.getCustomInfo("queryFieldName");
            }
        });
    }

    @Override
    protected QingMeta buildQingMeta() throws PrepareDataException {
        QingMeta qingMeta = new QingMeta();
        String queryPK = this.parameter.getQueryPK();
        HashSet<String> selectors = null != this.parameter.getFieldNams() ? new HashSet<String>(this.parameter.getFieldNams()) : null;
        MetaDataPK queryMetaPK = MetaDataPK.create((String)queryPK);
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        QueryInfo query = loader.getQuery((IMetaDataPK)queryMetaPK);
        try {
            SubObjectInfo mainObject = query.getMainObject();
            if (mainObject instanceof SubQueryInfo) {
                query = ((SubQueryInfo)mainObject).getQueryRef();
            }
            String entryEntityName = mainObject.getName();
            EntryEntity entryEntity = new EntryEntity();
            entryEntity.setKey(queryPK);
            entryEntity.setName(entryEntityName);
            entryEntity.setAlias(mainObject.getAlias());
            qingMeta.addEntryEntity(entryEntity);
            SelectorInfo selectorInfo = query.getSelector();
            ArrayList fieldInfos = selectorInfo.getFields();
            String realQueryFieldName = null;
            for (QueryFieldInfo queryFieldInfo : fieldInfos) {
                String queryFieldName = queryFieldInfo.getName();
                PropertyRefCollection propertyRefCollection = queryFieldInfo.getPropertyRefs();
                PropertyRefInfo propertyRefInfo = propertyRefCollection.get(0);
                PropertyInfo propertyInfo = propertyRefInfo.getRefProperty();
                String fullFieldName = entryEntityName + "." + propertyInfo.getName();
                realQueryFieldName = queryFieldName;
                if (null != selectors) {
                    if (selectors.contains(queryFieldName)) {
                        realQueryFieldName = queryFieldName;
                    } else {
                        if (!selectors.contains(fullFieldName)) continue;
                        realQueryFieldName = fullFieldName;
                    }
                }
                Field field = new Field();
                ConstDataType dataType = queryFieldInfo.getReturnType();
                QingFieldType qingFieldType = QueryUtil.parseQingFieldType(dataType.getName().toUpperCase());
                if ((dataType.equals((Object)ConstDataType.INT) || dataType.equals((Object)ConstDataType.NUMBER)) && queryFieldInfo.getFormulaString().equals("#0") && propertyInfo instanceof OwnPropertyInfo) {
                    com.kingdee.bos.metadata.entity.DataType ownDataType = ((OwnPropertyInfo)propertyInfo).getDataType();
                    DataType qingDataType = QueryUtil.parseDataType(ownDataType.getName());
                    qingFieldType = qingDataType.equals((Object)DataType.NUMBER) ? QingFieldType.Number : QingFieldType.String;
                }
                field.setFieldType(qingFieldType.toNumber());
                field.setEntity(propertyRefInfo.getSubEntity().getName());
                field.setName(propertyInfo.getName());
                String alias = queryFieldInfo.getDisplayName(this.bosContext.getOriginLocale());
                field.setAlias(null == alias ? queryFieldInfo.getName() : alias);
                field.addCustomInfo("queryFieldName", realQueryFieldName);
                field.setAssociateName(realQueryFieldName);
                qingMeta.addColumn(field);
            }
        }
        catch (BOSException e) {
            throw new PrepareDataException("failed to load query properties.", (Throwable)e);
        }
        this.processQingMeta(qingMeta);
        return qingMeta;
    }

    protected IQueryExecutor initQueryExecutor() throws BOSException, ParserException {
        ArrayList<String> selector = new ArrayList<String>();
        for (Field field : this.getQingMeta().getColumns()) {
            if (!field.isSupportOrm()) continue;
            selector.add(field.getAssociateName().toUpperCase());
        }
        String filterItems = this.parameter.getFilterItems();
        IQueryExecutor queryExecutor = QueryUtil.getQueryExecutor(this.bosContext, this.parameter.getQueryPK(), selector, filterItems);
        queryExecutor.option().pageCount = this.parameter.getRows();
        return queryExecutor;
    }
}

