/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.bill.data.proxy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecuteOption;
import com.kingdee.bos.dao.query.server.IQueryDataAccess;
import com.kingdee.bos.dao.query.server.QueryDataAccessFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.QuerySqlAccess;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryDataExecutorProxy
implements IQueryExecutor {
    private IDataProvider executor;
    private Context ctx;
    private IMetaDataPK metaDataPK;
    private QueryInfo queryInfo;
    private QuerySqlAccess querySqlAccess;

    public QueryDataExecutorProxy(IDataProvider executor, IMetaDataPK pk, Context ctx) {
        this.executor = executor;
        this.ctx = ctx;
        this.metaDataPK = pk;
        this.queryInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getQuery(this.metaDataPK);
        this.querySqlAccess = new QuerySqlAccess(ctx, this.queryInfo);
    }

    public boolean isDistinct() {
        if (this.queryInfo != null && this.queryInfo instanceof JoinQueryInfo) {
            return ((JoinQueryInfo)this.queryInfo).isIsDistinct();
        }
        return false;
    }

    public String getSQL() throws BOSException {
        if (!this.isDistinct()) {
            return this.executor.getSQL();
        }
        String querySql = this.executor.getSQL();
        String baseSql = this.querySqlAccess.getSql();
        String resultSql = this.connectSql(querySql, baseSql);
        return resultSql;
    }

    public int getRowCount() throws BOSException {
        if (!this.isDistinct()) {
            return this.executor.getRowCount();
        }
        String querySql = this.executor.getSQL();
        String baseSql = this.querySqlAccess.getSql();
        String conditionFromSql = this.getConditionFromSql(querySql);
        String newQuerySql = baseSql + " " + conditionFromSql;
        IQueryDataAccess qda = QueryDataAccessFactory.getLocalInstance((Context)this.ctx);
        return qda.getRowCount(newQuerySql, new HashMap(), new QueryExecuteOption());
    }

    public EntityViewInfo getObjectView() {
        return this.executor.getObjectView();
    }

    private String connectSql(String querySql, String baseSql) {
        Map<String, String> queryFieldsMap = this.getSelectFieldsMapFromSql(querySql);
        Map<String, String> baseFieldsMap = this.getSelectFieldsMapFromSql(baseSql);
        HashMap<String, String> newQueryFieldsMap = new HashMap<String, String>();
        for (Map.Entry<String, String> columnAlias : queryFieldsMap.entrySet()) {
            String queryColumn = columnAlias.getKey();
            String queryAlias = columnAlias.getValue();
            if (!baseFieldsMap.containsKey(queryColumn)) continue;
            String baseAlias = baseFieldsMap.get(queryColumn);
            if (StringUtils.isNotEmpty((CharSequence)baseAlias)) {
                newQueryFieldsMap.put(baseAlias, queryAlias);
                continue;
            }
            newQueryFieldsMap.put(queryColumn, queryAlias);
        }
        String conditionFromSql = this.getConditionFromSql(querySql);
        String subQuerySql = baseSql + " " + conditionFromSql;
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        ArrayList cols = new ArrayList(newQueryFieldsMap.keySet());
        for (int i = 0; i < cols.size(); ++i) {
            String newQueryColumn = (String)cols.get(i);
            String newQueryAlias = (String)newQueryFieldsMap.get(newQueryColumn);
            builder.append(newQueryColumn);
            builder.append(" AS ");
            builder.append(newQueryAlias);
            if (i >= cols.size() - 1) continue;
            builder.append(", ");
        }
        builder.append(" FROM ( ");
        builder.append(subQuerySql);
        builder.append(" ) TMP");
        return builder.toString();
    }

    private Map<String, String> getSelectFieldsMapFromSql(String sql) {
        HashMap<String, String> selectFieldsMap = new HashMap<String, String>();
        if (StringUtils.isEmpty((CharSequence)sql)) {
            return selectFieldsMap;
        }
        String selectFields = "";
        int selectIndex = sql.toUpperCase().indexOf("SELECT");
        int fromIndex = sql.toUpperCase().indexOf("FROM");
        if (selectIndex != -1 && fromIndex != -1) {
            selectFields = sql.substring(selectIndex + 6, fromIndex).trim();
        }
        if (StringUtils.isEmpty((CharSequence)selectFields)) {
            return selectFieldsMap;
        }
        String[] fields = (selectFields = selectFields.toUpperCase().replace(" DISTINCT", "").replace("DISTINCT ", "").replace(" DISTINCT ", " ")).split(",");
        if (fields.length >= 2) {
            for (String field : fields) {
                String[] parts;
                String column = null;
                String alias = null;
                if ((field = field.trim()).toUpperCase().contains(" AS ")) {
                    parts = field.split(" AS ");
                    column = parts[0].trim();
                    alias = parts[1].trim();
                } else if (field.contains(" ")) {
                    parts = field.split(" ");
                    column = parts[0].trim();
                    alias = parts[1].trim();
                } else {
                    column = field;
                }
                selectFieldsMap.put(column, alias);
            }
        }
        return selectFieldsMap;
    }

    private String getConditionFromSql(String sql) {
        if (StringUtils.isEmpty((CharSequence)sql)) {
            return null;
        }
        int index = sql.toUpperCase().indexOf("WHERE");
        if (index != -1) {
            return sql.substring(index);
        }
        return null;
    }

    public QueryExecuteOption option() {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }

    public void setObjectView(String s) throws BOSException {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }

    public void setObjectView(EntityViewInfo entityViewInfo) {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }

    public boolean hasResult() throws BOSException {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }

    public int getRowCount(Uuid uuid) throws BOSException {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }

    public int getRowCountByFields(String[] strings) throws BOSException {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }

    public EntityViewInfo getEntityView(String s) {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }

    public void setEntityView(String s, EntityViewInfo entityViewInfo) throws BOSException {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }

    public void setParameter(int i, Object o) throws BOSException {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }

    public boolean isDefineLogicalKey() throws BOSException {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }

    public int getRowCountByFields(Uuid uuid, String[] strings) throws BOSException {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }

    public IRowSet executeQuery() throws BOSException {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }

    public IRowSet executeQuery(List list) throws BOSException {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }

    public IRowSet executeQuery(int i, int i1) throws BOSException {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }

    public Uuid openQuery() throws BOSException {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }

    public List getQueryKeys(Uuid uuid) throws BOSException {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }

    public List getQueryKeys(Uuid uuid, int i) throws BOSException {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }

    public List getQueryKeys(Uuid uuid, int i, int i1) throws BOSException {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }

    public IRowSet executeQuery(Uuid uuid, int i, int i1) throws BOSException {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }

    public void releaseQueryCache(Uuid uuid) {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }

    public IRowSet executeQueryForRealPage(int i, int i1) throws BOSException {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }

    public IRowSet sum(String s, QueryFieldInfo[] queryFieldInfos) throws BOSException {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }

    public IRowSet sum(QueryFieldInfo[] queryFieldInfos) throws BOSException {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }

    public IRowSet sum(String s, String[] strings) throws BOSException {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }

    public IRowSet sum(String[] strings) throws BOSException {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }

    public Map doAllQueryTask(Uuid uuid, int i, int i1, String[] strings, boolean b, String s) throws BOSException {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }

    public Map doAllQueryTask(Uuid uuid, int i, int i1, String[] strings, boolean b) throws BOSException {
        return null;
    }

    public int indexOfBillID(Uuid uuid, String s, BOSUuid bosUuid) throws BOSException {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }

    public List getBillIDList(Uuid uuid, String s, int i, int i1) throws BOSException {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }

    public void removeBillID(Uuid uuid, String s, BOSUuid bosUuid) throws BOSException {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }

    public Map getRowCountAsyn(Uuid uuid, int i, boolean b) throws BOSException {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }

    public IRowSet groupbyAndAgg(QueryFieldInfo[] queryFieldInfos, QueryFieldInfo[] queryFieldInfos1, String[] strings, QueryFieldInfo[] queryFieldInfos2) throws BOSException {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }

    public IRowSet groupbyTime(QueryFieldInfo[] queryFieldInfos, String[] strings, QueryFieldInfo queryFieldInfo, int[] ints, int i) throws BOSException {
        throw new RuntimeException("QueryDataExecutorProxy method not implement");
    }
}

