/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.customservice;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.data.domain.source.db.IBizSourceConversionStrategy;
import com.kingdee.bos.qing.data.domain.source.db.IConnectionFactory;
import com.kingdee.bos.qing.data.exception.db.DBConnectionOpenException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.designtime.source.EasDBCenterSource;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class BizSourceConversionStrategyImpl
implements IBizSourceConversionStrategy {
    public DBSource createDBSourceByBizSource(AbstractSource source, QingContext qingContext) {
        Context ctx = ((QingIntegratedContext)qingContext).getBosContext();
        try {
            return this.createDbSource(source, ctx);
        }
        catch (DBConnectionOpenException e) {
            LogUtil.error((String)"Qing get DBSource failed,", (Throwable)e);
            return null;
        }
    }

    public DBSource createDbSource(AbstractSource source, Context ctx) throws DBConnectionOpenException {
        EasDBCenterSource tableSource = (EasDBCenterSource)source;
        DBSource.DBType dbType = this.getDbType(ctx);
        DBSource dbSource = new DBSource();
        dbSource.setDbName(tableSource.getDbName());
        dbSource.setName(tableSource.getName());
        dbSource.setDbType(dbType);
        List<DBSource.UserSQL> userSqls = tableSource.getUserSqls();
        if (null != userSqls) {
            for (DBSource.UserSQL sql : userSqls) {
                dbSource.addUserSql(sql);
            }
        }
        return dbSource;
    }

    public DBSource.DBType getDbType(Context ctx) throws DBConnectionOpenException {
        try {
            String dbStrType = String.valueOf(ctx.get((Object)"dbType")).toUpperCase();
            LogUtil.info((String)("EAS DB CENTER DB TYPE:" + dbStrType));
            if (dbStrType.contains("MS SQL SERVER")) {
                return DBSource.DBType.SQLSERVER;
            }
            return DBSource.DBType.valueOf((String)dbStrType);
        }
        catch (Exception e) {
            return this.getDbTypeFromDriverName(ctx);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DBSource.DBType getDbTypeFromDriverName(Context ctx) throws DBConnectionOpenException {
        Connection conn = null;
        try {
            DBSource.DBType[] dbTypes;
            conn = EJBFactory.getConnection((Context)ctx);
            String dataBaseProductName = conn.getMetaData().getDatabaseProductName().toUpperCase();
            if (dataBaseProductName.contains("ORACLE")) {
                DBSource.DBType dBType = DBSource.DBType.ORACLE;
                return dBType;
            }
            if (dataBaseProductName.contains("MICROSOFT SQL SERVER")) {
                DBSource.DBType dBType = DBSource.DBType.SQLSERVER;
                return dBType;
            }
            DBSource.DBType[] dBTypeArray = dbTypes = DBSource.DBType.values();
            int n = dBTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBSource.DBType dbType = dBTypeArray[n2];
                if (dataBaseProductName.indexOf(dbType.name()) != -1) {
                    DBSource.DBType dBType = dbType;
                    return dBType;
                }
                ++n2;
            }
            throw new DBConnectionOpenException("load db driver failed");
        }
        catch (SQLException ex) {
            throw DBConnectionOpenException.failOpen((SQLException)ex);
        }
        finally {
            CloseUtil.close((Connection)conn);
        }
    }

    public IConnectionFactory createConnFactoryByBizSource(AbstractSource abstractSource, QingContext qingContext) {
        return BizSourceConversionStrategyImpl.createConnFactory(((QingIntegratedContext)qingContext).getBosContext());
    }

    public static IConnectionFactory createConnFactory(final Context ctx) {
        return new IConnectionFactory(){

            public Connection createConnect() throws DBConnectionOpenException {
                try {
                    return EJBFactory.getConnection((Context)ctx);
                }
                catch (SQLException e) {
                    throw DBConnectionOpenException.failOpen((SQLException)e);
                }
            }

            public boolean supportKSql() {
                return true;
            }
        };
    }

    public String getId() {
        return IBizSourceConversionStrategy.class.getName();
    }
}

