/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.customservice;

import com.kingdee.bos.Context;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.common.framework.manage.IClientClosedListener;
import com.kingdee.bos.qing.common.session.IGlobalQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.common.strategy.framework.IClientClosedStrategy;
import com.kingdee.bos.qing.license.QingAnalysisLicenseUtil;
import com.kingdee.bos.qing.license.exception.QingLicenseException;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.ArrayList;
import java.util.List;

public class ClientCloseStrategyImpl
implements IClientClosedStrategy {
    private List<IClientClosedListener> clientClosedListeners = new ArrayList<IClientClosedListener>();

    public String getId() {
        return IClientClosedStrategy.class.getName();
    }

    public void closeClient(QingContext qingContext, String appID, String clientId) {
        for (IClientClosedListener clientClosedListener : this.clientClosedListeners) {
            clientClosedListener.onClientClosed(qingContext, clientId);
        }
    }

    public void registClosedListener(IClientClosedListener listener) {
        this.clientClosedListeners.add(listener);
    }

    public void removeListener(String listenerKey) {
        for (IClientClosedListener listener : this.clientClosedListeners) {
            if (!listener.getListenerKey().equals(listenerKey)) continue;
            LogUtil.warn((String)("remove invalid client closed listener:" + listener.getListenerKey()));
            listener.invalidMe();
            return;
        }
    }

    public static class ClientClosedListenerImpl
    implements IClientClosedListener {
        public void onClientClosed(QingContext qingContext, String clientID) {
            String clientIDLicenseKey;
            IGlobalQingSession qingSession;
            QingIntegratedContext qingIntegratedContext = (QingIntegratedContext)qingContext;
            Context context = qingIntegratedContext.getBosContext();
            if (context != null && "true".equals((qingSession = QingSessionUtil.getGlobalQingSessionImpl()).get(clientIDLicenseKey = clientID + ".CleintLicenseKey"))) {
                qingSession.remove(clientIDLicenseKey);
                try {
                    QingAnalysisLicenseUtil.releaseLicense(context);
                }
                catch (QingLicenseException e) {
                    LogUtil.error((String)e.getMessage(), (Throwable)((Object)e));
                }
            }
        }

        public String getListenerKey() {
            return null;
        }

        public void invalidMe() {
        }

        public boolean isInvalid() {
            return false;
        }
    }
}

