/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.customservice;

import com.kingdee.bos.qing.behavior.BehaviorService;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.common.systemvar.SystemVarType;
import com.kingdee.bos.qing.data.domain.source.easmeta.EasDBCenterSourceDomain;
import com.kingdee.bos.qing.data.exception.db.DBConnectionOpenException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.designtime.source.EasDBCenterSource;
import com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene.EmbeddedLongerSquareQHFExporter;
import com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene.QHFExporterFactory;
import com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene.publish.source.PublishSourceEmbeddedQHFExporter;
import com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene.publish.source.PublishSourceQHFExporterFactory;
import com.kingdee.bos.qing.imexport.model.Environment;
import com.kingdee.bos.qing.imexport.model.QHFSceneTypeEnum;
import com.kingdee.bos.qing.imexport.strategy.IQHFStrategy;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.UserAgentUtil;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;

public class QHFStrategyImpl
implements IQHFStrategy {
    public String getId() {
        return IQHFStrategy.class.getName();
    }

    public void assignEnvironmentValue(Environment environment, QingContext qingContext) {
        BehaviorService behaviorService = new BehaviorService();
        environment.getProduct().setVersion(behaviorService.getProductVersion());
        environment.getProduct().setSerialNo(behaviorService.getProductNo(qingContext));
        environment.getProduct().setName(behaviorService.getProductName());
        String userAgent = qingContext.getUserAgent();
        String browserInfo = UserAgentUtil.getBrowser((String)userAgent);
        String[] browserParams = browserInfo.split("-");
        if (browserParams.length >= 2) {
            environment.getClient().setBrowser(browserParams[0]);
            environment.getClient().setBrowserVersion(browserParams[1]);
        } else {
            environment.getClient().setBrowser("UnKnown, More-Info: " + userAgent);
            environment.getClient().setBrowserVersion("UnKnown, More-Info: " + userAgent);
        }
        environment.getClient().setClientOS(UserAgentUtil.getOperatingSystem((String)userAgent));
        Properties properties = System.getProperties();
        environment.getServer().setServerOS(properties.getProperty("os.name"));
        environment.getServer().setServerOSVersion(properties.getProperty("os.version"));
        HashMap<String, String> systemVars = new HashMap<String, String>(16);
        Set systemVarTypes = qingContext.getSupportedSystemVarTypes();
        for (SystemVarType systemVarType : systemVarTypes) {
            systemVars.put(systemVarType.name(), qingContext.getSystemVarStringValue(systemVarType));
        }
        environment.getUserContext().setSystemVars(systemVars);
        environment.getAccount().setId(qingContext.getAccountId());
        environment.getAccount().setName("\u6682\u65e0\u6cd5\u83b7\u53d6");
    }

    public DBSource getDBSource(AbstractSource iSource, QingContext qingContext) {
        if (iSource instanceof DBSource) {
            return (DBSource)iSource;
        }
        if (iSource instanceof EasDBCenterSource) {
            EasDBCenterSourceDomain dbCenterSourceDomain = new EasDBCenterSourceDomain();
            try {
                return dbCenterSourceDomain.createDbSource(iSource, ((QingIntegratedContext)qingContext).getBosContext());
            }
            catch (DBConnectionOpenException e) {
                LogUtil.error((String)"qing get dbcenter failed when export qhf", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public String getProductName(String productName) {
        BehaviorService behaviorService = new BehaviorService();
        return behaviorService.getProductName();
    }

    static {
        QHFExporterFactory.regist((QHFSceneTypeEnum)QHFSceneTypeEnum.embeddedLongerSquare, EmbeddedLongerSquareQHFExporter.class);
        PublishSourceQHFExporterFactory.regist((PublishSourceEnum)PublishSourceEnum.bill, PublishSourceEmbeddedQHFExporter.class);
    }
}

