/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.entityparser;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.qing.data.domain.entityparser.EntityObjectInfoParser;
import com.kingdee.bos.qing.data.domain.entityparser.PropertyInfoParser;
import com.kingdee.bos.qing.data.domain.entityparser.RelationshipEntityObject;
import com.kingdee.bos.qing.data.model.EasForeignKeyInfo;
import com.kingdee.bos.qing.preparedata.handler.controller.model.EntryEntity;
import com.kingdee.bos.qing.preparedata.handler.controller.model.Field;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingFieldType;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingMeta;
import com.kingdee.bos.qing.util.LogUtil;

public class LinkPropertyInfoParser
extends PropertyInfoParser {
    @Override
    public void parsePropertyInfo(PropertyInfo pi, EntityObjectInfo fromEoi, Context boxContext, QingMeta qingMeta) throws Exception {
        String alias;
        LinkPropertyInfo info = (LinkPropertyInfo)pi;
        RelationshipInfo relationshipInfo = info.getRelationship();
        if (this.isNeedSubEntity(info)) {
            if (qingMeta.isCoreBaseBill()) {
                return;
            }
            EntityObjectInfo subEntity = relationshipInfo.getSupplierObject();
            if (!subEntity.equals((Object)fromEoi)) {
                new EntityObjectInfoParser().parseEntityInfo(new RelationshipEntityObject(subEntity, fromEoi, info), boxContext, qingMeta);
                return;
            }
        }
        if (pi.getMappingField() == null) {
            return;
        }
        EntryEntity entryEntity = qingMeta.getEntryEntity(fromEoi.getName());
        String parentEntityAssociateName = entryEntity.getParentKey();
        boolean isParentEntityField = this.isParentEntity(parentEntityAssociateName, info);
        EntityObjectInfo relationLinkObject = null;
        relationLinkObject = isParentEntityField ? relationshipInfo.getClientObject() : relationshipInfo.getSupplierObject();
        if (relationLinkObject == null) {
            return;
        }
        String fieldName = pi.getName();
        Field field = new Field();
        field.setName(fieldName);
        field.setEntity(fromEoi.getName());
        field.setFieldType(QingFieldType.String.toNumber());
        field.addCustomInfo("propertyInfo", pi);
        if (isParentEntityField) {
            field.addCustomInfo("parentPkField", info);
        }
        if (StringUtil.isEmptyString((String)(alias = pi.getAlias()))) {
            alias = fieldName;
        }
        field.setAlias(alias);
        EasForeignKeyInfo foreignKey = this.createForeignKey(relationLinkObject, entryEntity, isParentEntityField);
        field.addCustomInfo("foreignKey", foreignKey);
        qingMeta.addColumn(field);
        entryEntity.addField(field);
        String value = pi.getExtendedProperty("isMainBizOrg");
        if ("true".equalsIgnoreCase(value)) {
            entryEntity.setMainOrgBizProp(pi);
        }
    }

    private EasForeignKeyInfo createForeignKey(EntityObjectInfo relationLinkObject, EntryEntity entryEntity, boolean isParentEntityField) {
        EasForeignKeyInfo fk = new EasForeignKeyInfo();
        fk.setEntityAssociateName(relationLinkObject.getFullName());
        PropertyInfo displayPropInfo = this.findRelationField(relationLinkObject);
        PropertyInfo pkPropInfo = null;
        if (isParentEntityField) {
            pkPropInfo = entryEntity.getLinkPropertyToParent().getRelationship().getClientProperty();
        } else {
            try {
                IObjectValue objectValue = (IObjectValue)relationLinkObject.getObjectValueClazzRuntime().newInstance();
                pkPropInfo = relationLinkObject.getPropertyByName(objectValue.getPKField());
                if (pkPropInfo.getMappingField() == null) {
                    pkPropInfo = null;
                }
            }
            catch (Exception e) {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
        }
        if (null != displayPropInfo && pkPropInfo != null && !displayPropInfo.getName().equalsIgnoreCase(pkPropInfo.getName())) {
            fk.setDisplayProperty(displayPropInfo);
        }
        fk.setPkProperty(pkPropInfo);
        return fk;
    }

    private PropertyInfo findRelationField(EntityObjectInfo relationLinkObject) {
        if (relationLinkObject.getPropertiesRuntime() != null) {
            for (PropertyInfo piInfo : relationLinkObject.getPropertiesRuntime()) {
                Object datatype;
                if (piInfo instanceof LinkPropertyInfo || piInfo.getMappingField() == null || (datatype = piInfo.get("dataType")) == null || !"string".contains(datatype.toString().toLowerCase())) continue;
                return piInfo;
            }
        }
        return null;
    }

    private boolean isParentEntity(String parentEntityFullName, LinkPropertyInfo info) {
        if (parentEntityFullName == null) {
            return false;
        }
        RelationshipInfo relationshipInfo = info.getRelationship();
        EntityObjectInfo clientObject = relationshipInfo.getClientObject();
        return clientObject != null && parentEntityFullName.equals(clientObject.getFullName());
    }

    private boolean isNeedSubEntity(LinkPropertyInfo info) {
        RelationshipInfo relationshipInfo = info.getRelationship();
        return !(relationshipInfo == null || relationshipInfo.getClientObject() == null || !RelationshipType.COMPOSITION.equals((Object)relationshipInfo.getType()) && !info.getName().equals("entries") || !CardinalityType.ONE.equals((Object)relationshipInfo.getClientCardinality()) && !CardinalityType.ZERO_TO_ONE.equals((Object)relationshipInfo.getClientCardinality()) || !CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)relationshipInfo.getSupplierCardinality()) && !CardinalityType.ONE_TO_UNBOUNDED.equals((Object)relationshipInfo.getSupplierCardinality()));
    }
}

