/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.entityparser;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.qing.data.domain.entityparser.PropertyInfoParser;
import com.kingdee.bos.qing.data.domain.exception.DataEntityException;
import com.kingdee.bos.qing.data.domain.source.easmeta.AbstractMetaSourceDomain;
import com.kingdee.bos.qing.data.model.designtime.DesigningDataType;
import com.kingdee.bos.qing.preparedata.handler.controller.model.EntryEntity;
import com.kingdee.bos.qing.preparedata.handler.controller.model.Field;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingMeta;
import com.kingdee.bos.qing.preparedata.util.FieldTypeUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.Map;

public class OwnPropertyInfoParser
extends PropertyInfoParser {
    @Override
    public void parsePropertyInfo(PropertyInfo pi, EntityObjectInfo fromEoi, Context boxContext, QingMeta qingMeta) throws Exception {
        if (pi == null) {
            return;
        }
        if (pi.getMappingField() == null) {
            return;
        }
        Field field = new Field();
        field.setName(pi.getName());
        String alias = pi.getAlias();
        if (StringUtil.isEmptyString((String)alias)) {
            alias = pi.getName();
        }
        field.setAlias(alias);
        field.setEntity(fromEoi.getName());
        field.addCustomInfo("propertyInfo", pi);
        DesigningDataType dataType = AbstractMetaSourceDomain.toDesigningDataType((String)pi.get("dataType"));
        if (dataType == null) {
            return;
        }
        field.setFieldType(FieldTypeUtil.changeDataTypeToQingFieldType(dataType));
        boolean aliableEnum = AbstractMetaSourceDomain.isAliableEnum(pi);
        if (aliableEnum) {
            try {
                Map<String, String> enumMap = AbstractMetaSourceDomain.getEnumMap(boxContext, pi);
                if (enumMap != null && enumMap.size() > 0) {
                    field.setEnumItems(enumMap);
                }
            }
            catch (BOSException e) {
                String msg = pi.getName() + " getEnum " + e.getMessage();
                LogUtil.error((String)msg, (Throwable)e);
                throw DataEntityException.fail2GetEnum(e.getCause(), msg);
            }
        }
        qingMeta.addColumn(field);
        EntryEntity entryEntity = qingMeta.getEntryEntity(fromEoi.getName());
        entryEntity.addField(field);
        String value = pi.getExtendedProperty("isMainBizOrg");
        if ("true".equalsIgnoreCase(value)) {
            entryEntity.setMainOrgBizProp(pi);
        }
    }
}

