/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.linkage;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.common.dao.impl.DBExcuterImpl;
import com.kingdee.bos.qing.common.dao.impl.TXManageImpl;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.data.domain.linkage.TemporaryTableManageNode;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.workflow.cust.app.startsheme.SQLUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jackrabbit.uuid.UUID;

public class QingTemporaryTableService {
    private static final String CREATE_TEMPLATE_SQL = "create table Q_T_%s (id VARCHAR(50))";
    private static AtomicInteger countFlag = new AtomicInteger(0);
    private static final String INSERT_SQL = "insert into T_Q_Temporary_Table_Manage(FID, FSESSION, FTABLENAME, FPKFIELD, FWEBUIOBJECTNAME, FCREATETIME) values(?,?,?,?,?,?)";
    private static final String QUERY_SQL = "select FID, FSESSION, FTABLENAME, FPKFIELD, FWEBUIOBJECTNAME, FCREATETIME from T_Q_Temporary_Table_Manage where FID = ?";
    private static final String QUERY_NAME_SQL = "select FTABLENAME from T_Q_Temporary_Table_Manage where FID = ?";
    private static final String QUERY_BY_SEESIONID_SQL = "select FID, FSESSION, FTABLENAME, FPKFIELD, FWEBUIOBJECTNAME, FCREATETIME from T_Q_Temporary_Table_Manage where FSESSION = ?";
    private static final String DELETE_SQL = "delete from T_Q_Temporary_Table_Manage where FID = ?";
    private static final String DELETE_BY_SESSION_SQL = "delete from T_Q_Temporary_Table_Manage where FSESSION = ?";
    private static final String DELETE_BY_CREATETIME_SQL = "delete from T_Q_Temporary_Table_Manage where FCREATETIME <= ?";
    private static final String COUNT_SQL_TEMPLATE = "select count(*) from %s";
    private static final int MAX_INSERT_NUMBER = 10000;

    private Context getContext() {
        QingContext context = QingContext.getCurrent();
        QingIntegratedContext qingIntegratedContext = (QingIntegratedContext)context;
        Context bosCtx = qingIntegratedContext.getBosContext();
        return bosCtx;
    }

    public String createTemporaryTable(String tableName, String foreignKeyMetaFieldFullName, String bizUiId) {
        if (null == tableName) {
            tableName = "";
        }
        String sqlCreateTable = String.format(CREATE_TEMPLATE_SQL, tableName + countFlag.getAndAdd(1));
        String id = UUID.randomUUID().toString();
        Context bosCtx = this.getContext();
        try {
            tableName = TempTablePool.getInstance((Context)bosCtx).createTempTable(sqlCreateTable, null, null);
            TemporaryTableManageNode tmpTableManageNode = new TemporaryTableManageNode();
            tmpTableManageNode.setId(id);
            tmpTableManageNode.setSessionID(QingContext.getCurrent().getSessionID());
            tmpTableManageNode.setTableName(tableName);
            tmpTableManageNode.setCreateTime(new Timestamp(System.currentTimeMillis()));
            tmpTableManageNode.setPkField(foreignKeyMetaFieldFullName);
            tmpTableManageNode.setWebUIObjectName(bizUiId);
            this.insertRecord(bosCtx, tmpTableManageNode);
        }
        catch (Exception e) {
            LogUtil.error((String)("getTemporaryTable Error: " + e));
        }
        return id;
    }

    public void releaseTemporaryTable(String id) {
        Context bosCtx = this.getContext();
        try {
            String tableName = this.getTemporaryTableNameByID(bosCtx, id);
            if (null != tableName) {
                TempTablePool.getInstance((Context)bosCtx).releaseTable(tableName);
            }
            this.deleteRecordByID(bosCtx, id);
        }
        catch (BOSException e) {
            LogUtil.error((String)("releaseTemporaryTable Error:" + (Object)((Object)e)));
        }
    }

    public int batchInsertData(String tableName, List<List<Object>> objectList) throws SQLException, AbstractQingIntegratedException {
        if (objectList != null) {
            Context bosCtx = this.getContext();
            TXManageImpl tx = new TXManageImpl(bosCtx);
            DBExcuterImpl dbExcuter = new DBExcuterImpl(tx);
            try {
                tx.beginRequired();
                String sql = "insert into " + tableName + " values(?)";
                dbExcuter.executeBatchInsert(sql, objectList, 10000);
            }
            catch (SQLException e) {
                tx.markRollback();
                throw e;
            }
            catch (AbstractQingIntegratedException e) {
                tx.markRollback();
                throw e;
            }
            finally {
                tx.end();
            }
            return objectList.size();
        }
        return 0;
    }

    public String getTableNameByID(String id) {
        return this.getTemporaryTableNameByID(this.getContext(), id);
    }

    public TemporaryTableManageNode getTemporaryInfoByID(Context ctx, String id) {
        TemporaryTableManageNode tmpTableManageNode = null;
        try {
            IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)QUERY_SQL, (Object[])new Object[]{id});
            if (null != rs && rs.next()) {
                tmpTableManageNode = new TemporaryTableManageNode();
                tmpTableManageNode.setId(rs.getString("FID"));
                tmpTableManageNode.setSessionID(rs.getString("FSESSION"));
                tmpTableManageNode.setTableName(rs.getString("FTABLENAME"));
                tmpTableManageNode.setCreateTime(rs.getDate("FCREATETIME"));
                tmpTableManageNode.setWebUIObjectName(rs.getString("FWEBUIOBJECTNAME"));
                tmpTableManageNode.setPkField(rs.getString("FPKFIELD"));
            }
        }
        catch (Exception e) {
            LogUtil.error((String)("getTemporaryInfoByID Error:" + e));
        }
        return tmpTableManageNode;
    }

    public String getTemporaryTableNameByID(Context ctx, String id) {
        String ret = null;
        try {
            IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)QUERY_NAME_SQL, (Object[])new Object[]{id});
            if (null != rs && rs.next()) {
                ret = rs.getString("FTABLENAME");
            }
        }
        catch (Exception e) {
            LogUtil.error((String)("getTemporaryTableNameByID Error: " + e));
        }
        return ret;
    }

    public boolean insertRecord(Context ctx, TemporaryTableManageNode node) {
        int count = -1;
        try {
            count = SQLUtils.execute((Context)ctx, (String)INSERT_SQL, (Object[])new Object[]{node.getId(), node.getSessionID(), node.getTableName(), node.getPkField(), node.getWebUIObjectName(), node.getCreateTime()});
        }
        catch (BOSException e) {
            LogUtil.error((String)("insertRecord Error: " + (Object)((Object)e)));
        }
        return count == 1;
    }

    public List<TemporaryTableManageNode> getManageInfoBySessionID(Context ctx, String sessionID) {
        ArrayList<TemporaryTableManageNode> tmpTableManageNodeList = new ArrayList<TemporaryTableManageNode>();
        TemporaryTableManageNode tmpTableManageNode = null;
        try {
            IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)QUERY_BY_SEESIONID_SQL, (Object[])new Object[]{sessionID});
            if (null != rs) {
                while (rs.next()) {
                    tmpTableManageNode = new TemporaryTableManageNode();
                    tmpTableManageNode.setId(rs.getString("FID"));
                    tmpTableManageNode.setSessionID(rs.getString("FSESSION"));
                    tmpTableManageNode.setTableName(rs.getString("FTABLENAME"));
                    tmpTableManageNode.setPkField(rs.getString("FPKFIELD"));
                    tmpTableManageNode.setWebUIObjectName(rs.getString("FWEBUIOBJECTNAME"));
                    tmpTableManageNode.setCreateTime(rs.getDate("FCREATETIME"));
                    tmpTableManageNodeList.add(tmpTableManageNode);
                }
            }
        }
        catch (Exception e) {
            LogUtil.error((String)("getManageInfoBySessionID Error: " + e));
        }
        return tmpTableManageNodeList;
    }

    public int deleteRecordByID(Context ctx, String id) throws BOSException {
        return SQLUtils.execute((Context)ctx, (String)DELETE_SQL, (Object[])new Object[]{id});
    }

    public int deleteRecordBySessionID(Context ctx, String sessionID) throws BOSException {
        return SQLUtils.execute((Context)ctx, (String)DELETE_BY_SESSION_SQL, (Object[])new Object[]{sessionID});
    }

    public int deleteRecordBeforeYesterday(Context ctx) throws BOSException {
        Date now = new Date();
        long yesterdaylong = now.getTime() - 86400000L;
        Timestamp yesterDay = new Timestamp(yesterdaylong);
        return SQLUtils.execute((Context)ctx, (String)DELETE_BY_CREATETIME_SQL, (Object[])new Object[]{yesterDay});
    }

    public int getTemporaryRowCount(Context ctx, String linkageID) throws BOSException {
        String temporaryTableName = this.getTemporaryTableNameByID(ctx, linkageID);
        int count = 0;
        if (!StringUtils.isEmpty((String)temporaryTableName)) {
            try {
                IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)String.format(COUNT_SQL_TEMPLATE, temporaryTableName));
                if (null != rs && rs.next()) {
                    count = rs.getInt(1);
                }
            }
            catch (Exception e) {
                LogUtil.error((String)("getTemprorayTableCount Error: " + e));
            }
        }
        return count;
    }
}

