/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.easmeta;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.customservice.BizSourceConversionStrategyImpl;
import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.domain.source.bizmeta.AbstractBizMetaSourceDomain;
import com.kingdee.bos.qing.data.domain.source.db.IConnectionFactory;
import com.kingdee.bos.qing.data.domain.source.db.IDBConnectionSupporter;
import com.kingdee.bos.qing.data.domain.source.db.impl.DBSourceDelegateDomain;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.exception.db.AbstractDBConnectException;
import com.kingdee.bos.qing.data.exception.db.DBConnectionOpenException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.designtime.source.EasDBCenterSource;
import com.kingdee.bos.qing.data.model.designtime.source.MetaSource;
import com.kingdee.bos.qing.data.model.runtime.ProgressProcessor;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.data.model.runtime.RuntimeProperty;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import com.kingdee.bos.qing.data.model.vo.FolderNode;
import com.kingdee.bos.qing.data.model.vo.LeafNode;
import com.kingdee.bos.qing.data.model.vo.PreviewDataModel;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.datasource.spec.IDataSourceWriter;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class EasDBCenterSourceDomain
extends AbstractBizMetaSourceDomain
implements IDBConnectionSupporter {
    public synchronized AbstractNode getUsableEntities(QingContext qingContext, AbstractSource source) throws AbstractSourceException, AbstractQingIntegratedException {
        Context ctx = ((QingIntegratedContext)qingContext).getBosContext();
        DBSource dbSource = this.createDbSource(source, ctx);
        DBSourceDelegateDomain dbTableSource = new DBSourceDelegateDomain(dbSource, BizSourceConversionStrategyImpl.createConnFactory(ctx));
        FolderNode root = (FolderNode)dbTableSource.getUsableEntities(qingContext);
        this.setLeafNodeType(root);
        return root;
    }

    private void setLeafNodeType(FolderNode root) {
        List children = root.getChildren();
        for (AbstractNode child : children) {
            LeafNode leaf = (LeafNode)child;
            leaf.setType(MetaSource.MetaType.EASDBCenter.name());
        }
    }

    public DBSource createDbSource(AbstractSource source, Context ctx) throws DBConnectionOpenException {
        EasDBCenterSource tableSource = (EasDBCenterSource)source;
        DBSource.DBType dbType = this.getDbType(ctx);
        DBSource dbSource = new DBSource();
        dbSource.setDbName(tableSource.getDbName());
        dbSource.setName(tableSource.getName());
        dbSource.setDbType(dbType);
        List<DBSource.UserSQL> userSqls = tableSource.getUserSqls();
        if (null != userSqls) {
            for (DBSource.UserSQL sql : userSqls) {
                dbSource.addUserSql(sql);
            }
        }
        return dbSource;
    }

    public DBSource.DBType getDbType(Context ctx) throws DBConnectionOpenException {
        try {
            String dbStrType = String.valueOf(ctx.get((Object)"dbType")).toUpperCase();
            LogUtil.info((String)("EAS DB CENTER DB TYPE:" + dbStrType));
            if (dbStrType.contains("MS SQL SERVER")) {
                return DBSource.DBType.SQLSERVER;
            }
            return DBSource.DBType.valueOf((String)dbStrType);
        }
        catch (Exception e) {
            return this.getDbTypeFromDriverName(ctx);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DBSource.DBType getDbTypeFromDriverName(Context ctx) throws DBConnectionOpenException {
        Connection conn = null;
        try {
            DBSource.DBType[] dbTypes;
            conn = EJBFactory.getConnection((Context)ctx);
            String dataBaseProductName = conn.getMetaData().getDatabaseProductName().toUpperCase();
            if (dataBaseProductName.contains("ORACLE")) {
                DBSource.DBType dBType = DBSource.DBType.ORACLE;
                return dBType;
            }
            if (dataBaseProductName.contains("MICROSOFT SQL SERVER")) {
                DBSource.DBType dBType = DBSource.DBType.SQLSERVER;
                return dBType;
            }
            DBSource.DBType[] dBTypeArray = dbTypes = DBSource.DBType.values();
            int n = dBTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBSource.DBType dbType = dBTypeArray[n2];
                if (dataBaseProductName.indexOf(dbType.name()) != -1) {
                    DBSource.DBType dBType = dbType;
                    return dBType;
                }
                ++n2;
            }
            throw new DBConnectionOpenException("load db driver failed");
        }
        catch (SQLException ex) {
            throw DBConnectionOpenException.failOpen((SQLException)ex);
        }
        finally {
            CloseUtil.close((Connection)conn);
        }
    }

    public PreviewDataModel getPreviewData(QingContext qingContext, RuntimeEntity runtimeEntity, int rows) throws AbstractSourceException {
        Context ctx = ((QingIntegratedContext)qingContext).getBosContext();
        DBSource dbSource = this.createDbSource(runtimeEntity.getSource(), ctx);
        DBSourceDelegateDomain dbTableSource = new DBSourceDelegateDomain(dbSource, BizSourceConversionStrategyImpl.createConnFactory(ctx));
        return dbTableSource.getPreviewData(qingContext, runtimeEntity, rows);
    }

    public DesigntimeDataObject getDesigntimeDataObject(QingContext qingContext, AbstractSource source, String tableName) throws AbstractSourceException {
        Context ctx = ((QingIntegratedContext)qingContext).getBosContext();
        DBSource dbSource = this.createDbSource(source, ctx);
        DBSourceDelegateDomain dbTableSource = new DBSourceDelegateDomain(dbSource, BizSourceConversionStrategyImpl.createConnFactory(ctx));
        return dbTableSource.getDesigntimeDataObject(qingContext, tableName);
    }

    public String extractData(QingContext qingContext, IDataSourceWriter dataSourceWriter, RuntimeEntity runtimeEntity, ProgressProcessor progressProcessor) throws DataSourcePersistenceException, AbstractSourceException, InterruptedException {
        Context ctx = ((QingIntegratedContext)qingContext).getBosContext();
        DBSource dbSource = this.createDbSource(runtimeEntity.getSource(), ctx);
        DBSourceDelegateDomain dbDomainDelaget = new DBSourceDelegateDomain(dbSource, BizSourceConversionStrategyImpl.createConnFactory(ctx));
        return dbDomainDelaget.extractData(qingContext, dataSourceWriter, runtimeEntity, progressProcessor);
    }

    public void checkSourceLegality(QingContext qingContext, AbstractSource source, List<Entity> entityArrayList, AbstractDataSourceDomain domain) {
    }

    public long getDataCount(QingContext qingContext, RuntimeEntity runtimeEntity) throws AbstractSourceException {
        Context ctx = ((QingIntegratedContext)qingContext).getBosContext();
        DBSource dbSource = this.createDbSource(runtimeEntity.getSource(), ctx);
        DBSourceDelegateDomain dbTableSource = new DBSourceDelegateDomain(dbSource, BizSourceConversionStrategyImpl.createConnFactory(ctx));
        return dbTableSource.getDataCount(qingContext, runtimeEntity);
    }

    protected boolean isDataFieldUnique(QingContext qingContext, RuntimeEntity runtimeEntity, RuntimeProperty fieldName) throws AbstractSourceException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkConnection(QingContext context, AbstractSource source) throws AbstractDBConnectException {
        Context ctx = ((QingIntegratedContext)context).getBosContext();
        IConnectionFactory connnectionProider = BizSourceConversionStrategyImpl.createConnFactory(ctx);
        Connection conn = null;
        try {
            conn = connnectionProider.createConnect();
        }
        finally {
            CloseUtil.close((Connection)conn);
        }
        return true;
    }
}

