/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.extension.biz.voucher;

import com.kingdee.bos.qing.api.customtable.interfaces.IQingTableRowDataProcessor;
import com.kingdee.bos.qing.api.customtable.interfaces.ITableRowDeleteListener;
import com.kingdee.bos.qing.api.customtable.model.ComplexFieldData;
import com.kingdee.bos.qing.api.customtable.model.FieldData;
import com.kingdee.bos.qing.api.customtable.model.FieldMeta;
import com.kingdee.bos.qing.api.customtable.model.TableRowObject;
import com.kingdee.bos.qing.common.i18n.DefaultI18nContext;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.data.flexfield.domain.FlexMetaSourceDomain;
import com.kingdee.bos.qing.data.flexfield.model.FlexPropertyData;
import com.kingdee.bos.qing.data.model.runtime.EasEntityExtension;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.data.model.runtime.RuntimeProperty;
import com.kingdee.bos.qing.preparedata.handler.controller.model.ComplexField;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.web.i18n.Messages;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class SubjectVoucherDataProcessor
implements IQingTableRowDataProcessor {
    private II18nContext i18nContext = new DefaultI18nContext();
    private String number;
    private String name;
    private String parentFieldFullName = "";
    private RuntimeEntity runtimeEntity;
    private Map<String, RuntimeProperty> runtimePropertyMap = new HashMap<String, RuntimeProperty>();

    SubjectVoucherDataProcessor() {
    }

    public void prepareParamDatas(Map<String, Object> params) {
        this.number = Messages.getLangMessage(this.i18nContext, "base_flex_number", "number");
        this.name = Messages.getLangMessage(this.i18nContext, "base_flex_name", "name");
        this.runtimeEntity = (RuntimeEntity)params.get("runtimeEntity");
        EasEntityExtension extension = (EasEntityExtension)this.runtimeEntity.getExtension(EasEntityExtension.class);
        this.parentFieldFullName = extension.getParentFullFieldName();
        this.runtimePropertyMap = this.runtimeEntity.getAllPriPropertyMap();
    }

    public void processRow(TableRowObject row) {
        FieldData assGrpfieldData = row.getFieldData(this.parentFieldFullName + "." + "assGrp");
        if (null == assGrpfieldData) {
            return;
        }
        FieldData assNumberGroupFieldData = row.getFieldData(this.parentFieldFullName + "." + "assistRecords.assGrp.numberGroup");
        if (null == assNumberGroupFieldData || assNumberGroupFieldData.getRawValue() == null) {
            LogUtil.error((String)("can not found flex field number group:" + this.parentFieldFullName + "." + "assistRecords.assGrp.numberGroup"));
            return;
        }
        String longNumberGroupValue = String.valueOf(assNumberGroupFieldData.getRawValue());
        ComplexFieldData complexData = (ComplexFieldData)assGrpfieldData;
        FieldMeta meta = complexData.getFieldMeta();
        ComplexField complexField = (ComplexField)meta.getOriginalField(ComplexField.class);
        List<FlexPropertyData> flexRefDatas = FlexMetaSourceDomain.getFlexPropertyData(longNumberGroupValue);
        LinkedHashMap innerPropDataMap = new LinkedHashMap();
        HashSet<String> notEmptyProperties = new HashSet<String>();
        for (FlexPropertyData flexPropData : flexRefDatas) {
            String flexRefNumberPropName = complexField.getName() + "." + flexPropData.getAssGrpNumber() + "." + "FNumber";
            complexData.setInnerFieldDataIgnoreUnExist(flexRefNumberPropName, (Object)flexPropData.getNumber());
            FieldData numberFieldData = complexData.getInnerFieldData(flexRefNumberPropName);
            boolean valid = false;
            if (null != numberFieldData) {
                valid = true;
                notEmptyProperties.add(numberFieldData.getQingFieldName());
            }
            String flexRefNamePropName = complexField.getName() + "." + flexPropData.getAssGrpNumber() + "." + "FName";
            complexData.setInnerFieldDataIgnoreUnExist(flexRefNamePropName, (Object)flexPropData.getName());
            FieldData nameFieldData = complexData.getInnerFieldData(flexRefNamePropName);
            if (null != nameFieldData) {
                valid = true;
                notEmptyProperties.add(nameFieldData.getQingFieldName());
            }
            if (!valid) continue;
            LinkedHashMap<String, String> baseTypeFieldData = new LinkedHashMap<String, String>();
            baseTypeFieldData.put(this.number, flexPropData.getNumber());
            baseTypeFieldData.put(this.name, flexPropData.getName());
            innerPropDataMap.put(flexPropData.getAssGrpName(), baseTypeFieldData);
        }
        if (!innerPropDataMap.isEmpty()) {
            assGrpfieldData.changeData((Object)JsonUtil.encodeToString(innerPropDataMap));
        }
        row.addDeleteListener((ITableRowDeleteListener)new RowDeleteListener(notEmptyProperties));
    }

    public void dispose() {
    }

    private class RowDeleteListener
    implements ITableRowDeleteListener {
        private Set<String> notEmptyProperties = new HashSet<String>();

        public RowDeleteListener(Set<String> notEmptyProperties) {
            this.notEmptyProperties = notEmptyProperties;
        }

        public void onRowDeleted(boolean isDeleted) {
            if (!isDeleted) {
                for (String propName : this.notEmptyProperties) {
                    RuntimeProperty runtimeProperty = (RuntimeProperty)SubjectVoucherDataProcessor.this.runtimePropertyMap.get(propName);
                    if (null == runtimeProperty) continue;
                    runtimeProperty.setChildPropHideInAnalysis(false);
                }
            }
        }
    }
}

