/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.extension.local.inner;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.qing.api.customtable.interfaces.IQingTableMetaProcessor;
import com.kingdee.bos.qing.api.customtable.model.TableMetaKey;
import com.kingdee.bos.qing.api.customtable.model.TableMetaObject;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.common.systemvar.SystemVarType;
import com.kingdee.bos.qing.preparedata.handler.controller.model.EntryEntity;
import com.kingdee.bos.qing.preparedata.handler.controller.model.Field;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingMeta;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.FieldAccessInfo;
import com.kingdee.eas.base.permission.FieldPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class EntityNoPermissionFieldProcessor
implements IQingTableMetaProcessor {
    public void processTableMeta(TableMetaObject tableMetaObject) {
        QingMeta qingMeta = (QingMeta)tableMetaObject.getQingMeta();
        TableMetaKey metaKey = tableMetaObject.getMetaKey();
        Context bosCtx = (Context)metaKey.getMetaContextInfo("bosContext");
        QingContext qingCtx = (QingContext)metaKey.getMetaContextInfo("qingContext");
        List<EntryEntity> entitys = qingMeta.getEntryEntities();
        HashMap<String, List<FieldPermission>> entityFieldPermissions = new HashMap<String, List<FieldPermission>>();
        for (EntryEntity entryEntity : entitys) {
            String associateName = entryEntity.getKey();
            AbstractMetaDataValue entityObj = this.getMetaInfo(bosCtx, associateName);
            List<FieldPermission> fieldPermissions = this.getEntityFieldPermissions(qingCtx, entityObj);
            entityFieldPermissions.put(entryEntity.getName(), fieldPermissions);
        }
        List<Field> allFields = qingMeta.getColumns();
        block1: for (Field field : allFields) {
            List fieldPermissions = (List)entityFieldPermissions.get(field.getEntity());
            if (null == fieldPermissions) continue;
            for (FieldPermission fieldPermission : fieldPermissions) {
                FieldAccessInfo fAccessInfo = fieldPermission.getFieldAccessInfo(field.getName());
                if (fAccessInfo == null || fAccessInfo.isViewable()) continue;
                field.setSupportOrm(false);
                continue block1;
            }
        }
    }

    protected AbstractMetaDataValue getMetaInfo(Context ctx, String fullName) {
        IMetaDataLoader metaDataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entityObj = metaDataLoader.getEntity((IMetaDataPK)MetaDataPK.create((String)fullName));
        return entityObj;
    }

    protected List<FieldPermission> getEntityFieldPermissions(QingContext qingContext, AbstractMetaDataValue metaInfo) {
        EntityObjectInfo entityObj = (EntityObjectInfo)metaInfo;
        Context bosCtx = ((QingIntegratedContext)qingContext).getBosContext();
        ObjectUuidPK userPK = new ObjectUuidPK(qingContext.getUserId());
        ObjectUuidPK orgPK = new ObjectUuidPK(qingContext.getSystemVar(SystemVarType.ORG_ID).toString());
        BOSObjectType bosType = entityObj.getType();
        ArrayList<FieldPermission> permissions = new ArrayList<FieldPermission>();
        try {
            FieldPermission permission = PermissionFactory.getLocalInstance((Context)bosCtx).getFieldPermission(bosType, (IObjectPK)userPK, (IObjectPK)orgPK);
            if (permission.isEmpty()) {
                return permissions;
            }
            permissions.add(permission);
        }
        catch (Exception e) {
            LogUtil.error((String)"", (Throwable)e);
        }
        return permissions;
    }

    public void dispose() {
    }
}

