/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.license;

import com.kingdee.bos.Context;
import com.kingdee.bos.qing.license.QingAnalysisLicenseChecker;
import com.kingdee.bos.qing.license.exception.QingLicenseException;

public class QingAnalysisLicenseUtil {
    public static boolean checkLicense(Context ctx) throws QingLicenseException {
        try {
            QingAnalysisLicenseChecker licenseChecker = new QingAnalysisLicenseChecker(ctx);
            if (licenseChecker.sysLicenseModuleType() == 0) {
                throw QingLicenseException.NoLicenseException;
            }
            if (licenseChecker.checkLicense()) {
                return true;
            }
            throw QingLicenseException.NoLicenseException;
        }
        catch (Exception e) {
            throw QingLicenseException.wrap(e, 3010001);
        }
    }

    public static boolean checkModule(Context ctx) throws QingLicenseException {
        try {
            QingAnalysisLicenseChecker licenseChecker = new QingAnalysisLicenseChecker(ctx);
            if (licenseChecker.sysLicenseModuleType() == 0) {
                throw QingLicenseException.NoLicenseException;
            }
        }
        catch (Exception e) {
            throw QingLicenseException.wrap(e, 3010001);
        }
        return true;
    }

    public static boolean releaseLicense(Context ctx) throws QingLicenseException {
        QingAnalysisLicenseChecker licenseChecker = new QingAnalysisLicenseChecker(ctx);
        return licenseChecker.releaseLicense();
    }
}

