/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata.handler.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.meta.MetaInfoDecodeUtil;
import com.kingdee.bos.qing.datasource.spec.IDataIterator;
import com.kingdee.bos.qing.datasource.spec.qs.QSDataIterator;
import com.kingdee.bos.qing.datasource.spec.qs.QSInputstream;
import com.kingdee.bos.qing.filesystem.manager.CopyWriteCall;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.filesystem.manager.localimpl.LocalPersistentQingFile;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.ormrpc.IBudgetService;
import com.kingdee.bos.qing.ormrpc.QingORMRPCDispatcherFactory;
import com.kingdee.bos.qing.preparedata.util.QingBudgetServiceUtil;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.QingIntegratedUtil;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import q.datasource.io.AbstractInputStream;
import q.storage.columnar.metadata.FileMetaData;
import q.storage.columnar.util.QingStorageUtils;

public class BudgetDataSourceVisitor {
    private MetaInfo _metaInfo;
    private IQingFileVisitor _dataFile;
    private Context _ctx;
    private IDataIterator _iDataIterator;

    BudgetDataSourceVisitor(IQingFileVisitor dataFile, Context context) throws BOSException {
        block8: {
            this._ctx = context;
            this._dataFile = dataFile;
            if (!this._dataFile.exists() && QingBudgetServiceUtil.isNeedORMRPC()) {
                String fileName = this._dataFile.getName();
                IBudgetService ormService = QingORMRPCDispatcherFactory.createBudgetService(this._ctx);
                try {
                    QingIntegratedContext qingCtx = QingIntegratedUtil.initQingIntegratedContext(this._ctx, null);
                    byte[] in = ormService.downloadBudgetDataFile(qingCtx, fileName);
                    if (in != null) {
                        LocalPersistentQingFile qingFile = new LocalPersistentQingFile(QingPersistentFileType.BUDGET, fileName);
                        qingFile.write((IWriteCall)new CopyWriteCall((InputStream)new ByteArrayInputStream(in), true), true);
                        this._dataFile = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.BUDGET, (String)fileName);
                    }
                }
                catch (Exception e) {
                    LogUtil.error((String)("error in BudgetDataSourceVisitor, file name is " + this._dataFile.getName()), (Throwable)e);
                    throw new BOSException("error in BudgetDataSourceVisitor, file name is " + this._dataFile.getName(), (Throwable)e);
                }
            }
            if (!this._dataFile.exists()) break block8;
            QingInputStream inputStream = null;
            FileMetaData fileMetaData = null;
            try {
                inputStream = this._dataFile.getInputStream();
                fileMetaData = QingStorageUtils.readQingStorageMetaData((AbstractInputStream)new QSInputstream(inputStream), (boolean)true);
            }
            catch (Exception e) {
                try {
                    LogUtil.error((String)("error in BudgetDataSourceVisitor, file name is " + this._dataFile.getName()), (Throwable)e);
                    throw new BOSException("error in BudgetDataSourceVisitor, file name is " + this._dataFile.getName(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{inputStream});
                    throw throwable;
                }
            }
            CloseUtil.close((Closeable[])new Closeable[]{inputStream});
            String metaInfoString = (String)fileMetaData.getKeyValueMetaData().get(".metadata.");
            this._metaInfo = MetaInfoDecodeUtil.decode((String)metaInfoString);
        }
    }

    public boolean getDataIteratorHasNextRow() throws BOSException {
        if (this._iDataIterator == null) {
            this._iDataIterator = this.iterator();
        }
        try {
            if (this._iDataIterator == null) {
                throw new BOSException("Qing DataIterator is null.");
            }
            return this._iDataIterator.hasNextRow();
        }
        catch (Exception e) {
            LogUtil.error((String)("error in BudgetDataSourceVisitor, file name is " + this._dataFile.getName()), (Throwable)e);
            throw new BOSException("error in BudgetDataSourceVisitor, file name is " + this._dataFile.getName(), (Throwable)e);
        }
    }

    public Map<String, Object> getDataIteratorNextRow() throws BOSException {
        try {
            if (this._iDataIterator == null) {
                throw new BOSException("Qing DataIterator is null.");
            }
            return this._iDataIterator.nextRow();
        }
        catch (Exception e) {
            LogUtil.error((String)("error in BudgetDataSourceVisitor, file name is " + this._dataFile.getName()), (Throwable)e);
            throw new BOSException("error in BudgetDataSourceVisitor, file name is " + this._dataFile.getName(), (Throwable)e);
        }
    }

    public MetaInfo getMetaInfo() {
        return this._metaInfo;
    }

    private IDataIterator iterator() throws BOSException {
        QSDataIterator iterator;
        try {
            iterator = new QSDataIterator(this._dataFile);
        }
        catch (AbstractDataSourceException e) {
            LogUtil.error((String)("error in BudgetDataSourceVisitor, file name is " + this._dataFile.getName()), (Throwable)e);
            throw new BOSException("error in BudgetDataSourceVisitor, file name is " + this._dataFile.getName(), (Throwable)e);
        }
        List fieldNameList = this._metaInfo.getFieldNames();
        HashSet<DSFieldKey> fields = new HashSet<DSFieldKey>();
        for (int i = 0; i < fieldNameList.size(); ++i) {
            fields.add(new DSFieldKey(this._metaInfo.getFieldName(i)));
        }
        try {
            iterator.init(fields, null, null);
        }
        catch (Exception e) {
            LogUtil.error((String)("error in BudgetDataSourceVisitor, file name is " + this._dataFile.getName()), (Throwable)e);
            throw new BOSException("error in BudgetDataSourceVisitor, file name is " + this._dataFile.getName(), (Throwable)e);
        }
        return iterator;
    }

    public void close() {
        if (this._iDataIterator != null) {
            this._iDataIterator.close();
            this._iDataIterator = null;
        }
    }
}

