/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata.model;

import com.kingdee.bos.qing.util.LogUtil;
import java.util.List;

public class Pager {
    private long pageSize;
    private long currentPageNumber = 0L;
    private long totalPageCount = 0L;
    private long totalRowsCount = 0L;
    private boolean hasNextPage = true;
    private List<Object[]> data;

    public Pager() {
        try {
            this.pageSize = Integer.valueOf(System.getProperty("qing.form.pagesize", "1000")).intValue();
            LogUtil.info((String)("form.pagesize:" + this.pageSize));
        }
        catch (Exception e) {
            LogUtil.info((String)"Warming qing.form.pagesize config error. form.pagesize:1000");
            this.pageSize = 1000L;
        }
    }

    public void setData(List<Object[]> data) {
        this.data = data;
        this.hasNextPage = null != data && (long)data.size() == this.pageSize;
    }

    public List<Object[]> getData() {
        return this.data;
    }

    public long getPageSize() {
        return this.pageSize;
    }

    public void setTotal(long pageSize, long totalRowsCount) {
        this.pageSize = pageSize;
        this.totalRowsCount = totalRowsCount;
        this.totalPageCount = totalRowsCount % pageSize == 0L ? totalRowsCount / pageSize : totalRowsCount / pageSize + 1L;
    }

    public int getStartIndex() {
        return (int)((this.currentPageNumber - 1L) * this.pageSize);
    }

    public int getLengthLimit() {
        if (this.currentPageNumber < this.totalPageCount) {
            return (int)this.pageSize;
        }
        return (int)(this.totalRowsCount % this.pageSize);
    }

    public long nextPage() {
        return this.currentPageNumber++;
    }

    public boolean hasNextPage() {
        return this.hasNextPage;
    }
}

