/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.programablecard.reference;

import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.ref.ISwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.dashboard.exception.DashboardException;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.dashboard.reference.AbstractRefHandler;
import com.kingdee.bos.qing.dashboard.reference.IExImportPublishable;
import com.kingdee.bos.qing.dashboard.reference.IExImportable;
import com.kingdee.bos.qing.dashboard.reference.IPublishable;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.imagelibrary.exception.QingImglibException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportException;
import com.kingdee.bos.qing.imexport.importer.qhf.model.datasourceinfovo.AbstractDataSourceInfoVO;
import com.kingdee.bos.qing.imexport.model.ImportedModel;
import com.kingdee.bos.qing.imexport.model.PackageMeta;
import com.kingdee.bos.qing.manage.domain.AbstractThemeManageDomain;
import com.kingdee.bos.qing.manage.exception.ImportThemeException;
import com.kingdee.bos.qing.manage.imexport.model.po.IDashboardExportFilePathGetter;
import com.kingdee.bos.qing.manage.imexport.model.po.dashboard.DsbProgramableCardRefProperty;
import com.kingdee.bos.qing.manage.imexport.model.po.dashboard.ExportDsbSchemaProperty;
import com.kingdee.bos.qing.manage.imexport.model.runtime.DashboardImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.DashboardPublishImportModel;
import com.kingdee.bos.qing.preparedata.exception.PublishedPrepareDataException;
import com.kingdee.bos.qing.preparedata.exception.SubjectModelParseException;
import com.kingdee.bos.qing.programablecard.dao.ProgramableCardDao;
import com.kingdee.bos.qing.programablecard.domain.ProgramableCardImExporter;
import com.kingdee.bos.qing.programablecard.imexport.collector.dashboard.ProgramableCardFileCache;
import com.kingdee.bos.qing.programablecard.model.ProgramableCard;
import com.kingdee.bos.qing.programablecard.model.ProgramableCardPubRef;
import com.kingdee.bos.qing.programablecard.model.ProgramableCardRef;
import com.kingdee.bos.qing.programablecard.util.ChartRequestUtil;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class ProgramableCardHandler
extends AbstractRefHandler
implements IExImportable,
IPublishable,
IExImportPublishable {
    private ProgramableCardDao cardDao;
    private ProgramableCardImExporter cardImExporter;

    public ProgramableCardHandler() {
        this.setRefType(RefTypeEnum.programableCard);
    }

    private ProgramableCardDao getCardDao() {
        if (this.cardDao == null) {
            this.cardDao = new ProgramableCardDao(this.dbExcuter);
        }
        return this.cardDao;
    }

    private ProgramableCardImExporter getImExporter() {
        if (this.cardImExporter == null) {
            this.cardImExporter = new ProgramableCardImExporter();
        }
        return this.cardImExporter;
    }

    public void saveOrUpdateReference(String dsbId, ReferenceMap refMap) throws DashboardException, AbstractQingIntegratedException, SQLException {
        String refUid = refMap.getUid();
        this.getDashboardDao().deleteDsbRef(dsbId, refUid);
        this.getDashboardDao().saveRefInfo(refMap, dsbId);
        ProgramableCardRef cardRef = this.getCardDao().loadChartRefInfo(dsbId, refUid);
        if (cardRef != null && cardRef.getChartId() != null) {
            return;
        }
        String chartId = (String)refMap.get((Object)"chartId");
        this.getCardDao().saveChartRefInfo(chartId, refUid, dsbId);
    }

    public void copyReference(String fromDsbId, String toDsbId, ReferenceMap refMap, List<AbstractThemeManageDomain.IFileRollback> rollbackCollector) throws AbstractQingIntegratedException, SQLException {
        this.getDashboardDao().saveRefInfo(refMap, toDsbId);
        String refUid = refMap.getUid();
        ProgramableCardRef cardRef = this.getCardDao().loadChartRefInfo(fromDsbId, refUid);
        if (cardRef == null) {
            return;
        }
        String oldChartId = cardRef.getChartId();
        String newChartId = ChartRequestUtil.copyChartContent(oldChartId);
        rollbackCollector.add(new ChartFileRollback(newChartId));
        this.getCardDao().saveChartRefInfo(newChartId, refUid, toDsbId);
    }

    public void copyExecutionReference(String fromDsbId, String toDsbId, ReferenceMap refMap, List<AbstractThemeManageDomain.IFileRollback> rollbackCollector, int type) throws AbstractQingIntegratedException, SQLException, PersistentModelParseException, PersistentModelTooModernException {
    }

    public ReferenceMap createRefMap(String refToId) throws AbstractQingException {
        ReferenceMap refMap = new ReferenceMap();
        String uid = UUID.randomUUID().toString();
        refMap.setUid(uid);
        refMap.setRefToId(refToId);
        refMap.setRefType(RefTypeEnum.programableCard.name());
        try {
            ProgramableCard cardInfo = this.getCardDao().loadChartInfo(refToId);
            String rawChartId = cardInfo.getChartId();
            String chartId = ChartRequestUtil.copyChartContent(rawChartId);
            refMap.put((Object)"chartId", (Object)chartId);
        }
        catch (SQLException e) {
            throw new DashboardException((Throwable)e);
        }
        return refMap;
    }

    public void addRefContent(Map<String, String> params, Map<String, Object> result) {
    }

    public void deleteReference(String dsbId, ReferenceMap refMap) throws AbstractQingIntegratedException, SQLException {
        this.getDashboardDao().deleteDsbRef(dsbId, refMap.getUid());
        ProgramableCardRef cardRef = this.getCardDao().loadChartRefInfo(dsbId, refMap.getUid());
        String chartId = cardRef.getChartId();
        ChartRequestUtil.requestDelete(chartId);
        this.getCardDao().deleteChartRefInfo(dsbId, refMap.getUid());
    }

    public void exportRefContent(String dsbId, String dsbFolderPath, boolean isPreset, ReferenceMap referenceMap, ZipOutputStream zos) throws IOException, AbstractQingIntegratedException, SQLException {
        String uid = (String)referenceMap.get((Object)"uid");
        String cardFolderPath = dsbFolderPath + File.separator + "qing-dsb-programablecard";
        DsbProgramableCardRefProperty cardRefProperty = new DsbProgramableCardRefProperty();
        cardRefProperty.setUid(uid);
        String uuid = UUID.randomUUID().toString();
        String cardPropertyXmlPath = cardFolderPath + File.separator + uuid + File.separator + "qing-dsb-programablecard.xml";
        zos.putNextEntry(new ZipEntry(cardPropertyXmlPath));
        XmlUtil.save((Element)cardRefProperty.toXml(), (OutputStream)zos);
        ProgramableCardRef cardRef = this.getCardDao().loadChartRefInfo(dsbId, uid);
        byte[] chartRefContent = ChartRequestUtil.requestExportChart(cardRef.getChartId());
        String chartContentPath = cardFolderPath + File.separator + uuid + File.separator + "qing-dsb-ref-programablecard";
        zos.putNextEntry(new ZipEntry(chartContentPath));
        zos.write(chartRefContent);
    }

    public void exportPublishedRefContent(String publishId, String folderPath, ReferenceMap refMap, IDashboardExportFilePathGetter dashboardExportFilePathGetter, ZipOutputStream zos) throws IOException, SQLException, QingImglibException, AbstractQingIntegratedException {
        String uid = (String)refMap.get((Object)"uid");
        String cardPropertyPath = folderPath + File.separator + dashboardExportFilePathGetter.getProgramableCardPropertyFileNameInZip();
        zos.putNextEntry(new ZipEntry(cardPropertyPath));
        DsbProgramableCardRefProperty cardRefProperty = new DsbProgramableCardRefProperty();
        cardRefProperty.setUid(uid);
        cardRefProperty.setRefType((String)refMap.get((Object)"refType"));
        XmlUtil.save((Element)cardRefProperty.toXml(), (OutputStream)zos);
        String cardFilePath = folderPath + File.separator + dashboardExportFilePathGetter.getProgramableCardFileInZip();
        ProgramableCardPubRef cardRef = this.getCardDao().loadPublishChartRefInfo(publishId, uid);
        byte[] chartRefContent = ChartRequestUtil.requestExportChart(cardRef.getChartId());
        zos.putNextEntry(new ZipEntry(cardFilePath));
        zos.write(chartRefContent);
    }

    public void importRefContent(String dsbId, DashboardImportModel dsbImportModel, List<IQingFile> successImportFile) throws PersistentModelParseException, PersistentModelTooModernException, AbstractQingIntegratedException, SQLException, QingImglibException, IOException {
        List dsbProgramableCardProperties = dsbImportModel.getContentProperties(this.refType);
        List chartFileKeys = dsbImportModel.getFileKeys(this.refType);
        if (dsbProgramableCardProperties != null && chartFileKeys != null) {
            for (int i = 0; i < dsbProgramableCardProperties.size(); ++i) {
                DsbProgramableCardRefProperty dsbProgramableCardProperty = (DsbProgramableCardRefProperty)dsbProgramableCardProperties.get(i);
                String chartFileKey = (String)chartFileKeys.get(i);
                String uid = dsbProgramableCardProperty.getUid();
                ProgramableCardFileCache cardFileCache = new ProgramableCardFileCache(chartFileKey);
                if (cardFileCache.exists()) {
                    byte[] content = cardFileCache.getContent();
                    String chartId = this.getImExporter().importChartFile(content);
                    this.getCardDao().saveChartRefInfo(chartId, uid, dsbId);
                }
                ReferenceMap item = new ReferenceMap();
                item.setRefType(this.refType.name());
                item.setUid(uid);
                this.getDashboardDao().saveRefInfo(item, dsbId);
            }
        }
    }

    public List<ReferenceMap> importPublishedRefContent(String publishId, DashboardImportModel dsbImportModel, DashboardPublishImportModel dashboardPublishImportModel, List<IQingFile> successImportFile) throws ImportThemeException, AbstractQingIntegratedException {
        List fileKeys = dashboardPublishImportModel.getFileKeys(this.refType);
        List properties = dashboardPublishImportModel.getContentProperties(this.refType);
        ArrayList<ReferenceMap> refItems = new ArrayList<ReferenceMap>();
        if (fileKeys != null && properties != null) {
            try {
                for (int i = 0; i < properties.size(); ++i) {
                    DsbProgramableCardRefProperty property = (DsbProgramableCardRefProperty)properties.get(i);
                    String fileKey = (String)fileKeys.get(i);
                    ProgramableCardFileCache cardFileCache = new ProgramableCardFileCache(fileKey);
                    String uid = property.getUid();
                    if (cardFileCache.exists()) {
                        byte[] content = cardFileCache.getContent();
                        String chartId = this.getImExporter().importChartFile(content);
                        this.getCardDao().savePublishChartRefInfo(chartId, uid, publishId);
                    }
                    ReferenceMap item = new ReferenceMap();
                    item.setRefType(this.refType.name());
                    item.setUid(uid);
                    refItems.add(item);
                }
            }
            catch (Exception e) {
                throw new ImportThemeException((Throwable)e);
            }
        }
        return refItems;
    }

    public void deletePublishContent(String publishId) throws AbstractQingIntegratedException, SQLException {
        List<ProgramableCardPubRef> refInfos = this.getCardDao().loadAllPubChartRefInfo(publishId);
        for (ProgramableCardPubRef refInfo : refInfos) {
            String chartId = refInfo.getChartId();
            ChartRequestUtil.requestDelete(chartId);
        }
        this.getCardDao().deletePublishChartRefInfo(publishId);
    }

    public void savePublishReference(String dsbId, String publishId, ReferenceMap refMap, ModelBook modelBook) throws PersistentModelParseException, PersistentModelTooModernException, SQLException, AbstractQingIntegratedException {
        this.getDashboardPublishDao().saveRefInfo(refMap, publishId);
        String rawChartId = (String)refMap.get((Object)"chartId");
        String uid = refMap.getUid();
        if (rawChartId == null) {
            ProgramableCardRef cardRefInfo = this.getCardDao().loadChartRefInfo(dsbId, uid);
            rawChartId = cardRefInfo.getChartId();
        }
        String chartId = ChartRequestUtil.copyChartContent(rawChartId);
        this.getCardDao().savePublishChartRefInfo(chartId, uid, publishId);
    }

    public void createPublishedCarryDataDataSource(String tag, PublishPO publishPO, ReferenceMap referenceMap) throws SubjectModelParseException, PublishedPrepareDataException, ModelParseException, AbstractQingIntegratedException, SQLException, IOException {
    }

    public void separateImportModel(DashboardPublishImportModel dsbPublishImportModel, ExportDsbSchemaProperty dsbSchemaProperty, String schemaFileKey) {
    }

    public void separateImportModel(DashboardImportModel dsbImportModel, ExportDsbSchemaProperty dsbSchemaProperty, String schemaFileKey) {
    }

    public String loadRefFullPath(ReferenceMap refMap, String userId) throws AbstractQingIntegratedException, SQLException {
        return null;
    }

    public ISwitchPathAndIdHandler getSwitchPathAndIdHandler() {
        return null;
    }

    public void updatePublishedRef(String publishId, ReferenceMap refMap) throws AbstractQingIntegratedException, SQLException, DashboardException {
    }

    public void deletePublishedRef(String publishId, String refUid, String refToId) throws AbstractQingIntegratedException, SQLException {
    }

    public void exportSource(String tag, ReferenceMap referenceMap, PackageMeta meta) throws AbstractQingException, SQLException, IOException, JDOMException {
    }

    public void cacheQHFDataSource(String refTag, ReferenceMap referenceMap, ImportedModel importedModel) throws ImportException {
    }

    public AbstractDataSourceInfoVO getQHFDataSourceInfo(String tag, ReferenceMap referenceMap, ImportedModel importedModel) throws ImportException {
        return null;
    }

    private static class ChartFileRollback
    implements AbstractThemeManageDomain.IFileRollback {
        private String chartId;

        public ChartFileRollback(String chartId) {
            this.chartId = chartId;
        }

        public void rollback() {
            try {
                ChartRequestUtil.requestDelete(this.chartId);
            }
            catch (AbstractQingIntegratedException e) {
                LogUtil.error((String)("delete programable chart failed when copy chart failed,chartId=" + this.chartId));
            }
        }
    }
}

