/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.guimenu.refHandler;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.common.ref.AbstractSwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.publish.appmenu.dao.AppMenuDao;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.domain.CommonPublishDomain;
import com.kingdee.bos.qing.publish.guimenu.dao.GUIMenuDao;
import com.kingdee.bos.qing.publish.integrated.model.TreeMenuFolderNode;
import com.kingdee.bos.qing.publish.model.PublishPO;
import java.sql.SQLException;
import java.util.List;

public class GUIMenuSwitchPathAndIdHandler
extends AbstractSwitchPathAndIdHandler {
    private AppMenuDao appMenuDao;
    private PublishInfoDao publishInfoDao;
    private GUIMenuDao guiMenuDao;
    private CommonPublishDomain commonPublishDomain;

    private PublishInfoDao getPublishInfoDao() {
        if (this.publishInfoDao == null) {
            this.publishInfoDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishInfoDao;
    }

    private CommonPublishDomain getCommonPublishDomain() {
        if (this.commonPublishDomain == null) {
            this.commonPublishDomain = new CommonPublishDomain(this.context, this.tx, this.dbExcuter);
        }
        return this.commonPublishDomain;
    }

    private AppMenuDao getAppMenuDao() {
        if (this.appMenuDao == null) {
            this.appMenuDao = new AppMenuDao(this.context, this.dbExcuter);
        }
        return this.appMenuDao;
    }

    public GUIMenuSwitchPathAndIdHandler(QingContext context, ITransactionManagement tx, IDBExcuter dbExcuter) {
        super(context, tx, dbExcuter);
    }

    private GUIMenuDao getGUIMenuDao() {
        if (this.guiMenuDao == null) {
            this.guiMenuDao = new GUIMenuDao(this.context, this.dbExcuter);
        }
        return this.guiMenuDao;
    }

    public String switchRefPathToId(String refPath, String name, String userId) throws AbstractQingIntegratedException, SQLException {
        List publishPOs = this.getPublishInfoDao().loadPublishInfoByTypeAndName(userId, 4, name);
        for (int i = 0; i < publishPOs.size(); ++i) {
            PublishPO publishPO = (PublishPO)publishPOs.get(i);
            String path = publishPO.getPath();
            TreeMenuFolderNode guiMenuTree = this.getGUIMenuDao().getGUIMenuTree(false);
            path = path.replaceFirst("/EAS_GUI_CENTER_ROOT_UUID", "");
            String publishFolderPathName = TreeMenuFolderNode.buildPathText(guiMenuTree, path);
            String publishFolderPathName_old = TreeMenuFolderNode.buildPathText(guiMenuTree, publishPO.getPath());
            publishFolderPathName = publishFolderPathName.replaceAll("/", "-");
            publishFolderPathName_old = publishFolderPathName_old.replaceAll("/", "-");
            if (!refPath.equals(publishFolderPathName) && !refPath.equals(publishFolderPathName_old)) continue;
            return publishPO.getId();
        }
        return null;
    }

    public String switchRefIdToPath(String refToId, String userId) throws AbstractQingIntegratedException, SQLException {
        String fullPath = null;
        PublishPO publishPO = this.getCommonPublishDomain().loadPublishInfo(refToId);
        if (publishPO != null) {
            TreeMenuFolderNode guiMenuTree = this.getGUIMenuDao().getGUIMenuTree(false);
            String path = publishPO.getPath();
            path = path.replaceFirst("/EAS_GUI_CENTER_ROOT_UUID", "");
            String publishFolderPathName = TreeMenuFolderNode.buildPathText(guiMenuTree, path);
            publishFolderPathName = publishFolderPathName.replaceAll("/", "-");
            String nameSpace = publishPO.isPreset() ? NameSpace.system.toPersistance() : NameSpace.user.toPersistance();
            fullPath = nameSpace + "/" + publishFolderPathName + "/" + publishPO.getName();
        }
        return fullPath;
    }

    public void replacePersistentPathToId(String refPath, String refId, String userId) throws SQLException, AbstractQingIntegratedException {
        this.updateRefPathToId(RefTypeEnum.guimenu, refPath, refId, userId);
    }

    public void replacePersistentIdToPath(String refPath, String refToId, String userId) throws SQLException, AbstractQingIntegratedException {
        this.updateRefIdToPath(RefTypeEnum.guimenu, refPath, refToId, userId);
    }

    public boolean RefIsPreset(String refToId) throws AbstractQingIntegratedException, SQLException {
        PublishPO publishInfo = this.getPublishInfoDao().getPublishInfoByInfoId(refToId);
        if (publishInfo != null) {
            return publishInfo.isPreset();
        }
        return false;
    }

    public String switchRefPathToId(String fullPath, String userId) throws AbstractQingIntegratedException, SQLException {
        String[] path = fullPath.split("/");
        if (path.length > 2) {
            String publishName = path[path.length - 1];
            List publishPOs = this.getPublishInfoDao().loadPublishInfoByTypeAndName(userId, 4, publishName);
            String refPath = path[path.length - 2];
            for (int i = 0; i < publishPOs.size(); ++i) {
                PublishPO publishPO = (PublishPO)publishPOs.get(i);
                String publishPath = publishPO.getPath();
                TreeMenuFolderNode guiMenuTree = this.getGUIMenuDao().getGUIMenuTree(false);
                publishPath = publishPath.replaceFirst("/EAS_GUI_CENTER_ROOT_UUID", "");
                String publishFolderPathName = TreeMenuFolderNode.buildPathText(guiMenuTree, publishPath);
                String publishFolderPathName_old = TreeMenuFolderNode.buildPathText(guiMenuTree, publishPO.getPath());
                publishFolderPathName = publishFolderPathName.replaceAll("/", "-");
                publishFolderPathName_old = publishFolderPathName_old.replaceAll("/", "-");
                if (!refPath.equals(publishFolderPathName) && !refPath.equals(publishFolderPathName_old)) continue;
                return publishPO.getId();
            }
        }
        return null;
    }

    public String createEmptyPath() {
        return null;
    }
}

