/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.lapp.thirdapp;

import com.kingdee.bos.Context;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.dao.impl.DBExcuterImpl;
import com.kingdee.bos.qing.common.dao.impl.TXManageImpl;
import com.kingdee.bos.qing.data.model.runtime.compare.sqlcondition.InSqlConditionBuilder;
import com.kingdee.bos.qing.publish.lapp.domain.ILappContextHelper;
import com.kingdee.bos.qing.publish.lapp.thirdapp.AbstractThirdAppContext;
import com.kingdee.bos.qing.publish.lapp.util.LappContextUtils;
import com.kingdee.bos.qing.publish.lapp.util.UserContextConverter;
import com.kingdee.bos.qing.publish.target.lapp.model.LappContext;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DDOfflineContext
extends AbstractThirdAppContext {
    @Override
    public LappContext.UserType getUserType() {
        return LappContext.UserType.DINGDING_OFFLINE_CORPID_USERID;
    }

    @Override
    public LappContext getLappContext(Context ctx, String currentUserId, ILappContextHelper lappContextHelper) {
        return this.getLappContextByUserId(ctx, currentUserId, lappContextHelper);
    }

    @Override
    public List<LappContext> getLappContexts(Context ctx, List<String> userIds, ILappContextHelper lappContextHelper) {
        TXManageImpl tx = new TXManageImpl(ctx);
        DBExcuterImpl dbExcuter = new DBExcuterImpl(tx);
        if (this.useSyncTool()) {
            return this.getLappContextsUseSyncTool(dbExcuter, userIds);
        }
        return this.getLappContexts(dbExcuter, userIds);
    }

    private List<LappContext> getLappContexts(IDBExcuter dbExcuter, List<String> userIds) {
        List<Object> result = new ArrayList<LappContext>();
        ArrayList<String> remainUserIds = new ArrayList<String>(userIds);
        String sqlInQuestion = "?";
        if (remainUserIds != null && remainUserIds.size() > 0) {
            for (int i = 1; i < remainUserIds.size(); ++i) {
                sqlInQuestion = sqlInQuestion + ",?";
            }
        } else {
            return result;
        }
        String sql = "SELECT FCORPID, FUSERID, FDINGDINGUSERID FROM T_PM_EASDINGDINGUSERMAP WHERE FUSERID IN (" + sqlInQuestion + ")";
        logger.info((Object)sql);
        try {
            Map mapResult = new HashMap();
            mapResult = (Map)dbExcuter.query(sql, userIds.toArray(), (ResultHandler)new ResultHandler<Map<String, List>>(){

                public Map<String, List> handle(ResultSet rs) throws SQLException {
                    return DDOfflineContext.getLappContextByRS(rs);
                }
            });
            result = (List)mapResult.get("lappContextList");
            List successUserIds = (List)mapResult.get("successUserIds");
            remainUserIds.removeAll(successUserIds);
            for (int i = 0; i < remainUserIds.size(); ++i) {
                LappContext context = new LappContext();
                context.setUserId((String)remainUserIds.get(i));
                context.setLappUserId("");
                context.setLappUserType(LappContext.UserType.DINGDING_OFFLINE_CORPID_USERID);
                result.add(context);
            }
            return result;
        }
        catch (Exception e) {
            logger.error((Object)("dingding\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25: " + e.getMessage()), (Throwable)e);
            return result;
        }
    }

    private static Map<String, List> getLappContextByRS(ResultSet rs) throws SQLException {
        HashMap<String, List> mapResult = new HashMap<String, List>();
        ArrayList<LappContext> lappContextList = new ArrayList<LappContext>();
        ArrayList<String> successUserIds = new ArrayList<String>();
        while (rs.next()) {
            LappContext result = new LappContext();
            String corpid = rs.getString("FCORPID");
            String dingdingUserId = rs.getString("FDINGDINGUSERID");
            if (corpid == null || corpid.trim().isEmpty() || dingdingUserId == null || dingdingUserId.trim().isEmpty()) continue;
            String userId = rs.getString("FUSERID");
            result.setUserId(userId);
            result.setLappUserId(LappContextUtils.EncryptUtil.encrypt(corpid + "," + dingdingUserId));
            result.setLappUserType(LappContext.UserType.DINGDING_OFFLINE_CORPID_USERID);
            result.setCorpId(corpid);
            lappContextList.add(result);
            successUserIds.add(userId);
        }
        mapResult.put("lappContextList", lappContextList);
        mapResult.put("successUserIds", successUserIds);
        return mapResult;
    }

    @Override
    public String getLappContextToken(Context ctx, ILappContextHelper lappContextHelper) {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userId = userInfo.getId().toString();
        LappContext lappContext = this.getLappContext(ctx, userId, null);
        if (StringUtils.isBlank((CharSequence)lappContext.getLappUserId())) {
            return null;
        }
        if (this.useSyncTool()) {
            return lappContext.getLappUserId();
        }
        return this.getDDOfflineToken(lappContext);
    }

    private String getDDOfflineToken(LappContext lappContext) {
        String corpIdAndDDUserId = LappContextUtils.EncryptUtil.decrypt(lappContext.getLappUserId());
        String[] params = corpIdAndDDUserId.split(",");
        String dingdingCorpId = params[0];
        String dingdingUserId = params[1];
        String token = LappContextUtils.EncryptUtil.encrypt(dingdingCorpId + "," + dingdingUserId + "," + System.currentTimeMillis());
        return token;
    }

    private List<LappContext> getLappContextsUseSyncTool(IDBExcuter dbExcuter, List<String> userIds) {
        ArrayList<String> remainUserIds = new ArrayList<String>(userIds);
        List<LappContext> result = this.getOriginLappContextsUseSyncTool(dbExcuter, userIds);
        for (LappContext lappContext : result) {
            String corpId = lappContext.getCorpId();
            String ddUserId = lappContext.getLappUserId();
            lappContext.setLappUserId(UserContextConverter.encrypt(corpId, ddUserId));
            remainUserIds.remove(lappContext.getUserId());
        }
        for (int i = 0; i < remainUserIds.size(); ++i) {
            LappContext lappContext;
            lappContext = new LappContext();
            lappContext.setUserId((String)remainUserIds.get(i));
            lappContext.setLappUserId("");
            lappContext.setLappUserType(LappContext.UserType.DINGDING_OFFLINE_CORPID_USERID);
            result.add(lappContext);
        }
        return result;
    }

    private List<LappContext> getOriginLappContextsUseSyncTool(IDBExcuter dbExcuter, List<String> userIds) {
        final ArrayList<LappContext> result = new ArrayList<LappContext>();
        final String corpId = this.getCorpId();
        InSqlConditionBuilder inSqlConditionBuilder = new InSqlConditionBuilder(userIds.size());
        StringBuilder sql = new StringBuilder("SELECT FXTID, FUSERID FROM T_PM_EASDTUSERMAP WHERE  ");
        sql.append(inSqlConditionBuilder.build("FUSERID"));
        try {
            return (List)dbExcuter.query(sql.toString(), userIds.toArray(), (ResultHandler)new ResultHandler<List<LappContext>>(){

                public List<LappContext> handle(ResultSet rs) throws SQLException {
                    while (rs.next()) {
                        String ddUserId = rs.getString("FXTID");
                        String userId = rs.getString("FUSERID");
                        if (!StringUtils.isNotBlank((CharSequence)corpId) || !StringUtils.isNotBlank((CharSequence)ddUserId)) continue;
                        LappContext lappContext = new LappContext();
                        lappContext.setLappUserId(ddUserId);
                        lappContext.setLappUserType(LappContext.UserType.DINGDING_OFFLINE_CORPID_USERID);
                        lappContext.setCorpId(corpId);
                        lappContext.setUserId(userId);
                        result.add(lappContext);
                    }
                    return result;
                }
            });
        }
        catch (Exception e) {
            logger.info((Object)("dingding\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25: " + e.getMessage()), (Throwable)e);
            return result;
        }
    }

    private String getCorpId() {
        Map<String, String> properties = LappContextUtils.getConfigProperties(this.getUserType());
        return properties.get("corpId");
    }
}

