/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.lapp.util;

import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.math.BigInteger;
import java.nio.charset.Charset;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.RSAKeyParameters;

public class UserContextConverter {
    private static final String SPLIT_STR = ",";
    private static final String CONVERTER_VERSION_1_ = "CONVERTERVERSION1_";

    public static String encrypt(String corpId, String userId) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)corpId)) {
            corpId = "";
        }
        if (StringUtils.isBlank((CharSequence)userId)) {
            userId = "";
        }
        sb.append(corpId).append(SPLIT_STR);
        sb.append(userId).append(SPLIT_STR);
        sb.append(System.currentTimeMillis());
        try {
            return CONVERTER_VERSION_1_ + RSAEncryptUtils.encryptByPublicKey(sb.toString());
        }
        catch (InvalidCipherTextException e) {
            LogUtil.error((String)"InvalidCipherTextException", (Throwable)e);
            return null;
        }
    }

    public static class RSAEncryptUtils {
        private static final BigInteger mod = new BigInteger("9ead9f3a082fea9ff05fe34f843ab9c63332bae270d12c9082f20a16df92dc7bdcf7a752cd8dfdd7ee9814e9e0edfd70d70f138937cd674265845d3782f47e61a8f69f8d6364fb56a22fce58aca552c1dc2f771ba9b55947e45225a00b10d14f6c6d3e5510c76b1c6159fd34e861ed45865e3934635544fbe72124dbe6b2a43f", 16);
        private static final BigInteger pubExp = new BigInteger("10001", 16);

        public static String encryptByPublicKey(String message) throws InvalidCipherTextException {
            RSAKeyParameters k = new RSAKeyParameters(false, mod, pubExp);
            RSAEngine engine = new RSAEngine();
            engine.init(true, (CipherParameters)k);
            byte[] bMes = message.getBytes(Charset.forName("UTF-8"));
            byte[] rs = engine.processBlock(bMes, 0, bMes.length);
            BigInteger bi = new BigInteger(rs);
            return bi.toString();
        }
    }
}

