/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.schedule.executer.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.i18n.EASMessages;
import com.kingdee.bos.qing.datasource.spec.mult.MultiDataThreadLocalUtil;
import com.kingdee.bos.qing.publish.exception.PublishNotFoundException;
import com.kingdee.bos.qing.publish.lapp.domain.LappContextDomain;
import com.kingdee.bos.qing.publish.target.lapp.model.LappContext;
import com.kingdee.bos.qing.publish.thumbnail.ThumbnailDomainForExcuteDomain;
import com.kingdee.bos.qing.publish.thumbnail.dao.ThumbnailInfoDao;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schedule.ScheduleEngine;
import com.kingdee.bos.qing.schedule.app.ScheduleException;
import com.kingdee.bos.qing.schedule.executer.AbstractScheduleExecuter;
import com.kingdee.bos.qing.schedule.model.ExecuteStateEnum;
import com.kingdee.bos.qing.schedule.model.ScheduleExecutePO;
import com.kingdee.bos.qing.util.LogUtil;

public class UpdateLappThumbnailScheduleExecuter
extends AbstractScheduleExecuter {
    private LappContextDomain lappContextDomain;

    private LappContextDomain getLappContextDomain() {
        if (this.lappContextDomain == null) {
            this.lappContextDomain = new LappContextDomain(this.qingContext, this.dbExcuter, this.tx, this.scheduleEngine);
        }
        return this.lappContextDomain;
    }

    @Override
    public void execute(Context ctx, String params, String userId, String orgId) throws Exception {
        LappContext lappCtx = this.getLappContextDomain().getLappContext(ctx);
        ThumbnailDomainForExcuteDomain thumbnailDomainForExcuteDomain = new ThumbnailDomainForExcuteDomain(this.qingContext, this.tx, this.dbExcuter, (IScheduleEngine)new ScheduleEngine());
        try {
            MultiDataThreadLocalUtil.setAsyncJoin((Boolean)false);
            thumbnailDomainForExcuteDomain.singleGenerateAndUpdateMobileImage(params, true, lappCtx);
        }
        catch (PublishNotFoundException e) {
            try {
                this.scheduleEngine.deleteJob(this.qingContext, null, params);
            }
            catch (Exception e1) {
                LogUtil.error((String)e1.getMessage(), (Throwable)e1);
            }
            String msg = "updateThumbnail failed.,userId =" + userId + ",themeId=" + params;
            throw new ScheduleException(msg, e);
        }
        catch (Exception e) {
            String msg = "updateThumbnail failed.,userId =" + userId + ",themeId=" + params;
            throw new ScheduleException(msg, e);
        }
        finally {
            MultiDataThreadLocalUtil.remove();
        }
    }

    @Override
    public ScheduleExecutePO getScheduleExecutePO(QingContext qingContext, String params, ExecuteStateEnum executeStateEnum) {
        String sourceId = params;
        String scheduleName = EASMessages.getMLS(qingContext, "updataLappThumbnailSchedule", "\u8f7b\u5e94\u7528\u622a\u56fe\u8c03\u5ea6\u5b9a\u65f6\u4efb\u52a1-") + sourceId;
        String sourceName = EASMessages.getMLS(qingContext, "updataLappThumbnailSchedule", "\u8f7b\u5e94\u7528\u622a\u56fe\u8c03\u5ea6\u5b9a\u65f6\u4efb\u52a1-") + sourceId;
        try {
            ThumbnailInfoDao thumbnailInfoDao = new ThumbnailInfoDao(this.dbExcuter);
            String publishName = thumbnailInfoDao.getPublishNameByAnalysisId(sourceId);
            if (publishName != null && publishName.length() > 36) {
                sourceName = publishName.substring(0, publishName.length() - 36);
            }
        }
        catch (Exception e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
        String scheduleNameEnum = "updateLappThumbnail";
        ScheduleExecutePO scheduleExecutePO = new ScheduleExecutePO();
        scheduleExecutePO.setTenantId(qingContext.getTenantId());
        scheduleExecutePO.setUserId(qingContext.getUserId());
        scheduleExecutePO.setScheduleName(scheduleName);
        scheduleExecutePO.setSourceId(sourceId);
        scheduleExecutePO.setSourceName(sourceName);
        scheduleExecutePO.setScheduleExecuterNameEnum(scheduleNameEnum);
        scheduleExecutePO.setExecuteStateEnum(executeStateEnum);
        return scheduleExecutePO;
    }
}

