/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.explorer.common;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.explorer.manage.exception.BadDataException;
import com.kingdee.bos.ctrl.explorer.manage.exception.NotExitSourceException;
import com.kingdee.bos.ctrl.explorer.manage.exception.SourceManageException;
import com.kingdee.bos.ctrl.explorer.use.IExtUsedFacade;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class BlockDownLoader {
    private static final Logger log = LogUtil.getPackageLogger(BlockDownLoader.class);
    private IExtUsedFacade _extManage;
    private String _fid;
    private File _diskCache;

    public BlockDownLoader(String fid, IExtUsedFacade extManage) {
        this._fid = fid;
        this._extManage = extManage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File loadSource() throws SourceManageException {
        if (!this._extManage.checkIdExist(this._fid)) {
            throw new NotExitSourceException("id: " + this._fid + " not exit");
        }
        int blockCount = this._extManage.blockCount(this._fid);
        FileOutputStream outputer = null;
        try {
            if (this._diskCache == null) {
                this._diskCache = File.createTempFile("Temp", ".extsource");
            }
            outputer = new FileOutputStream(this._diskCache);
            for (int i = 0; i < blockCount; ++i) {
                byte[] block = this._extManage.downdataBlock(this._fid, i);
                if (block.length == 0) {
                    throw new BadDataException("Empty block ,bad data!");
                }
                if (block == null || block.length == 0) continue;
                outputer.write(block);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (outputer != null) {
                try {
                    outputer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return this._diskCache;
    }

    public BufferedImage getImage() throws SourceManageException {
        try {
            BufferedImage image = ImageIO.read(this.loadSource());
            return image;
        }
        catch (IOException ex) {
            throw SourceManageException.wrap(ex);
        }
        catch (SourceManageException e) {
            this.destroy();
            throw e;
        }
    }

    public void destroy() {
        if (this._diskCache != null) {
            this._diskCache.delete();
            this._diskCache = null;
        }
    }
}

