/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.explorer.manage.server;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.explorer.common.BlockDownLoader;
import com.kingdee.bos.ctrl.explorer.common.server.ExtManageAccess;
import com.kingdee.bos.ctrl.explorer.manage.IExtManageFacade;
import com.kingdee.bos.ctrl.explorer.manage.exception.SourceManageException;
import com.kingdee.bos.ctrl.explorer.model.ILightSource;
import com.kingdee.bos.ctrl.explorer.use.server.ExtUseFacade;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.ctrl.extcommon.server.ServerUtil;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class ExtManageFacade
extends ORMObject
implements IExtManageFacade {
    public static final Logger log = LogUtil.getPackageLogger(ExtManageFacade.class);

    public ExtManageFacade() {
        this.registerInterface(IExtManageFacade.class, this);
    }

    @Override
    public void deleteBlock(String fid) throws SourceManageException {
        String sql = "DELETE FROM T_EXT_ExplorerData WHERE FID='" + fid + "'";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will exec:" + sql));
        }
        try {
            DbUtil.executeUpdate(sql, null);
        }
        catch (SQLException ex) {
            throw SourceManageException.wrap(ex);
        }
    }

    @Override
    public void deleteLightSource(String fid) throws SourceManageException {
        String sql = "DELETE FROM T_EXT_ExplorerInfo WHERE FID='" + fid + "'";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will exec:" + sql));
        }
        try {
            DbUtil.executeUpdate(sql, null);
        }
        catch (SQLException ex) {
            throw SourceManageException.wrap(ex);
        }
    }

    private void deletePathLightSource(String path, String orgID) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM T_EXT_ExplorerInfo");
        sql.append(" WHERE FPath='" + path + "'");
        sql.append(" and FOrgID='" + orgID + "'");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will exec:" + sql));
        }
        DbUtil.executeUpdate(sql.toString(), null);
    }

    @Override
    public void deleteSource(String fid) throws SourceManageException {
        this.deleteLightSource(fid);
        this.deleteBlock(fid);
    }

    @Override
    public List getAllSource() throws SourceManageException {
        StringBuffer sql = new StringBuffer();
        sql.append("select * from T_EXT_ExplorerInfo");
        sql.append(" where FName <>");
        sql.append("'").append("ClxOwe88SRAMeb0P").append("'");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will exec:" + sql.toString()));
        }
        ArrayList<ILightSource> result = new ArrayList<ILightSource>();
        try {
            IRowSet rs = DbUtil.executeQuery(sql.toString(), null);
            while (rs.next()) {
                result.add(ExtManageAccess.createLightSource(rs));
            }
        }
        catch (SQLException ex) {
            throw SourceManageException.wrap(ex);
        }
        return result;
    }

    @Override
    public List getFreshTreeSource(String orgID) throws SourceManageException {
        StringBuffer sql = new StringBuffer();
        sql.append("select * from ").append("T_EXT_ExplorerInfo");
        sql.append(" where FName =");
        sql.append("'").append("ClxOwe88SRAMeb0P").append("'");
        sql.append(" and FOrgID in ('");
        sql.append(orgID).append("','").append("5oUFBlMRzXgW3A9f").append("')");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will exec:" + sql.toString()));
        }
        ArrayList<ILightSource> result = new ArrayList<ILightSource>();
        try {
            IRowSet rs = DbUtil.executeQuery(sql.toString(), null);
            while (rs.next()) {
                result.add(ExtManageAccess.createLightSource(rs));
            }
        }
        catch (SQLException ex) {
            throw SourceManageException.wrap(ex);
        }
        return result;
    }

    @Override
    public List getPathSource(String path, String orgID) throws SourceManageException {
        try {
            return ExtManageAccess.getPathSource(path, orgID);
        }
        catch (SQLException ex) {
            throw SourceManageException.wrap(ex);
        }
    }

    @Override
    public void deletePathSource(String path, String orgID) throws SourceManageException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FID from T_EXT_ExplorerInfo");
        sql.append(" where FPath ='" + path + "'");
        sql.append(" and FOrgID ='" + orgID + "'");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will exec:" + sql.toString()));
        }
        try {
            IRowSet rs = DbUtil.executeQuery(sql.toString(), null);
            while (rs.next()) {
                String id = rs.getString("FID");
                this.deleteBlock(id);
            }
            this.deletePathLightSource(path, orgID);
        }
        catch (SQLException e) {
            throw SourceManageException.wrap(e);
        }
    }

    @Override
    public List getFullPathSource(String path, String orgID) throws SourceManageException {
        try {
            return ExtManageAccess.getFullPathSource(path, orgID);
        }
        catch (SQLException ex) {
            throw SourceManageException.wrap(ex);
        }
    }

    @Override
    public ILightSource getLightSource(String id) throws SourceManageException {
        try {
            return ExtManageAccess.getLightSource(id);
        }
        catch (SQLException ex) {
            throw SourceManageException.wrap(ex);
        }
    }

    @Override
    public byte[] getBreviary(String id) throws SourceManageException {
        try {
            return ExtManageAccess.getBreviary(id);
        }
        catch (SQLException ex) {
            throw SourceManageException.wrap(ex);
        }
    }

    @Override
    public void updataBlock(String fid, int index, byte[] block, long count) throws SourceManageException {
        if (index == 0) {
            this.deleteBlock(fid);
            try {
                this.insertEmptyBlock(fid, count);
            }
            catch (SQLException e) {
                throw SourceManageException.wrap(e);
            }
        }
        StringBuffer sb = new StringBuffer("");
        sb.append("UPDATE ").append("T_EXT_ExplorerData");
        sb.append(" SET FSource=?");
        sb.append(" WHERE FID=");
        sb.append("'").append(fid).append("'");
        sb.append(" AND FIndex=");
        sb.append(index);
        Object[] parm = new Object[]{block};
        try {
            DbUtil.executeUpdate(sb.toString(), parm);
        }
        catch (SQLException e) {
            throw SourceManageException.wrap(e);
        }
    }

    @Override
    public void updataPath(String oldPath, String newPath, String ordID) throws SourceManageException {
        try {
            ExtManageAccess.updataPath(oldPath, newPath, ordID);
        }
        catch (SQLException e) {
            throw SourceManageException.wrap(e);
        }
    }

    @Override
    public ILightSource updataLightSource(ILightSource source) throws SourceManageException {
        try {
            Context context = ServerUtil.getContext();
            String id = context.getCaller().toString();
            source.setCreator(ExtManageAccess.getUerName(id));
            source.setCreatorID(id);
            String currentDate = ServerUtil.getCurrentDate();
            Timestamp ts = Timestamp.valueOf(currentDate);
            source.setCreteTime(ts);
            ExtManageAccess.updateSource(source);
            return source;
        }
        catch (SQLException e) {
            throw SourceManageException.wrap(e);
        }
    }

    private void insertEmptyBlock(String fid, long count) throws SQLException {
        int i = 0;
        while ((long)i < count) {
            StringBuffer sb = new StringBuffer("");
            sb.append("INSERT INTO ").append("T_EXT_ExplorerData");
            sb.append(" (FID,FIndex,FSource) VALUES( ");
            sb.append("'").append(fid).append("'");
            sb.append(",");
            sb.append(i);
            sb.append(",null");
            sb.append(")");
            DbUtil.executeUpdate(sb.toString(), null);
            ++i;
        }
    }

    @Override
    public ILightSource createLightSource(ILightSource source) throws SourceManageException {
        try {
            Context context = ServerUtil.getContext();
            String id = context.getCaller().toString();
            source.setCreator(ExtManageAccess.getUerName(id));
            source.setCreatorID(id);
            String currentDate = ServerUtil.getCurrentDate();
            Timestamp ts = Timestamp.valueOf(currentDate);
            source.setCreteTime(ts);
            ExtManageAccess.saveSource(source);
            return source;
        }
        catch (SQLException e) {
            throw SourceManageException.wrap(e);
        }
    }

    @Override
    public ILightSource createFolderSource(ILightSource source) throws SourceManageException {
        try {
            Context context = ServerUtil.getContext();
            String id = context.getCaller().toString();
            source.setCreator(ExtManageAccess.getUerName(id));
            source.setCreatorID(id);
            String currentDate = ServerUtil.getCurrentDate();
            Timestamp ts = Timestamp.valueOf(currentDate);
            source.setCreteTime(ts);
            ExtManageAccess.createFlolderSource(source);
            return source;
        }
        catch (SQLException e) {
            throw SourceManageException.wrap(e);
        }
    }

    @Override
    public boolean checkExist(String name, String path, String orgID) throws SourceManageException {
        try {
            return ExtManageAccess.checkExist(name, path, orgID, null);
        }
        catch (SQLException e) {
            throw SourceManageException.wrap(e);
        }
    }

    @Override
    public byte[] getViewImage(String fid, int width, int height) throws SourceManageException {
        BlockDownLoader loder = new BlockDownLoader(fid, new ExtUseFacade());
        try {
            BufferedImage image = loder.getImage();
            ByteArrayOutputStream imageStream = new ByteArrayOutputStream();
            boolean resultWrite = ImageIO.write((RenderedImage)image, "jpg", imageStream);
            if (!resultWrite) {
                return null;
            }
            byte[] tagInfo = imageStream.toByteArray();
            return tagInfo;
        }
        catch (IOException e) {
            throw SourceManageException.wrap(e);
        }
    }
}

