/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.manage.server;

import com.kingdee.bos.ctrl.extcommon.server.ServerUtil;
import com.kingdee.bos.ctrl.semantic.design.exception.SemanticDesignException;
import com.kingdee.bos.ctrl.semantic.design.server.DesigntimeManager;
import com.kingdee.bos.ctrl.semantic.design.server.SchemaDesigntimeState;
import com.kingdee.bos.ctrl.semantic.manage.exception.SemanticManageException;
import com.kingdee.bos.ctrl.semantic.model.trans.HeavyContent;
import com.kingdee.bos.ctrl.semantic.model.trans.LazyInfo;
import com.kingdee.bos.ctrl.semantic.model.trans.imexport.ExportModel;
import java.util.HashMap;
import java.util.Map;

class ExportImpl {
    private static int SIZE_PERSEGMENT = 256;
    private static Map _exportingState;

    private static synchronized Map getCache() {
        if (_exportingState == null) {
            _exportingState = new HashMap();
        }
        return _exportingState;
    }

    public static ExportModel getExportModel(String schemaId, String path, int segmentIdx) throws SemanticManageException {
        StringBuffer sb = new StringBuffer();
        sb.append(ServerUtil.getUserName());
        sb.append("@");
        sb.append(schemaId);
        String key = sb.toString();
        try {
            FullData fullData = (FullData)ExportImpl.getCache().get(key);
            if (fullData == null) {
                LazyInfo[] infos = DesigntimeManager.getInst().getState(schemaId).getSubTree(path);
                fullData = new FullData(infos);
                ExportImpl.getCache().put(key, fullData);
            }
            if (fullData.isLastTime(segmentIdx)) {
                ExportImpl.getCache().remove(key);
            }
            return fullData.getExportModel(schemaId, segmentIdx);
        }
        catch (Exception ex) {
            ExportImpl.getCache().remove(key);
            throw SemanticManageException.wrap(ex);
        }
    }

    private static class FullData {
        private LazyInfo[] _allInfos;
        private int _segmentCount;

        public FullData(LazyInfo[] all) {
            this._allInfos = all;
            this._segmentCount = all.length == 0 ? 1 : (all.length - 1) / SIZE_PERSEGMENT + 1;
        }

        public ExportModel getExportModel(String schemaId, int segmentIdx) throws SemanticDesignException {
            int startInfoIdx = SIZE_PERSEGMENT * segmentIdx;
            int endInfoIdx = Math.min(this._allInfos.length, startInfoIdx + SIZE_PERSEGMENT);
            int size = endInfoIdx - startInfoIdx;
            LazyInfo[] infos = new LazyInfo[size];
            HeavyContent[] hcs = new HeavyContent[size];
            SchemaDesigntimeState state = DesigntimeManager.getInst().getState(schemaId);
            for (int i = startInfoIdx; i < endInfoIdx; ++i) {
                int idx = i - startInfoIdx;
                infos[idx] = this._allInfos[i];
                hcs[idx] = state.loadEntity(infos[idx], false, false).getContent();
            }
            ExportModel model = new ExportModel(this._segmentCount, segmentIdx);
            model.setLazyInfos(infos);
            model.setHeavyContents(hcs);
            return model;
        }

        public boolean isLastTime(int segmentIdx) {
            return segmentIdx >= this._segmentCount - 1;
        }
    }
}

