/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.manage.server;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.UID;
import com.kingdee.bos.ctrl.extcommon.server.ServerUtil;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.semantic.design.exception.SemanticDesignException;
import com.kingdee.bos.ctrl.semantic.design.server.DesigntimeManager;
import com.kingdee.bos.ctrl.semantic.design.server.SchemaDesigntimeState;
import com.kingdee.bos.ctrl.semantic.manage.exception.LockedException;
import com.kingdee.bos.ctrl.semantic.manage.exception.NameExistException;
import com.kingdee.bos.ctrl.semantic.manage.exception.NotExistException;
import com.kingdee.bos.ctrl.semantic.manage.exception.SemanticManageException;
import com.kingdee.bos.ctrl.semantic.manage.exception.UnknownVersionException;
import com.kingdee.bos.ctrl.semantic.manage.server.SchemasAccess;
import com.kingdee.bos.ctrl.semantic.model.base.AbstractSemanticEntity;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticExprField;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticField;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticRelation;
import com.kingdee.bos.ctrl.semantic.model.trans.HeavyContent;
import com.kingdee.bos.ctrl.semantic.model.trans.HeavyContentIO;
import com.kingdee.bos.ctrl.semantic.model.trans.InfoWrapper;
import com.kingdee.bos.ctrl.semantic.model.trans.LazyInfo;
import com.kingdee.bos.ctrl.semantic.model.trans.SchemaBriefModel;
import com.kingdee.bos.ctrl.semantic.model.trans.imexport.IImportModel;
import com.kingdee.bos.ctrl.semantic.model.trans.imexport.ImportDecisionItem;
import com.kingdee.bos.ctrl.semantic.model.trans.imexport.ImportDecisionModel;
import com.kingdee.bos.ctrl.semantic.model.trans.imexport.ImportPreference;
import com.kingdee.bos.ctrl.semantic.model.trans.imexport.ImportResultItem;
import com.kingdee.bos.ctrl.semantic.model.trans.imexport.ImportResultModel;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ImportImpl {
    private static final Logger log = LogUtil.getPackageLogger(ImportImpl.class);
    private static final String OLDID = "oldId";
    private static Map _cache;
    private static int PERIOD;
    private static int LIFE;
    private Timer _timer;
    private long _lastActive;
    private String _key;
    private String _schemaId;
    private String _schemaName;
    private File _tempFile;
    private String _outDb;
    private ImportPreference _preference;
    private Map _oldId2newId;
    private Map _importedInfos;
    private Set _waitDelete;
    private Map _existLNameMap;
    private boolean _decideSecondTime;
    private Map _acceptedDecision;
    private Map _acceptedDecisionSecondTime;
    private Map _stdContainsCustomContent;

    private static synchronized Map getCache() {
        if (_cache == null) {
            _cache = new HashMap();
        }
        return _cache;
    }

    public static ImportImpl getInstance(String schemaName, boolean checkExist) throws NotExistException {
        StringBuffer sb = new StringBuffer();
        sb.append(ServerUtil.getUserName());
        sb.append("@");
        sb.append(schemaName);
        String key = sb.toString();
        ImportImpl inst = (ImportImpl)ImportImpl.getCache().get(key);
        if (inst == null) {
            if (checkExist) {
                throw new NotExistException("Must be long time inactive.");
            }
            inst = new ImportImpl();
            inst._key = key;
            inst._schemaName = schemaName;
            ImportImpl.getCache().put(key, inst);
            inst._timer = new Timer(true);
            inst._timer.schedule((TimerTask)new Task(inst), PERIOD, (long)PERIOD);
        }
        inst._lastActive = System.currentTimeMillis();
        return inst;
    }

    public void setSchemaId(String schemaId) {
        this._schemaId = schemaId;
    }

    public void destroy() {
        ImportImpl.getCache().remove(this._key);
        if (!StringUtil.isEmptyString((String)this._schemaId)) {
            try {
                DesigntimeManager.getInst().getState(this._schemaId).setImportUnlock(ServerUtil.getUserName());
            }
            catch (SemanticDesignException ex) {
                log.error((Object)"Unlock import error.", (Throwable)ex);
            }
        }
        if (this._timer != null) {
            this._timer.cancel();
            this._timer = null;
        }
        this._importedInfos = null;
        this._oldId2newId = null;
        this._waitDelete = null;
        this._existLNameMap = null;
        this._acceptedDecision = null;
        this._acceptedDecisionSecondTime = null;
        if (this._tempFile != null) {
            this._tempFile.delete();
            this._tempFile = null;
        }
    }

    public void upload(byte[] segment, int segmentIdx, ImportPreference preference) throws SemanticManageException {
        if (segmentIdx == -1) {
            this.destroy();
            return;
        }
        if (segmentIdx == 0) {
            this._schemaId = SchemasAccess.getSchemaId(this._schemaName);
            this._preference = preference;
            if (preference.isNeedSchemaExist()) {
                if (this._schemaId == null) {
                    throw new NotExistException("Semantic schema " + this._schemaName + " not exist.");
                }
                this.getLockedSchema(true);
            } else if (this._schemaId != null) {
                throw new NameExistException("Semantic schema " + this._schemaName + " exist.");
            }
        }
        if (segment != null && segment.length != 0) {
            FileOutputStream outputer = null;
            try {
                if (this._tempFile == null) {
                    this._tempFile = File.createTempFile("Temp", ".semantic");
                }
                outputer = new FileOutputStream(this._tempFile, segmentIdx > 0);
                outputer.write(segment);
            }
            catch (IOException ex) {
                throw SemanticManageException.wrap(ex);
            }
            finally {
                if (outputer != null) {
                    try {
                        outputer.close();
                    }
                    catch (IOException ex) {
                        log.error((Object)"", (Throwable)ex);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchemaDesigntimeState getLockedSchema(boolean strongCheck) throws SemanticManageException {
        SchemaDesigntimeState state;
        try {
            state = DesigntimeManager.getInst().getState(this._schemaId);
        }
        catch (SemanticDesignException ex) {
            throw SemanticManageException.wrap(ex);
        }
        SchemaDesigntimeState schemaDesigntimeState = state;
        synchronized (schemaDesigntimeState) {
            if (strongCheck && state.isBusy() || state.isImportLock(ServerUtil.getUserName())) {
                throw new LockedException(this._schemaName + " is Editing.");
            }
            state.setImportLock(ServerUtil.getUserName());
        }
        return state;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseXML(DefaultHandler handler) throws SemanticManageException {
        ZipInputStream inputer = null;
        FileInputStream fis = null;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            fis = new FileInputStream(this._tempFile);
            inputer = new ZipInputStream(fis);
            inputer.getNextEntry();
            SAXParser parser = factory.newSAXParser();
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            InputSource inso = new InputSource(inputer);
            inso.setEncoding("UTF-8");
            parser.parse(inso, handler);
        }
        catch (ParserConfigurationException ex) {
            try {
                throw SemanticManageException.wrap(ex);
                catch (SAXException ex2) {
                    throw SemanticManageException.wrap(ex2);
                }
                catch (IOException ex3) {
                    throw SemanticManageException.wrap(ex3);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{inputer, fis});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{inputer, fis});
    }

    public IImportModel imports(ImportDecisionModel decisionModel) throws SemanticManageException {
        if (this._importedInfos == null) {
            this._importedInfos = new HashMap();
            this._oldId2newId = new HashMap();
            this.parseXML(new SaxHandlerForLazyInfo());
        }
        switch (this._preference.getPolicy()) {
            case 0: {
                ImportResultModel result = this.createNewSchema();
                this.destroy();
                return result;
            }
            case 1: {
                ImportResultModel result = this.overwriteSchema();
                this.destroy();
                return result;
            }
            case 2: {
                IImportModel result = this.tryImport(decisionModel);
                if (result instanceof ImportResultModel) {
                    this.destroy();
                }
                return result;
            }
        }
        throw new RuntimeException("You must modify code.");
    }

    private ImportResultModel createNewSchema() throws SemanticManageException {
        SchemaBriefModel sbm = new SchemaBriefModel();
        sbm.setName(this._schemaName);
        if (StringUtil.isEmptyString((String)this._outDb)) {
            sbm.setCurrentDs(true);
        } else {
            sbm.setCurrentDs(false);
            sbm.setOutsideDb(this._outDb);
        }
        sbm = SchemasAccess.createSchema(sbm);
        this._schemaId = sbm.getId();
        try {
            return this.fullCopy();
        }
        catch (SemanticManageException ex) {
            SchemasAccess.deleteSchema(sbm);
            throw ex;
        }
    }

    private ImportResultModel overwriteSchema() throws SemanticManageException {
        boolean isOnlyContent = true;
        SchemaBriefModel sbm = new SchemaBriefModel();
        sbm.setId(this._schemaId);
        sbm.setName(this._schemaName);
        SchemasAccess.deleteSchema(sbm, isOnlyContent);
        return this.fullCopy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImportResultModel fullCopy() throws SemanticManageException {
        SchemaDesigntimeState state = null;
        try {
            state = this.getLockedSchema(false);
            SaxHandlerForSaveEntity handler = new SaxHandlerForSaveEntity(state, false);
            this.parseXML(handler);
            ImportResultModel result = handler.getResult();
            result.setNew(true);
            ImportResultModel importResultModel = result;
            return importResultModel;
        }
        finally {
            if (state != null) {
                state.unregisterEdit(ServerUtil.getUserName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IImportModel tryImport(ImportDecisionModel decisionModel) throws SemanticManageException {
        IImportModel result;
        if (decisionModel == null) {
            decisionModel = this.preTryImport();
            if (decisionModel.isAllItemSolved()) {
                this._decideSecondTime = true;
                this.searchPropertyConflict(decisionModel);
            }
        } else if (this._decideSecondTime) {
            this.tryAcceptDecisionSecondTime(decisionModel);
        } else {
            this.tryAcceptDecisionFirstTime(decisionModel);
            if (decisionModel.isAllItemSolved()) {
                this._decideSecondTime = true;
                this.searchPropertyConflict(decisionModel);
            }
        }
        if (decisionModel.isAllItemSolved()) {
            SchemaDesigntimeState state = null;
            try {
                state = this.getLockedSchema(false);
                result = this.mergeIntoSchema(state);
            }
            finally {
                if (state != null) {
                    state.unregisterEdit(ServerUtil.getUserName());
                }
            }
        } else {
            result = decisionModel;
        }
        return result;
    }

    private ImportResultModel mergeIntoSchema(SchemaDesigntimeState state) throws SemanticManageException {
        ImportResultItem resultItem;
        LazyInfo[] deletes = this._waitDelete.toArray(new LazyInfo[0]);
        if (deletes.length > 0) {
            try {
                state.deleteEntities(deletes);
            }
            catch (SemanticDesignException ex) {
                throw SemanticManageException.wrap(ex);
            }
        }
        SaxHandlerForSaveEntity handler = new SaxHandlerForSaveEntity(state, true);
        this.parseXML(handler);
        ImportResultModel result = handler.getResult();
        for (LazyInfo info : deletes) {
            ImportResultItem item = new ImportResultItem();
            item.setInfo(info);
            ImportDecisionItem decisionItem = null;
            if (this._acceptedDecision != null) {
                decisionItem = (ImportDecisionItem)this._acceptedDecision.remove(info.getPhysicalName().toUpperCase());
            }
            if (decisionItem == null) {
                item.setResult(4100);
            } else {
                item.setResult(8195);
                item.setConfilict(decisionItem.getConfilict());
            }
            result.addItem(item);
        }
        if (this._acceptedDecision != null) {
            for (ImportDecisionItem decisionItem : this._acceptedDecision.values()) {
                resultItem = new ImportResultItem();
                resultItem.setInfo(decisionItem.getDestInfo());
                resultItem.setConfilict(decisionItem.getConfilict());
                if (decisionItem.getConfilict() == 4) {
                    resultItem.setResult(16385);
                } else {
                    resultItem.setResult(ImportResultItem.wrapDecisionResult(decisionItem.getDecision()));
                }
                result.addItem(resultItem);
            }
        }
        if (this._acceptedDecisionSecondTime != null) {
            for (ImportDecisionItem decisionItem : this._acceptedDecisionSecondTime.values()) {
                resultItem = new ImportResultItem();
                resultItem.setInfo(decisionItem.getSrcInfo());
                resultItem.setResult(ImportResultItem.wrapDecisionResult(decisionItem.getDecision()));
                resultItem.setConfilict(decisionItem.getConfilict());
                result.addItem(resultItem);
            }
        }
        return result;
    }

    private void tryAcceptDecisionFirstTime(ImportDecisionModel decisionModel) {
        int i;
        if (this._acceptedDecision == null) {
            this._acceptedDecision = new HashMap();
        }
        int c = decisionModel.getItemCount();
        block6: for (i = 0; i < c; ++i) {
            ImportDecisionItem item = decisionModel.getItem(i);
            switch (item.getConfilict()) {
                case 1: 
                case 2: {
                    LazyInfo info = item.getDestInfo();
                    if (item.getDecision() == 3) {
                        this._waitDelete.add(info);
                        this._existLNameMap.remove(info.getLogicalName().toUpperCase());
                    }
                    this._acceptedDecision.put(info.getPhysicalName().toUpperCase(), item);
                    continue block6;
                }
                case 3: {
                    this._existLNameMap.remove(item.getDestInfo().getLogicalName().toUpperCase());
                    String pName = item.getSrcInfo().getPhysicalName().toUpperCase();
                    this._acceptedDecision.put(pName, item);
                    continue block6;
                }
                case 4: {
                    String pName = item.getSrcInfo().getPhysicalName().toUpperCase();
                    this._importedInfos.remove(pName);
                    this._acceptedDecision.put(pName, item);
                    continue block6;
                }
                case 5: {
                    String pName = item.getSrcInfo().getPhysicalName().toUpperCase();
                    if (item.getDecision() == 2) {
                        this._existLNameMap.remove(item.getDestInfo().getLogicalName().toUpperCase());
                    } else if (item.getDecision() == 1) {
                        this._importedInfos.remove(pName);
                    }
                    this._acceptedDecision.put(pName, item);
                    continue block6;
                }
            }
        }
        for (i = decisionModel.getItemCount() - 1; i >= 0; --i) {
            ImportDecisionItem item = decisionModel.getItem(i);
            if (!this._acceptedDecision.containsValue(item)) continue;
            decisionModel.removeItem(i);
        }
    }

    private void tryAcceptDecisionSecondTime(ImportDecisionModel decisionModel) {
        int i;
        if (this._acceptedDecisionSecondTime == null) {
            this._acceptedDecisionSecondTime = new HashMap();
        }
        HashSet<String> newReLNames = new HashSet<String>();
        int c = decisionModel.getItemCount();
        block3: for (i = 0; i < c; ++i) {
            ImportDecisionItem item = decisionModel.getItem(i);
            switch (item.getConfilict()) {
                case 6: {
                    if (item.getDecision() != 4) continue block3;
                    LazyInfo info = item.getSrcInfo();
                    String newLName = info.getLogicalName();
                    String newLNameUpperCase = newLName.toUpperCase();
                    if (this.isLNameExist(info) || newReLNames.contains(newLNameUpperCase)) continue block3;
                    String pName = info.getPhysicalName().toUpperCase();
                    LazyInfo srcInfo = (LazyInfo)this._importedInfos.get(pName);
                    srcInfo.setLogicalName(newLName);
                    newReLNames.add(newLNameUpperCase);
                    this._acceptedDecisionSecondTime.put(pName, item);
                    continue block3;
                }
            }
        }
        for (i = decisionModel.getItemCount() - 1; i >= 0; --i) {
            ImportDecisionItem item = decisionModel.getItem(i);
            if (!this._acceptedDecisionSecondTime.containsValue(item)) continue;
            decisionModel.removeItem(i);
        }
    }

    private ImportDecisionModel preTryImport() throws SemanticManageException {
        Map existPNameMap;
        ImportDecisionModel decisionModel = new ImportDecisionModel();
        SchemaDesigntimeState state = this.getLockedSchema(false);
        try {
            existPNameMap = state.getPNameMap();
        }
        catch (SemanticDesignException ex) {
            throw SemanticManageException.wrap(ex);
        }
        this.reverseSerach(state, existPNameMap, decisionModel);
        return decisionModel;
    }

    private void reverseSerach(SchemaDesigntimeState state, Map existPNameMap, ImportDecisionModel decisionModel) {
        this._waitDelete = new HashSet();
        this._existLNameMap = new HashMap();
        for (String pName : existPNameMap.keySet()) {
            LazyInfo existInfo = (LazyInfo)existPNameMap.get(pName);
            String lNameUpperCase = existInfo.getLogicalName().toUpperCase();
            this._existLNameMap.put(lNameUpperCase, existInfo);
            LazyInfo importedInfo = (LazyInfo)this._importedInfos.get(pName);
            if (importedInfo != null) {
                this.changeToExistId(importedInfo, existInfo.getId());
                if (existInfo.isStandard()) {
                    if (importedInfo.isStandard()) {
                        try {
                            if (ImportImpl.after(importedInfo, existInfo)) {
                                if (!ImportImpl.isContainsCustomContent(state, existInfo)) continue;
                                if (this._stdContainsCustomContent == null) {
                                    this._stdContainsCustomContent = new HashMap();
                                }
                                this._stdContainsCustomContent.put(importedInfo, null);
                                continue;
                            }
                            this._importedInfos.remove(pName);
                        }
                        catch (ParseException ex) {
                            log.error((Object)"Invalid standard-stamp.", (Throwable)ex);
                        }
                        continue;
                    }
                    decisionModel.addItem(ImportImpl.createDecisionItem(importedInfo, existInfo, 4));
                    continue;
                }
                if (importedInfo.isStandard()) {
                    decisionModel.addItem(ImportImpl.createDecisionItem(importedInfo, existInfo, 3));
                    continue;
                }
                decisionModel.addItem(ImportImpl.createDecisionItem(importedInfo, existInfo, 5));
                continue;
            }
            if (this._preference.isStdMaker() || !existInfo.isStandard()) {
                decisionModel.addItem(ImportImpl.createDecisionItem(null, existInfo, 2));
                continue;
            }
            if (ImportImpl.isContainsCustomContent(state, existInfo)) {
                decisionModel.addItem(ImportImpl.createDecisionItem(null, existInfo, 1));
                continue;
            }
            this._waitDelete.add(existInfo);
            this._existLNameMap.remove(lNameUpperCase);
        }
    }

    private void changeToExistId(LazyInfo importedInfo, String existId) {
        String importedOldId = (String)importedInfo.getProperty(OLDID);
        importedInfo.setId(existId);
        this._oldId2newId.put(importedOldId, existId);
    }

    private void searchPropertyConflict(ImportDecisionModel decisionModel) {
        for (LazyInfo importedInfo : this._importedInfos.values()) {
            if (!this.isLNameExist(importedInfo)) continue;
            decisionModel.addItem(ImportImpl.createDecisionItem(importedInfo, null, 6));
        }
    }

    private boolean isLNameExist(LazyInfo target) {
        String lName = target.getLogicalName().toUpperCase();
        LazyInfo info = (LazyInfo)this._existLNameMap.get(lName);
        if (info == null) {
            return false;
        }
        return !info.getPhysicalName().equalsIgnoreCase(target.getPhysicalName());
    }

    private static boolean after(LazyInfo info1, LazyInfo info2) throws ParseException {
        Date date1 = ServerUtil.parseDate(info1.getStandardStamp());
        Date date2 = ServerUtil.parseDate(info2.getStandardStamp());
        return date1.after(date2);
    }

    private static ImportDecisionItem createDecisionItem(LazyInfo src, LazyInfo dest, int confilictCode) {
        ImportDecisionItem item = new ImportDecisionItem();
        item.setSrcInfo(src);
        item.setDestInfo(dest);
        item.setConfilict(confilictCode);
        return item;
    }

    private static boolean isContainsCustomContent(SchemaDesigntimeState state, LazyInfo info) {
        try {
            int i;
            InfoWrapper wrapper = state.loadEntity(info, false, false);
            AbstractSemanticEntity model = AbstractSemanticEntity.create(info.getType());
            HeavyContentIO.load(wrapper.getContent(), model, null);
            for (i = model.getFieldCount() - 1; i >= 0; --i) {
                if (model.getField(i).isStandard()) continue;
                return true;
            }
            for (i = model.getExprFieldCount() - 1; i >= 0; --i) {
                if (model.getExprField(i).isStandard()) continue;
                return true;
            }
            for (i = model.getRelationsCount() - 1; i >= 0; --i) {
                if (model.getRelation(i).isStandard()) continue;
                return true;
            }
        }
        catch (SemanticDesignException ex) {
            return false;
        }
        return false;
    }

    static {
        PERIOD = 1800000;
        LIFE = 3600000;
    }

    private static class Task
    extends TimerTask {
        private ImportImpl _target;

        public Task(ImportImpl target) {
            this._target = target;
        }

        @Override
        public void run() {
            if (System.currentTimeMillis() - this._target._lastActive > (long)LIFE) {
                this._target.destroy();
            }
        }
    }

    private class SaxHandlerForSaveEntity
    extends DefaultHandler {
        private SchemaDesigntimeState state;
        private LazyInfo info;
        private String supplierId;
        private boolean isEntity;
        private boolean isRelation;
        private StringBuffer entityData;
        private StringBuffer relationData;
        private boolean isNeedDeepDo;
        private boolean isMerge;
        private Map existPNameMap;
        private ImportResultModel result;

        public SaxHandlerForSaveEntity(SchemaDesigntimeState state, boolean isMerge) {
            this.state = state;
            this.isMerge = isMerge;
        }

        private Map getExistPNameMap() throws SAXException {
            if (this.existPNameMap == null) {
                try {
                    this.existPNameMap = this.state.getPNameMap();
                }
                catch (SemanticDesignException ex) {
                    throw new SAXException(ex);
                }
            }
            return this.existPNameMap;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if ("EWrap".equals(qName)) {
                String pName = attributes.getValue("pN");
                pName = pName.toUpperCase();
                this.isNeedDeepDo = this.isNeedDeepDo(pName);
                if (!this.isNeedDeepDo) {
                    return;
                }
                this.info = (LazyInfo)ImportImpl.this._importedInfos.get(pName);
                this.info.setContent(new HeavyContent());
                this.isEntity = true;
                this.entityData = new StringBuffer();
            } else if ("RWrap".equals(qName) && this.isNeedDeepDo) {
                this.supplierId = attributes.getValue("s");
                this.isRelation = true;
                this.relationData = new StringBuffer();
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!this.isNeedDeepDo) {
                return;
            }
            if ("EWrap".equals(qName)) {
                this.info.getContent().setXml(this.entityData.toString().trim());
                this.save();
                this.isEntity = false;
                this.info = null;
            } else if ("RWrap".equals(qName)) {
                this.supplierId = (String)ImportImpl.this._oldId2newId.get(this.supplierId);
                if (this.supplierId == null) {
                    this.supplierId = UID.create16();
                }
                this.info.getContent().addRelation(this.supplierId, this.relationData.toString().trim());
                this.isRelation = false;
                this.supplierId = null;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.isNeedDeepDo) {
                if (this.isRelation) {
                    this.relationData.append(String.valueOf(ch, start, length));
                } else if (this.isEntity) {
                    this.entityData.append(String.valueOf(ch, start, length));
                }
            }
        }

        private void save() throws SAXException {
            if (this.isMerge) {
                boolean isExist;
                String pName = this.info.getPhysicalName().toUpperCase();
                LazyInfo existInfo = (LazyInfo)this.getExistPNameMap().get(pName);
                boolean bl = isExist = existInfo != null;
                if (isExist) {
                    try {
                        this.tryMergeContent(existInfo, this.info);
                    }
                    catch (SemanticDesignException ex) {
                        throw new SAXException(ex);
                    }
                } else {
                    this.info.putProperty("isNew", Boolean.TRUE);
                }
                this.getResult().addItem(this.createResultItem(isExist));
            } else {
                this.info.putProperty("isNew", Boolean.TRUE);
            }
            try {
                this.state.saveEntity(this.info, this.info.getContent(), false);
            }
            catch (SemanticDesignException ex) {
                throw new SAXException(ex);
            }
            finally {
                this.state.unlockEntity(this.info.getId(), null);
            }
        }

        private void tryMergeContent(LazyInfo existInfo, LazyInfo info) throws SemanticDesignException {
            int i;
            if (ImportImpl.this._stdContainsCustomContent == null || !ImportImpl.this._stdContainsCustomContent.containsKey(info)) {
                return;
            }
            AbstractSemanticEntity existModel = AbstractSemanticEntity.create(existInfo.getType());
            HeavyContentIO.load(existInfo.getContent(), existModel, null);
            AbstractSemanticEntity model = AbstractSemanticEntity.create(info.getType());
            HeavyContentIO.load(info.getContent(), model, null);
            int c = existModel.getFieldCount();
            for (i = 0; i < c; ++i) {
                SemanticField f = existModel.getField(i);
                if (f.isStandard() || model.getField(f.getPhysicalName()) != null) continue;
                model.addField(f);
            }
            c = existModel.getExprFieldCount();
            for (i = 0; i < c; ++i) {
                SemanticExprField ef = existModel.getExprField(i);
                if (ef.isStandard() || model.getExprField(ef.getPhysicalName()) != null) continue;
                model.addExprField(ef);
            }
            c = existModel.getRelationsCount();
            for (i = 0; i < c; ++i) {
                SemanticRelation r = existModel.getRelation(i);
                if (r.isStandard()) continue;
                boolean hasSame = false;
                for (int j = 0; j < model.getRelationsCount(); ++j) {
                    SemanticRelation tempR = model.getRelation(j);
                    if (!SemanticRelation.strictCompare(r, tempR)) continue;
                    hasSame = true;
                    break;
                }
                if (hasSame) continue;
                r.setClient(model);
                model.addRelation(r);
            }
            HeavyContentIO.save(model, info.getContent());
        }

        private boolean isNeedDeepDo(String pName) {
            if (this.isMerge) {
                return ImportImpl.this._importedInfos.containsKey(pName);
            }
            return true;
        }

        public ImportResultModel getResult() {
            if (this.result == null) {
                this.result = new ImportResultModel();
            }
            return this.result;
        }

        private ImportResultItem createResultItem(boolean isExist) {
            ImportResultItem resultItem = new ImportResultItem();
            resultItem.setInfo(this.info);
            ImportDecisionItem decisionItem = null;
            if (ImportImpl.this._acceptedDecision != null) {
                decisionItem = (ImportDecisionItem)ImportImpl.this._acceptedDecision.remove(this.info.getPhysicalName().toUpperCase());
            }
            if (decisionItem == null) {
                if (isExist) {
                    resultItem.setResult(4099);
                } else {
                    resultItem.setResult(4098);
                }
            } else {
                resultItem.setConfilict(decisionItem.getConfilict());
                switch (decisionItem.getConfilict()) {
                    case 3: 
                    case 5: {
                        resultItem.setResult(ImportResultItem.wrapDecisionResult(decisionItem.getDecision()));
                    }
                }
            }
            return resultItem;
        }
    }

    private class SaxHandlerForLazyInfo
    extends DefaultHandler {
        private SaxHandlerForLazyInfo() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("EWrap".equals(qName)) {
                LazyInfo info = this.createLazyInfo(attributes);
                ImportImpl.this._importedInfos.put(info.getPhysicalName().toUpperCase(), info);
            } else if ("Root".equals(qName)) {
                ImportImpl.this._outDb = attributes.getValue("outDb");
                String ver = attributes.getValue("version");
                if (ver == null) {
                    ver = "00.00.00";
                }
                if (ver.compareTo("00.00.00") > 0) {
                    throw new UnknownVersionException(ver, "00.00.00", attributes.getValue("ptInfo"));
                }
            }
        }

        private LazyInfo createLazyInfo(Attributes attributes) {
            String oldId = attributes.getValue("id");
            String newId = UID.create16();
            ImportImpl.this._oldId2newId.put(oldId, newId);
            LazyInfo info = new LazyInfo();
            info.putProperty(ImportImpl.OLDID, oldId);
            info.setId(newId);
            info.setType(Integer.parseInt(attributes.getValue("tp")));
            info.setPhysicalName(attributes.getValue("pN"));
            info.setLogicalName(attributes.getValue("lN"));
            info.setPath(attributes.getValue("pa"));
            info.setStandardStamp(attributes.getValue("st"));
            info.setStandard(info.getStandardStamp() != null);
            return info;
        }
    }
}

