/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.manage.server;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.ctrl.extcommon.server.ServerUtil;
import com.kingdee.bos.ctrl.semantic.model.trans.SchemaBriefModel;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.rpts.ctrlreport.bo.ExtReportOutDBBO;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ShareSchemasAccess {
    public static String[] getOutsideDsList() throws BOSException {
        ArrayList mid = ExtReportOutDBBO.getDBList(ServerUtil.getContext());
        String[] result = new String[mid.size()];
        int c = mid.size();
        for (int i = 0; i < c; ++i) {
            Map map = (Map)mid.get(i);
            result[i] = (String)map.get("fdbcentername");
        }
        return result;
    }

    public static SchemaBriefModel[] refresh() throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select * from T_EXT_SemanticSchema");
        ArrayList<SchemaBriefModel> result = new ArrayList<SchemaBriefModel>();
        IRowSet rs = DbUtil.executeQuery(sql.toString(), null);
        while (rs.next()) {
            String creator = ShareSchemasAccess.getUserText(rs.getString("FCreatorID"));
            String updator = ShareSchemasAccess.getUserText(rs.getString("FLastUpdateUserID"));
            SchemaBriefModel sbm = new SchemaBriefModel();
            sbm.setId(rs.getString("FID"));
            sbm.setName(rs.getString("FName"));
            sbm.setCurrentDs(rs.getInt("FDsType") != 0);
            sbm.setOutsideDb(rs.getString("FDatasource"));
            sbm.setCreator(creator);
            sbm.setCreateTime(rs.getString("FCreateTime"));
            sbm.setUpdator(updator);
            sbm.setUpdateTime(rs.getString("FLastUpdateTime"));
            result.add(sbm);
        }
        return result.toArray(new SchemaBriefModel[0]);
    }

    protected static String getUserText(String userId) throws SQLException {
        if (userId == null) {
            return "";
        }
        Map map = ShareSchemasAccess.queryUser(userId);
        StringBuffer result = new StringBuffer();
        if (map.get("name") != null) {
            result.append(map.get("name"));
        }
        if (map.get("number") != null) {
            result.append("(");
            result.append(map.get("number"));
            result.append(")");
        }
        return result.toString();
    }

    private static Map queryUser(String userId) throws SQLException {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select U.FNumber AS Number,");
        sql.append("U.FName_").append(strLocal).append(" AS Name ");
        sql.append("from T_PM_User U ");
        sql.append("where U.FID=?");
        HashMap<String, String> result = new HashMap<String, String>();
        IRowSet rs = DbUtil.executeQuery(sql.toString(), new String[]{userId});
        if (rs.next()) {
            result.put("number", rs.getString("Number"));
            result.put("name", rs.getString("Name"));
        }
        return result;
    }

    public static boolean checkIdExist(String id) throws SQLException {
        return DbUtil.checkExist("T_EXT_SemanticSchema", "FID", id);
    }

    public static String getUsedOutsideDsName(String schemaId) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FDsType,FDatasource from T_EXT_SemanticSchema where FID=?");
        IRowSet rs = DbUtil.executeQuery(sql.toString(), new Object[]{schemaId});
        if (rs.next()) {
            if (rs.getInt("FDsType") != 0) {
                return "";
            }
            return rs.getString("FDatasource");
        }
        return null;
    }
}

