/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.model.base;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticExprField;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticField;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticRelation;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticTable;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractSemanticEntity {
    private String _physicalName;
    private String _logicalName;
    private List _fields;
    private List _exprFields;
    private List _relations;
    private boolean _isStandard;
    private Map _properties;

    public static AbstractSemanticEntity create(int type) {
        if (type == 1) {
            return new SemanticTable();
        }
        if (type == 2) {
            return new SemanticView();
        }
        throw new RuntimeException("You must modify code.");
    }

    public void setPhysicalName(String name) {
        this._physicalName = name;
    }

    public String getPhysicalName() {
        return this._physicalName;
    }

    public void setLogicalName(String name) {
        this._logicalName = name;
    }

    public String getLogicalName() {
        return this._logicalName;
    }

    private List getFields() {
        if (this._fields == null) {
            this._fields = new ArrayList();
        }
        return this._fields;
    }

    public int getFieldCount() {
        return this.getFields().size();
    }

    public SemanticField getField(int idx) {
        return (SemanticField)this.getFields().get(idx);
    }

    public SemanticField getField(String physicalName) {
        for (SemanticField field : this.getFields()) {
            if (!StringUtil.equalsIgnoreCase((String)physicalName, (String)field.getPhysicalName())) continue;
            return field;
        }
        return null;
    }

    public void addField(SemanticField field) {
        this.getFields().add(field);
    }

    public void removeField(SemanticField field) {
        this.getFields().remove(field);
    }

    public void removeFields() {
        this._fields = null;
    }

    private List getExprFields() {
        if (this._exprFields == null) {
            this._exprFields = new ArrayList();
        }
        return this._exprFields;
    }

    public int getExprFieldCount() {
        return this._exprFields == null ? 0 : this._exprFields.size();
    }

    public SemanticExprField getExprField(int idx) {
        return (SemanticExprField)this.getExprFields().get(idx);
    }

    public SemanticExprField getExprField(String physicalName) {
        for (SemanticExprField expr : this.getExprFields()) {
            if (!StringUtil.equalsIgnoreCase((String)physicalName, (String)expr.getPhysicalName())) continue;
            return expr;
        }
        return null;
    }

    public void addExprField(SemanticExprField exprField) {
        this.getExprFields().add(exprField);
    }

    public void removeExprField(SemanticExprField exprField) {
        this.getExprFields().remove(exprField);
    }

    public void removeExprFields() {
        this._exprFields = null;
    }

    private List getRelationsList() {
        if (this._relations == null) {
            this._relations = new ArrayList();
        }
        return this._relations;
    }

    public void addRelation(SemanticRelation relation) {
        if (relation.getClient() != this) {
            throw new RuntimeException("Sorry, I can't.");
        }
        this.getRelationsList().add(relation);
    }

    public void removeRelation(SemanticRelation relation) {
        this.getRelationsList().remove(relation);
    }

    public int getRelationsCount() {
        if (this._relations == null) {
            return 0;
        }
        return this._relations.size();
    }

    public SemanticRelation getRelation(int idx) {
        return (SemanticRelation)this.getRelationsList().get(idx);
    }

    public void removeRelations() {
        this._relations = null;
    }

    public void setStandard(boolean isStandard) {
        this._isStandard = isStandard;
    }

    public boolean isStandard() {
        return this._isStandard;
    }

    private Map getProperties() {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        return this._properties;
    }

    public void setProperty(String key, Object value) {
        this.getProperties().put(key, value);
    }

    public Object getProperty(String key) {
        if (this._properties == null) {
            return null;
        }
        return this.getProperties().get(key);
    }

    public AbstractSemanticEntity thinClone() {
        AbstractSemanticEntity another = this.innerThinClone();
        another.setLogicalName(this.getLogicalName());
        another.setPhysicalName(this.getPhysicalName());
        another.setStandard(this.isStandard());
        another._properties = this._properties;
        another._fields = this._fields;
        another._exprFields = this._exprFields;
        another._relations = this._relations;
        return another;
    }

    protected abstract AbstractSemanticEntity innerThinClone();
}

