/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.use;

import com.kingdee.bos.ctrl.semantic.model.base.AbstractSemanticEntity;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticRelation;
import com.kingdee.bos.ctrl.semantic.model.trans.SchemaBriefModel;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.jdom2.Element;

public class SemanticUsetimeModel {
    private SchemaBriefModel _schema;
    private Element _xmlPreload;
    private List _entities = new ArrayList();
    private boolean _isInvalid;

    public SemanticUsetimeModel(SchemaBriefModel schema) {
        this._schema = schema;
    }

    public String getSchemaId() {
        return this._schema.getId();
    }

    public String getSchemaName() {
        return this._schema.getName();
    }

    public void updateSchema(SchemaBriefModel schema) {
        this._schema = schema;
    }

    public void setXmlPreload(Element xml) {
        this._xmlPreload = xml;
    }

    public Element getXmlPreload() {
        return this._xmlPreload;
    }

    public void addEntity(AbstractSemanticEntity entity) {
        this._entities.add(entity);
    }

    public AbstractSemanticEntity[] getEntities() {
        return this._entities.toArray(new AbstractSemanticEntity[0]);
    }

    public int getEntityCount() {
        return this._entities.size();
    }

    public void removeEntity(AbstractSemanticEntity entity) {
        this._entities.remove(entity);
    }

    public void removeAllEntities() {
        this._entities.clear();
    }

    public SemanticRelation searchParentRelation(AbstractSemanticEntity supplierModel) {
        int c = this._entities.size();
        for (int i = 0; i < c; ++i) {
            AbstractSemanticEntity entity = (AbstractSemanticEntity)this._entities.get(i);
            if (entity == supplierModel) continue;
            for (int j = 0; j < entity.getRelationsCount(); ++j) {
                SemanticRelation relation = entity.getRelation(j);
                if (relation.getSupplier() != supplierModel) continue;
                return relation;
            }
        }
        return null;
    }

    public AbstractSemanticEntity getRootEntity() {
        int c = this._entities.size();
        for (int i = 0; i < c; ++i) {
            AbstractSemanticEntity entity = (AbstractSemanticEntity)this._entities.get(i);
            if (this.searchParentRelation(entity) != null) continue;
            return entity;
        }
        throw new NoSuchElementException("Model is empty or invalid state.");
    }

    public boolean isInvalid() {
        return this._isInvalid;
    }

    public void setInvalid(boolean isInvalid) {
        this._isInvalid = isInvalid;
    }
}

