/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.use.server;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.datacenter.DataCenterInfo;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.ctrl.extcommon.server.ServerUtil;
import com.kingdee.bos.ctrl.semantic.design.exception.SemanticDesignException;
import com.kingdee.bos.ctrl.semantic.manage.server.ShareSchemasAccess;
import com.kingdee.bos.ctrl.semantic.model.base.AbstractSemanticEntity;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticField;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticRelation;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticTable;
import com.kingdee.bos.ctrl.semantic.model.trans.HeavyContent;
import com.kingdee.bos.ctrl.semantic.model.trans.HeavyContentIO;
import com.kingdee.bos.ctrl.semantic.model.trans.InfoWrapper;
import com.kingdee.bos.ctrl.semantic.model.trans.LazyInfo;
import com.kingdee.bos.ctrl.semantic.model.trans.SchemaBriefModel;
import com.kingdee.bos.ctrl.semantic.use.ISemanticUsedFacade;
import com.kingdee.bos.ctrl.semantic.use.PkRelationModel;
import com.kingdee.bos.ctrl.semantic.use.exception.EntitiesNotFoundException;
import com.kingdee.bos.ctrl.semantic.use.exception.SemanticUsedException;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.eas.rpts.ctrlreport.bo.ExtReportOutDBBO;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public class SemanticUsedFacade
extends ORMObject
implements ISemanticUsedFacade {
    public SemanticUsedFacade() {
        this.registerInterface(ISemanticUsedFacade.class, this);
    }

    @Override
    public SchemaBriefModel[] getSchemas() throws SemanticUsedException {
        try {
            return ShareSchemasAccess.refresh();
        }
        catch (SQLException ex) {
            throw SemanticUsedException.wrap(ex);
        }
    }

    @Override
    public LazyInfo[] refreshTree(String schemaId) throws SemanticUsedException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FPath, FPysicalName, FLogicalName, FType");
        sql.append(" from T_EXT_SemanticEntity");
        sql.append(" where FSchemaID=?");
        ArrayList<LazyInfo> result = new ArrayList<LazyInfo>();
        try {
            IRowSet rowSet = DbUtil.executeQuery(sql.toString(), new Object[]{schemaId});
            while (rowSet.next()) {
                LazyInfo info = SemanticUsedFacade.createLazyInfo(rowSet);
                result.add(info);
            }
        }
        catch (SQLException ex) {
            throw SemanticUsedException.wrap(ex);
        }
        return result.toArray(new LazyInfo[0]);
    }

    @Override
    public InfoWrapper getEntity(String schemaId, String entityId) throws SemanticUsedException, EntitiesNotFoundException {
        LazyInfo info = null;
        if (entityId != null) {
            try {
                info = SemanticUsedFacade.loadFullContent(entityId, true);
            }
            catch (SQLException ex) {
                throw SemanticUsedException.wrap(ex);
            }
        }
        if (info == null) {
            throw new EntitiesNotFoundException(entityId);
        }
        HeavyContent hc = info.getContent();
        HashMap<String, InfoWrapper> mapSuppliers = null;
        int c = hc.getRelationContentCount();
        for (int i = 0; i < c; ++i) {
            LazyInfo supplierInfo;
            String supplierId = hc.getRelationContent(i).getSupplierId();
            try {
                supplierInfo = SemanticUsedFacade.loadFullContent(supplierId, false);
            }
            catch (SQLException ex) {
                throw SemanticUsedException.wrap(ex);
            }
            if (supplierInfo == null) continue;
            if (mapSuppliers == null) {
                mapSuppliers = new HashMap<String, InfoWrapper>();
            }
            mapSuppliers.put(supplierId, new InfoWrapper(supplierInfo, supplierInfo.getContent(), null));
        }
        return new InfoWrapper(info, hc, mapSuppliers);
    }

    private static LazyInfo createLazyInfo(IRowSet rowSet) throws SQLException {
        LazyInfo info = new LazyInfo();
        info.setId(rowSet.getString("FID"));
        info.setPath(rowSet.getString("FPath"));
        info.setPhysicalName(rowSet.getString("FPysicalName"));
        info.setLogicalName(rowSet.getString("FLogicalName"));
        info.setType(rowSet.getInt("FType"));
        return info;
    }

    private static LazyInfo loadFullContent(String entityId, boolean withRelations) throws SQLException {
        HeavyContent heavyContent = new HeavyContent();
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FPath, FPysicalName, FLogicalName, FType, FContent");
        sql.append(" from T_EXT_SemanticEntity");
        sql.append(" where FID=?");
        IRowSet rowSet = DbUtil.executeQuery(sql.toString(), new Object[]{entityId});
        if (!rowSet.next()) {
            return null;
        }
        heavyContent.setXml(rowSet.getString("FContent"));
        LazyInfo info = SemanticUsedFacade.createLazyInfo(rowSet);
        info.setContent(heavyContent);
        if (withRelations) {
            sql = new StringBuffer();
            sql.append("select FSupplierEntityID, FContent");
            sql.append(" from T_EXT_SemanticRelation");
            sql.append(" where FClientEntityID=?");
            rowSet = DbUtil.executeQuery(sql.toString(), new Object[]{entityId});
            while (rowSet.next()) {
                heavyContent.addRelation(rowSet.getString("FSupplierEntityID"), rowSet.getString("FContent"));
            }
        }
        return info;
    }

    @Override
    public PkRelationModel[] getClientEntities(String schemaId, String supplierEntityId) throws SemanticUsedException {
        ArrayList<PkRelationModel> result = new ArrayList<PkRelationModel>();
        StringBuffer sql = new StringBuffer();
        sql.append("select FClientEntityID, TR.FContent as FRXml");
        sql.append(", FLogicalName, TE.FContent as FEXml");
        sql.append(" from T_EXT_SemanticRelation as TR");
        sql.append(" join T_EXT_SemanticEntity as TE");
        sql.append(" on TR.FClientEntityID=TE.FID");
        sql.append(" where FSupplierEntityID=?");
        try {
            IRowSet rowSet = DbUtil.executeQuery(sql.toString(), new Object[]{supplierEntityId});
            while (rowSet.next()) {
                String clientId = rowSet.getString("FClientEntityID");
                String clientName = rowSet.getString("FLogicalName");
                String relationXml = rowSet.getString("FRXml");
                PkRelationModel prm = new PkRelationModel(clientId, relationXml);
                prm.setClientEntityName(clientName);
                SemanticRelation relation = HeavyContentIO.createRelation(relationXml);
                if (StringUtil.isEmptyString((String)relation.getDescription())) {
                    if (relation.getConditionCount() > 0 && relation.getCondition(0) instanceof SemanticRelation.JoinLine) {
                        SemanticTable model = new SemanticTable();
                        HeavyContentIO.loadFields((AbstractSemanticEntity)model, rowSet.getString("FEXml"));
                        String cf = ((SemanticRelation.JoinLine)relation.getCondition(0)).getClientField();
                        SemanticField field = model.getField(cf);
                        prm.setFkRole(field.getLogicalName());
                    }
                } else {
                    prm.setFkRole(relation.getDescription());
                }
                result.add(prm);
            }
        }
        catch (SQLException ex) {
            throw SemanticUsedException.wrap(ex);
        }
        catch (SemanticDesignException ex) {
            throw SemanticUsedException.wrap(ex);
        }
        return result.toArray(new PkRelationModel[0]);
    }

    @Override
    public InfoWrapper[] loadEntities(String schemaId, String[] entitiesNames) throws SemanticUsedException, EntitiesNotFoundException {
        int count = entitiesNames.length;
        Object[] params = new Object[count + 1];
        params[0] = schemaId;
        StringBuffer inParams = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                inParams.append(",");
            }
            inParams.append("?");
            params[i + 1] = entitiesNames[i];
        }
        HashMap<String, String> mapName2Id = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FPysicalName");
        sql.append(" from T_EXT_SemanticEntity");
        sql.append(" where FSchemaID=? and FPysicalName in(");
        sql.append(inParams);
        sql.append(")");
        try {
            IRowSet rowSet = DbUtil.executeQuery(sql.toString(), params);
            while (rowSet.next()) {
                String pName = rowSet.getString("FPysicalName");
                String id = rowSet.getString("FID");
                mapName2Id.put(pName, id);
            }
        }
        catch (SQLException ex) {
            throw SemanticUsedException.wrap(ex);
        }
        EntitiesNotFoundException notFoundEx = null;
        InfoWrapper[] result = new InfoWrapper[count];
        for (int i = 0; i < count; ++i) {
            try {
                result[i] = this.getEntity(schemaId, (String)mapName2Id.get(entitiesNames[i]));
                continue;
            }
            catch (EntitiesNotFoundException ex) {
                if (notFoundEx == null) {
                    notFoundEx = new EntitiesNotFoundException();
                }
                notFoundEx.addEntity(null, entitiesNames[i]);
            }
        }
        if (notFoundEx != null) {
            throw notFoundEx;
        }
        return result;
    }

    @Override
    public String[] getDbFieldsNames(String tableName, String outsideDb) throws SemanticUsedException {
        String sql = "select KSQL_COL_NAME from KSQL_USERCOLUMNS where KSQL_COL_TABNAME='" + tableName + "'";
        try {
            Connection conn;
            if (StringUtil.isEmptyString((String)outsideDb)) {
                conn = DbUtil.getConnection();
            } else {
                DataCenterInfo dcInfo;
                try {
                    dcInfo = ExtReportOutDBBO.getDataCenterFromCache(ServerUtil.getContext(), outsideDb);
                }
                catch (BOSException ex) {
                    throw SemanticUsedException.wrap((Exception)((Object)ex));
                }
                conn = DbUtil.getOutDbConn(dcInfo);
            }
            IRowSet rowSet = DbUtil.executeQuery(conn, sql.toString(), null);
            ArrayList<String> result = new ArrayList<String>();
            while (rowSet.next()) {
                result.add(rowSet.getString("KSQL_COL_NAME"));
            }
            return result.toArray(new String[0]);
        }
        catch (SQLException ex) {
            throw SemanticUsedException.wrap(ex);
        }
    }
}

