/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.cloud.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.analysis.web.solution.tree.ThemeReportTreeNode;
import com.kingdee.bos.ctrl.common.util.STConverter;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IMainMenuItem;
import com.kingdee.eas.base.permission.MainMenuItemFactory;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.uiframe.BizTypeEnum;
import com.kingdee.eas.base.uiframe.IMainFunctionMenu;
import com.kingdee.eas.base.uiframe.ISysMenuItem;
import com.kingdee.eas.base.uiframe.IndustryEnum;
import com.kingdee.eas.base.uiframe.MainFunctionMenuFactory;
import com.kingdee.eas.base.uiframe.OpenMethod;
import com.kingdee.eas.base.uiframe.SysMenuItemCollection;
import com.kingdee.eas.base.uiframe.SysMenuItemFactory;
import com.kingdee.eas.base.uiframe.SysMenuItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.cloud.model.RptCategoryVO;
import com.kingdee.eas.rpts.cloud.service.CloudRptPublishHelper;
import com.kingdee.eas.rpts.cloud.service.IExtCloudRptCategoryController;
import com.kingdee.eas.rpts.ctrlreport.DefineReportInfo;
import com.kingdee.eas.rpts.ctrlreport.IReportFacade;
import com.kingdee.eas.rpts.ctrlreport.ReportFacadeFactory;
import com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.rpts.ctrlreport.mobile.exception.ExtRptBizException;
import com.kingdee.eas.rpts.ctrlreport.mobile.server.PubAcctsDAO;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.model.ExtContextUtils;
import com.kingdee.eas.rpts.sumreport.util.BaseUuid;
import com.kingdee.eas.rpts.sumreport.util.ExtUuidException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.tree.TreeModel;

public class ExtCloudRptCategoryControllerBean
implements IExtCloudRptCategoryController {
    private Context easCtx;
    private ISysMenuItem iSysMenuItem;
    private IMainMenuItem iMainMenuItem;
    private SysMenuItemInfo parentMenuItemInfo;
    private MainMenuItemInfo parentMainMenuItemInfo;
    private IMainFunctionMenu iMainFunctionMenu;
    private IReportFacade reportFacade;

    public ExtCloudRptCategoryControllerBean() {
        this.easCtx = ContextUtils.getContextFromSession();
        this.initCache(this.easCtx);
    }

    public ExtCloudRptCategoryControllerBean(Context easCtx) {
        this.easCtx = easCtx;
        this.initCache(easCtx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCloudRptCategoryName(String systemId) throws BOSException, SQLException {
        String sql = "select * from T_EXT_CLOUD_RPT_CATEGORY where fid=?";
        IRowSet rs = DbUtil.executeQuery((Context)this.easCtx, (String)sql, (Object[])new Object[]{systemId});
        String rptCategoryName = null;
        try {
            if (rs.next()) {
                rptCategoryName = rs.getString("FNAME");
            }
        }
        finally {
            this.closeRowSet(rs);
        }
        return rptCategoryName;
    }

    private void closeRowSet(IRowSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMobileCloudRptCategoryName(String systemId) throws BOSException, SQLException {
        String sql = "select fname from t_ext_mobileType where fid=? and fpubAcctId='718ea531-103a-467a-9cf5-7e07410373a5'";
        IRowSet rs = DbUtil.executeQuery((Context)this.easCtx, (String)sql, (Object[])new Object[]{systemId});
        try {
            if (rs.next()) {
                String string = rs.getString("fname");
                return string;
            }
        }
        finally {
            this.closeRowSet(rs);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getCloudRptDeployPath(String fid, int publishType) {
        try {
            DefineReportInfo report = DefineReportBO.getReportInfo(this.easCtx, fid);
            if (report == null) {
                return null;
            }
            if (StringUtil.isEmptyString((String)report.getCloudRptCenterId())) {
                return null;
            }
            String systemID = report.getSystemID();
            DefObj def = new DefObj();
            String path = "";
            if (publishType == 8) {
                String sql = "select fname from t_ext_mobileType where fid=? and fpubAcctId='718ea531-103a-467a-9cf5-7e07410373a5'";
                IRowSet rs = DbUtil.executeQuery((Context)this.easCtx, (String)sql, (Object[])new Object[]{systemID});
                try {
                    if (rs.next()) {
                        path = "/\u5546\u4e1a\u5206\u6790/\u4e91\u62a5\u8868\u4e2d\u5fc3/" + rs.getString("fname");
                    }
                }
                finally {
                    this.closeRowSet(rs);
                }
                def.setName(systemID);
                def.setAlias(path);
                def.setProperty("pubacctid", (Object)"718ea531-103a-467a-9cf5-7e07410373a5");
            } else if (publishType == 1 || publishType == 2 || publishType == 16) {
                String rptCategoryName = this.getCloudRptCategoryName(systemID);
                if (StringUtil.isEmptyString((String)rptCategoryName)) {
                    return null;
                }
                String alias = rptCategoryName;
                if (publishType == 1) {
                    MainMenuItemInfo parent = CloudRptPublishHelper.getPublishGUIParentMenuItem(this.easCtx, rptCategoryName);
                    String longNumber = "/" + parent.getLongNumber();
                    def.setName(parent.getId().toString());
                    def.setAlias("/\u5546\u4e1a\u5206\u6790/\u4e91\u62a5\u8868\u4e2d\u5fc3/" + alias);
                    def.setProperty("number", (Object)longNumber);
                    def.setProperty("lstName", new ArrayList());
                    def.setProperty("data", (Object)parent);
                } else if (publishType == 16) {
                    String easAppCenterId = CloudRptPublishHelper.getPublishEasAppCenterParentID(this.easCtx, rptCategoryName);
                    def.setName(easAppCenterId);
                    def.setAlias("/\u5546\u4e1a\u5206\u6790/\u4e91\u62a5\u8868\u4e2d\u5fc3/" + alias);
                } else if (publishType == 2) {
                    path = this.checkBIMenu(rptCategoryName);
                    String pathText = "\u9876\u7ea7\u76ee\u5f55/\u4e91\u62a5\u8868\u4e2d\u5fc3/" + alias;
                    def.setName(path);
                    def.setAlias("/" + pathText);
                    def.setProperty("path", (Object)path);
                    def.setProperty("pathText", (Object)pathText);
                    def.setProperty("lstName", new ArrayList());
                }
            }
            return def;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public List<RptCategoryVO> getList() throws ExtRptBizException {
        ArrayList<RptCategoryVO> result = new ArrayList<RptCategoryVO>();
        StringBuilder selectSQL = new StringBuilder("SELECT distinct crc.FID,crc.FNAME FROM T_EXT_CLOUD_RPT_CATEGORY crc left join T_BAS_DEFINEREPORT dp on crc.Fid = dp.FSYSTEMID where dp.Fid is not null");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)this.easCtx, (String)selectSQL.toString());
            while (rs.next()) {
                RptCategoryVO temp = new RptCategoryVO();
                temp.setId(rs.getString("FID"));
                temp.setName(rs.getString("FNAME"));
                result.add(temp);
            }
            this.closeRowSet(rs);
        }
        catch (Exception e) {
            try {
                throw ExtRptBizException.newFailed2LoadCloudRptCategorysException(e);
            }
            catch (Throwable throwable) {
                this.closeRowSet(rs);
                throw throwable;
            }
        }
        return result;
    }

    private void initCache(Context context) {
        try {
            FilterInfo filterInfo;
            EntityViewInfo entityViewInfo;
            if (this.iSysMenuItem == null) {
                this.iSysMenuItem = SysMenuItemFactory.getLocalInstance((Context)context);
            }
            if (this.iMainMenuItem == null) {
                this.iMainMenuItem = MainMenuItemFactory.getLocalInstance((Context)context);
            }
            if (this.iMainFunctionMenu == null) {
                this.iMainFunctionMenu = MainFunctionMenuFactory.getLocalInstance((Context)context);
            }
            if (this.reportFacade == null) {
                this.reportFacade = ReportFacadeFactory.getLocalInstance(context);
            }
            if (this.parentMenuItemInfo == null) {
                entityViewInfo = new EntityViewInfo();
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)"OU7oknGyS+2CJyuxW6TfqRdCz6U=", CompareType.EQUALS));
                entityViewInfo.setFilter(filterInfo);
                this.parentMenuItemInfo = this.iSysMenuItem.getSysMenuItemCollection(entityViewInfo).get(0);
            }
            if (this.parentMainMenuItemInfo == null) {
                entityViewInfo = new EntityViewInfo();
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)"OU7oknGyS+2CJyuxW6TfqRdCz6U=", CompareType.EQUALS));
                entityViewInfo.setFilter(filterInfo);
                this.parentMainMenuItemInfo = this.iMainMenuItem.getMainMenuItemCollection(entityViewInfo).get(0);
            }
            RptParams prModel = new RptParams();
            prModel.setString("MethodName", "getBIMenuPath");
            RptParams params = this.reportFacade.commonExecuteNever(prModel);
            TreeModel treeModel = (TreeModel)params.getObject("TreeModel");
            if (treeModel == null) {
                return;
            }
            ThemeReportTreeNode root = (ThemeReportTreeNode)treeModel.getRoot();
            if ((root = this.getChild(root, "\u4e91\u62a5\u8868\u4e2d\u5fc3")) == null) {
                prModel = new RptParams();
                prModel.setString("MethodName", "saveBIMenu");
                prModel.setString("parentNodePath", null);
                prModel.setString("displayName", "\u4e91\u62a5\u8868\u4e2d\u5fc3");
                params = this.reportFacade.commonExecuteNever(prModel);
                prModel = new RptParams();
                prModel.setString("MethodName", "getBIMenuPath");
                params = this.reportFacade.commonExecuteNever(prModel);
                treeModel = (TreeModel)params.getObject("TreeModel");
                root = (ThemeReportTreeNode)treeModel.getRoot();
                root = this.getChild(root, "\u4e91\u62a5\u8868\u4e2d\u5fc3");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private SysMenuItemInfo checkGUIMenu(String name) throws BOSException, EASBizException, ExtRptBizException {
        SysMenuItemInfo menuItemInfo;
        StringBuilder selectSQL = new StringBuilder("select FID FROM T_BAS_SYSMENUITEM WHERE FPARENT = 'OU7oknGyS+2CJyuxW6TfqRdCz6U=' and fname_l2 = '" + name + "'");
        IRowSet rs = null;
        String fid = null;
        try {
            rs = DbUtil.executeQuery((Context)this.easCtx, (String)selectSQL.toString());
            if (rs.next()) {
                fid = rs.getString("fid");
            }
            this.closeRowSet(rs);
        }
        catch (SQLException e) {
            try {
                throw ExtRptBizException.newFailed2LoadCloudRptCategorysException(e);
            }
            catch (Throwable throwable) {
                this.closeRowSet(rs);
                throw throwable;
            }
        }
        if (fid == null) {
            String number = "cloudRpt" + new Date().getTime();
            menuItemInfo = new SysMenuItemInfo();
            BOSUuid uuid = BOSUuid.create((BOSObjectType)menuItemInfo.getBOSType());
            menuItemInfo.setId(uuid);
            menuItemInfo.setMenutype(BizTypeEnum.guimenu);
            HashMap<String, String> mapName = new HashMap<String, String>();
            mapName.put("l1", name);
            mapName.put("l2", name);
            mapName.put("l3", STConverter.sc2tc((String)name));
            LanguageCollection lc = ExtContextUtils.getMetaDataLoader().getSolution().getLanguages();
            int z = lc.size();
            for (int i = 0; i < z; ++i) {
                LanguageInfo li = lc.get(i);
                String alias = (String)mapName.get(li.getLocale().toString());
                menuItemInfo.setName(alias, li.getLocale());
            }
            menuItemInfo.setNumber(number);
            menuItemInfo.setLevel(3);
            menuItemInfo.setOrder("255");
            menuItemInfo.setIndustry(IndustryEnum.standard);
            menuItemInfo.setEnabled(true);
            menuItemInfo.setVisible(true);
            menuItemInfo.setOpenMethod(OpenMethod.DEFAULT);
            menuItemInfo.setParent(this.parentMenuItemInfo);
            menuItemInfo.setLongNumber(this.parentMenuItemInfo.getLongNumber() + "!" + menuItemInfo.getNumber());
            this.iSysMenuItem.addnew((CoreBaseInfo)menuItemInfo);
        } else {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)fid, CompareType.EQUALS));
            entityViewInfo.setFilter(filterInfo);
            SysMenuItemCollection collection = this.iSysMenuItem.getSysMenuItemCollection(entityViewInfo);
            menuItemInfo = collection.get(0);
        }
        boolean isMenuImported = this.iMainFunctionMenu.isMenuImported(menuItemInfo.getLongNumber(), true);
        if (!isMenuImported) {
            this.iMainFunctionMenu.importMenu(menuItemInfo, this.parentMainMenuItemInfo, true);
        }
        return menuItemInfo;
    }

    private void checkPortalMenu(String name) throws BOSException {
        String uuidString = Uuid.create().toString();
        String portalMenuItemName = "{\"en\":\"" + name + "\",\"zh_CN\":\"" + name + "\",\"zh_TW\":\"" + STConverter.sc2tc((String)name) + "\"}";
        String portalMenuItemName2 = "{\"en\":\"%\",\"zh_CN\":\"" + name + "\",\"zh_TW\":\"" + STConverter.sc2tc((String)name) + "\"}";
        String updateTime = CtrlReportUtil.formatDateTime(new Date());
        String sqlIf = "(select 1 from T_JP_Page where FDisplayName like '" + portalMenuItemName2 + "'and FNodePath like '/2f9ef722-255b-4e4b-8d07-5277e353a321/2b7f4215-aa17-4d89-952e-efc97833cee6/89064a33-395d-4bed-a180-3cf3ad1a95cf/16d1943d-cad5-47dc-8b80-935ab3deeb22/%')";
        String sqlInsert = "if not exists " + sqlIf + "\t\t\tInsert Into T_JP_Page(FId,FCreateTime,FCreator,FLastUpdateTime,FLastUpdater,FHidden,FNodeLevel,FNodeOrder,FNodePath,FParentNodeId,FPageNumber,FDisplayName,FNodeType,FNodeExt,FDescription,FSettingInfo,FStatus,FIcon,FPermViewCtrl,FPermEditCtrl,FResLevel,FUserId,FPreferences,FDefaultPageId,FControlParam,FShowPltButton,FFirstSpell,FAllSpell,FCanSearch,FCanAddFav)\t\t\tValues('" + uuidString + "',{ts'" + updateTime + " '},'administrator',{ts'" + updateTime + " '},'administrator',0,4,10000,'/2f9ef722-255b-4e4b-8d07-5277e353a321/2b7f4215-aa17-4d89-952e-efc97833cee6/89064a33-395d-4bed-a180-3cf3ad1a95cf/16d1943d-cad5-47dc-8b80-935ab3deeb22/" + uuidString + "','16d1943d-cad5-47dc-8b80-935ab3deeb22',null,\t\t\t\t\t'" + portalMenuItemName + "','FOLDER',null,'{\"en\":\"\",\"zh_CN\":\"\",\"zh_TW\":\"\"}',null,'ENABLE','',0,0,'EXT','portal_template_user','4',null,null,null,'ybbzx','yunbaobiaozhongxin',null,1);";
        String sqlUpdate = "if exists " + sqlIf + " update T_JP_Page set FDisplayName='" + portalMenuItemName + "' where FDisplayName like '" + portalMenuItemName2 + "'and FNodePath like '/2f9ef722-255b-4e4b-8d07-5277e353a321/2b7f4215-aa17-4d89-952e-efc97833cee6/89064a33-395d-4bed-a180-3cf3ad1a95cf/16d1943d-cad5-47dc-8b80-935ab3deeb22/%';";
        DbUtil.execute((Context)this.easCtx, (String)sqlInsert);
        DbUtil.execute((Context)this.easCtx, (String)sqlUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMobileMenu(String name) throws ExtRptBizException, BOSException, ExtUuidException, SQLException {
        IRowSet rs = null;
        try {
            PubAcctsDAO.PubAcct pubAcct = PubAcctsDAO.findPubAcct(this.easCtx, "718ea531-103a-467a-9cf5-7e07410373a5");
            if (pubAcct == null) {
                pubAcct = new PubAcctsDAO.PubAcct();
                pubAcct.fid = "718ea531-103a-467a-9cf5-7e07410373a5";
                pubAcct.name = "\u4e91\u62a5\u8868\u4e2d\u5fc3";
                PubAcctsDAO.addPubAcct(pubAcct);
            }
            String sql = "select 1 from t_ext_mobileType where fname=? and fpubAcctId='718ea531-103a-467a-9cf5-7e07410373a5'";
            rs = DbUtil.executeQuery((Context)this.easCtx, (String)sql, (Object[])new Object[]{name});
            if (!rs.next()) {
                sql = "insert into t_ext_mobileType values(?,?,?,?)";
                DbUtil.execute((Context)this.easCtx, (String)sql, (Object[])new Object[]{BaseUuid.create().toString(), name, 255, "718ea531-103a-467a-9cf5-7e07410373a5"});
            }
            this.closeRowSet(rs);
        }
        catch (Throwable throwable) {
            this.closeRowSet(rs);
            throw throwable;
        }
    }

    private ThemeReportTreeNode getChild(ThemeReportTreeNode root, String name) {
        if (root == null) {
            return null;
        }
        int childCount = root.getChildCount();
        for (int index = 0; index < childCount; ++index) {
            ThemeReportTreeNode temp = (ThemeReportTreeNode)root.getChildAt(index);
            if (!name.equals(temp.getName())) continue;
            return temp;
        }
        return null;
    }

    private String checkBIMenu(String name) throws BOSException {
        RptParams prModel = new RptParams();
        prModel.setString("MethodName", "getBIMenuPath");
        RptParams params = this.reportFacade.commonExecuteNever(prModel);
        TreeModel treeModel = (TreeModel)params.getObject("TreeModel");
        ThemeReportTreeNode root = (ThemeReportTreeNode)treeModel.getRoot();
        root = this.getChild(root, "\u4e91\u62a5\u8868\u4e2d\u5fc3");
        if (root == null) {
            prModel = new RptParams();
            prModel.setString("MethodName", "saveBIMenu");
            prModel.setString("parentNodePath", null);
            prModel.setString("displayName", "\u4e91\u62a5\u8868\u4e2d\u5fc3");
            params = this.reportFacade.commonExecuteNever(prModel);
            prModel = new RptParams();
            prModel.setString("MethodName", "getBIMenuPath");
            params = this.reportFacade.commonExecuteNever(prModel);
            treeModel = (TreeModel)params.getObject("TreeModel");
            root = (ThemeReportTreeNode)treeModel.getRoot();
            root = this.getChild(root, "\u4e91\u62a5\u8868\u4e2d\u5fc3");
        }
        String parentNodePath = root.getRepositoryPath();
        if ((root = this.getChild(root, name)) == null) {
            prModel = new RptParams();
            prModel.setString("MethodName", "saveBIMenu");
            prModel.setString("parentNodePath", parentNodePath);
            prModel.setString("displayName", name);
            params = this.reportFacade.commonExecuteNever(prModel);
            prModel = new RptParams();
            prModel.setString("MethodName", "getBIMenuPath");
            params = this.reportFacade.commonExecuteNever(prModel);
            treeModel = (TreeModel)params.getObject("TreeModel");
            root = (ThemeReportTreeNode)treeModel.getRoot();
            root = this.getChild(root, "\u4e91\u62a5\u8868\u4e2d\u5fc3");
            root = this.getChild(root, name);
        }
        parentNodePath = root.getRepositoryPath();
        return parentNodePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkRptCategory(String name) throws ExtRptBizException {
        String fid = null;
        StringBuilder selectSQL = new StringBuilder("SELECT FID,FNAME FROM T_EXT_CLOUD_RPT_CATEGORY WHERE FNAME=?");
        Class<ExtCloudRptCategoryControllerBean> clazz = ExtCloudRptCategoryControllerBean.class;
        synchronized (ExtCloudRptCategoryControllerBean.class) {
            try {
                IRowSet rs = DbUtil.executeQuery((Context)this.easCtx, (String)selectSQL.toString(), (Object[])new Object[]{name});
                if (rs.next()) {
                    fid = rs.getString("FID");
                }
                if (StringUtil.isEmptyString(fid)) {
                    StringBuilder insertSQL = new StringBuilder("INSERT INTO T_EXT_CLOUD_RPT_CATEGORY(FID,FNAME) VALUES(?,?)");
                    fid = Uuid.randomUUID().toString();
                    DbUtil.execute((Context)this.easCtx, (String)insertSQL.toString(), (Object[])new Object[]{fid, name});
                }
                this.initCache(this.easCtx);
                this.checkGUIMenu(name);
                this.checkPortalMenu(name);
                this.checkMobileMenu(name);
                this.checkBIMenu(name);
            }
            catch (BOSException e) {
                throw ExtRptBizException.newFailed2CheckCloudRptCategorysException(e);
            }
            catch (SQLException e) {
                throw ExtRptBizException.newFailed2CheckCloudRptCategorysException(e);
            }
            catch (EASBizException e) {
                throw ExtRptBizException.newFailed2CheckCloudRptCategorysException(e);
            }
            catch (ExtUuidException e) {
                throw ExtRptBizException.newFailed2CheckCloudRptCategorysException(e);
            }
            catch (ExtRptBizException e) {
                throw ExtRptBizException.newFailed2CheckCloudRptCategorysException(e);
            }
            return fid;
        }
    }

    @Override
    public String getMobileRptCategoryIdByName(String name) throws ExtRptBizException {
        this.checkRptCategory(name);
        try {
            String sql = "select fid from t_ext_mobileType where fname=? and fpubAcctId='718ea531-103a-467a-9cf5-7e07410373a5'";
            IRowSet rs = DbUtil.executeQuery((Context)this.easCtx, (String)sql, (Object[])new Object[]{name});
            if (rs.next()) {
                return rs.getString("fid");
            }
        }
        catch (BOSException e) {
            throw ExtRptBizException.newFailed2LoadCloudRptCategorysException(e);
        }
        catch (SQLException e) {
            throw ExtRptBizException.newFailed2LoadCloudRptCategorysException(e);
        }
        return null;
    }

    @Override
    public String getRptCategoryIdByName(String name) throws ExtRptBizException {
        this.checkRptCategory(name);
        IRowSet rs = null;
        try {
            String sql = "SELECT FID,FNAME FROM T_EXT_CLOUD_RPT_CATEGORY WHERE FNAME=?";
            rs = DbUtil.executeQuery((Context)this.easCtx, (String)sql, (Object[])new Object[]{name});
            if (rs.next()) {
                String string = rs.getString("FID");
                this.closeRowSet(rs);
                return string;
            }
            this.closeRowSet(rs);
        }
        catch (Exception e) {
            try {
                throw ExtRptBizException.newFailed2LoadCloudRptCategorysException(e);
            }
            catch (Throwable throwable) {
                this.closeRowSet(rs);
                throw throwable;
            }
        }
        return null;
    }

    @Override
    public boolean hasCloudReport(String rptCategoryName) {
        String sql = "select c.* from T_BAS_DefineReport r left join T_EXT_CLOUD_RPT_CATEGORY c on r.FSYSTEMID = c.fid where c.fid is not null and c.fname=?";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.easCtx, (String)sql, (Object[])new Object[]{rptCategoryName});
            if (rs.next()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public Context getContext() {
        return this.easCtx;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public BOSObjectType getType() {
        return new BOSObjectType("326B333E2");
    }

    public IORMModel queryInterface(Class type) throws ORMCoreException {
        return this;
    }
}

