/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.audittool;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.ctrl.extcommon.server.ServerUtil;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlreport.DefineReportInfo;
import com.kingdee.eas.rpts.ctrlreport.audittool.DeployRptStat;
import com.kingdee.eas.rpts.ctrlreport.data.PublishType;
import com.kingdee.eas.rpts.sumreport.util.BaseUuid;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class ReportAuditDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RptParams queryReportExecuted(Context ctx, RptParams params) {
        String reportId = params.getString("reportId");
        ArrayList statResult = (ArrayList)params.getObject("statResult");
        String sql = "";
        int statType = params.getInt("stat");
        switch (statType) {
            case 0: {
                sql = "select * from T_EXT_RptAuditSum where freportid=? order by fstatdate desc;";
                break;
            }
            case 1: {
                String statDate = params.getString("clickCellValue");
                sql = "select * from T_EXT_RptAuditList where freportid=? and charindex('" + statDate + "',tochar(fstatdate, 'yyyy-MM-dd'))>0 order by fstatdate desc;";
            }
        }
        Object[] param = new Object[]{reportId};
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery(sql, param);
            if (rs != null) {
                while (rs.next()) {
                    DeployRptStat stat = new DeployRptStat();
                    stat.setReportId(rs.getString("freportid"));
                    stat.setStatDate(rs.getDate("fstatdate"));
                    switch (statType) {
                        case 0: {
                            stat.setViews(rs.getInt("fviews"));
                            stat.setAllViews(rs.getInt("fallviews"));
                            break;
                        }
                        case 1: {
                            stat.setExecuteTime(rs.getInt("fexecutetime"));
                            stat.setExecutor(rs.getString("fexecutor"));
                            stat.setExecutePath(rs.getString("fexecutepath"));
                            stat.setType(rs.getString("foperationtype"));
                        }
                    }
                    statResult.add(stat);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RptParams updateAllViews(Context ctx, RptParams params) {
        block8: {
            IRowSet r = null;
            IRowSet rs = null;
            IRowSet rs1 = null;
            Connection conn = null;
            try {
                String sqlSum;
                conn = this.getConnection(ctx);
                String hasUpdate = "select 1 from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'fisupdate' and KSQL_COL_TABNAME = 'T_EXT_RptAuditSum'";
                r = this.executeQuery(conn, hasUpdate, null);
                if (r == null || !r.next()) {
                    String sqlAlter = "alter table T_EXT_RptAuditSum add fisupdate int default 1;";
                    DbUtil.executeUpdate(conn, sqlAlter, null);
                }
                if ((rs = this.executeQuery(conn, sqlSum = "select freportid, tochar(fstatdate, 'yyyy-MM-dd') as fstatdate from T_EXT_RptAuditSum where fisupdate = 1 order by freportid, fstatdate desc", null)) != null) {
                    while (rs.next()) {
                        String statdate;
                        String sqlDetail = "select count(*) from T_EXT_RptAuditList where freportid = ? and tochar(fstatdate, 'yyyy-MM-dd') <= ?";
                        String reportId = rs.getString("freportid");
                        Object[] param = new Object[]{reportId, statdate = rs.getString("fstatdate")};
                        rs1 = this.executeQuery(conn, sqlDetail, param);
                        if (rs1 == null || !rs1.next()) continue;
                        String sqlUpdate = "update T_EXT_RptAuditSum set fallviews = ?, fisupdate = 2 where freportid = ? and tochar(fstatdate, 'yyyy-MM-dd') = ?";
                        Object[] param1 = new Object[]{new Integer(rs1.getInt(1)), reportId, statdate};
                        DbUtil.executeUpdate(conn, sqlUpdate, param1);
                    }
                }
                SQLUtils.cleanup(rs1);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block8;
            }
            finally {
                SQLUtils.cleanup(rs1);
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(r);
                SQLUtils.cleanup((Connection)conn);
            }
            SQLUtils.cleanup((ResultSet)rs);
            SQLUtils.cleanup((ResultSet)r);
            SQLUtils.cleanup((Connection)conn);
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RptParams getReportInfos(Context ctx, RptParams params) {
        IRowSet rs;
        block12: {
            String systemID = params.getString("systemID");
            ArrayList reportInfos = (ArrayList)params.getObject("reportInfo");
            String orgId = params.getString("orgId");
            StringBuilder selectSql = new StringBuilder();
            Object[] param = null;
            switch (params.getInt("orgIsolatType")) {
                case 0: {
                    selectSql.append("select fid, fname_l2, fdeploypath, fbipath, fportletname, fmobilename, feaswebappcenterid from t_bas_definereport where fsystemid=? ");
                    param = new Object[]{systemID};
                    break;
                }
                case 1: {
                    selectSql.append("select fid, fname_l2, fdeploypath, fbipath, fportletname, fmobilename, feaswebappcenterid from t_bas_definereport where fsystemid=? and (forgid=? or fisstdproduct=1)");
                    param = new Object[]{systemID, orgId};
                }
            }
            switch (params.getInt("requestRptType")) {
                case 0: {
                    selectSql.append(" and (fdeploypath is not null or fbipath is not null or fportletname is not null or fmobilename is not null )");
                    break;
                }
            }
            rs = null;
            try {
                rs = DbUtil.executeQuery(selectSql.toString(), param);
                if (rs == null) break block12;
                while (rs.next()) {
                    DefineReportInfo info = new DefineReportInfo();
                    info.setId(BOSUuid.read((String)rs.getString(1)));
                    info.setName(rs.getString(2));
                    info.setIsDeploy(PublishType.isPublished(rs));
                    reportInfos.add(info);
                }
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)rs);
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RptParams getAllReportInfos(Context ctx, RptParams params) {
        IRowSet rs;
        block12: {
            ArrayList reportInfos = (ArrayList)params.getObject("reportInfo");
            String orgId = params.getString("orgId");
            StringBuilder selectSql = new StringBuilder();
            Object[] param = null;
            switch (params.getInt("orgIsolatType")) {
                case 0: {
                    selectSql.append("select fid, fname_l2, fdeploypath, fbipath, fportletname, fmobilename, feaswebappcenterid, fsystemid from t_bas_definereport where 1=1 ");
                    param = new Object[]{};
                    break;
                }
                case 1: {
                    selectSql.append("select fid, fname_l2, fdeploypath, fbipath, fportletname, fmobilename, feaswebappcenterid, fsystemid from t_bas_definereport where (forgid=? or fisstdproduct=1)");
                    param = new Object[]{orgId};
                }
            }
            switch (params.getInt("requestRptType")) {
                case 0: {
                    selectSql.append(" and (fdeploypath is not null or fbipath is not null or fportletname is not null or fmobilename is not null )");
                    break;
                }
            }
            rs = null;
            try {
                rs = DbUtil.executeQuery(selectSql.toString(), param);
                if (rs == null) break block12;
                while (rs.next()) {
                    DefineReportInfo info = new DefineReportInfo();
                    info.setId(BOSUuid.read((String)rs.getString(1)));
                    info.setName(rs.getString(2));
                    info.setIsDeploy(PublishType.isPublished(rs));
                    info.setSystemID(rs.getString("fsystemid"));
                    reportInfos.add(info);
                }
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)rs);
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RptParams updateAuditTable(Context ctx, RptParams params) {
        DefineReportInfo reportInfo = (DefineReportInfo)params.getObject("reportInfo");
        String reportId = reportInfo.getId().toString();
        String sqlSumUpdate = "update T_EXT_RptAuditSum set fviews=fviews+1, fallviews=fallviews+1 where charindex(tochar(now(), 'yyyy-MM-dd'),tochar(fstatdate, 'yyyy-MM-dd'))>0 and freportid=?";
        Object[] parmUpdate = new Object[]{reportId};
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            int updateRows = DbUtil.executeUpdate(conn, sqlSumUpdate, parmUpdate);
            if (updateRows <= 0) {
                this.insertAuditSum(ctx, conn, reportId);
            }
            this.insertAuditDetail(ctx, conn, reportInfo, params);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertAuditExport(Context ctx, RptParams params) {
        DefineReportInfo reportInfo = (DefineReportInfo)params.getObject("reportInfo");
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            this.insertAuditExportDetail(ctx, conn, reportInfo, params);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertAuditExportDetail(Context ctx, Connection conn, DefineReportInfo reportInfo, RptParams params) throws SQLException {
        String userNumber = null;
        if (ctx == null) {
            ctx = ServerUtil.getContext();
        }
        String userId = ctx.getCaller().toString();
        String selectUserSql = "select fnumber from t_pm_user where fid = ?";
        Object[] paramUser = new Object[]{userId};
        if (conn.isClosed()) {
            conn = this.getConnection(ctx);
        }
        IRowSet rs = null;
        try {
            rs = this.executeQuery(conn, selectUserSql, paramUser);
            if (rs != null && rs.next()) {
                userNumber = rs.getString(1);
            }
            String exportID = BaseUuid.create().toString();
            long executeTime = params.getLong("executeTime");
            String path = this.getDeployPath(reportInfo, params);
            String sqlDetail = "insert into T_EXT_RptAuditList (fid,freportid,fstatdate,fexecutetime,fexecutor,fexecutepath,foperationtype) values (?,?,now(),?,?,?,?);";
            Object[] paramDetail = new Object[]{exportID, reportInfo.getId().toString(), new Long(executeTime), userNumber, path, "\u5bfc\u51fa"};
            DbUtil.executeUpdate(conn, sqlDetail, paramDetail);
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertAuditSum(Context ctx, Connection conn, String reportId) throws SQLException {
        String sqlSumSelect = "select top 1 fallViews from T_EXT_RptAuditSum where freportid=? order by fstatdate desc;";
        Object[] paramSumSelect = new Object[]{reportId};
        IRowSet rs = null;
        try {
            rs = this.executeQuery(conn, sqlSumSelect, paramSumSelect);
            int fAllViews = 0;
            if (rs != null && rs.next()) {
                fAllViews = rs.getInt(1);
            }
            String sqlSum = "insert into T_EXT_RptAuditSum (fid,freportid,fstatdate,fviews,fallviews,fisupdate) values (?,?,now(),?,?,2);";
            String sumId = BaseUuid.create().toString();
            Object[] paramSumInsert = new Object[]{sumId, reportId, new Integer(1), new Integer(fAllViews + 1)};
            if (conn.isClosed()) {
                conn = this.getConnection(ctx);
            }
            DbUtil.executeUpdate(conn, sqlSum, paramSumInsert);
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertAuditDetail(Context ctx, Connection conn, DefineReportInfo reportInfo, RptParams params) throws SQLException {
        String userNumber = null;
        if (ctx == null) {
            ctx = ServerUtil.getContext();
        }
        String userId = ctx.getCaller().toString();
        String selectUserSql = "select fnumber from t_pm_user where fid = ?";
        Object[] paramUser = new Object[]{userId};
        if (conn.isClosed()) {
            conn = this.getConnection(ctx);
        }
        IRowSet rs = null;
        try {
            rs = this.executeQuery(conn, selectUserSql, paramUser);
            if (rs != null && rs.next()) {
                userNumber = rs.getString(1);
            }
            String detailId = BaseUuid.create().toString();
            long executeTime = params.getLong("executeTime");
            String path = this.getDeployPath(reportInfo, params);
            String sqlDetail = "insert into T_EXT_RptAuditList (fid,freportid,fstatdate,fexecutetime,fexecutor,fexecutepath) values (?,?,now(),?,?,?);";
            Object[] paramDetail = new Object[]{detailId, reportInfo.getId().toString(), new Long(executeTime), userNumber, path};
            DbUtil.executeUpdate(conn, sqlDetail, paramDetail);
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs);
    }

    private Connection getConnection(Context ctx) throws SQLException {
        if (ctx != null) {
            return EJBFactory.getConnection((Context)ctx);
        }
        return DbUtil.getConnection();
    }

    private String getDeployPath(DefineReportInfo reportInfo, RptParams params) {
        String SPLIT = "@@";
        switch (params.getInt("deployType")) {
            case 1: {
                String path = reportInfo.getDeployPath();
                if (path != null) {
                    path = path.split(SPLIT)[1];
                }
                return "\u5ba2\u6237\u7aef:" + path;
            }
            case 2: {
                String path1 = reportInfo.getBIPath();
                if (path1 != null) {
                    path1 = path1.split(SPLIT)[1];
                }
                return "\u95e8\u6237:" + path1;
            }
            case 3: {
                String portletName = reportInfo.getPortletName();
                if (null == portletName) {
                    String deployPath = reportInfo.getDeployPath();
                    portletName = null != deployPath && deployPath.indexOf("@@") > 0 ? deployPath.substring(deployPath.indexOf("@@") + 2) : reportInfo.getEasWebAppCenterPath();
                }
                return "portlet:" + portletName;
            }
            case 4: {
                return "\u62a5\u8868\u5de5\u5177";
            }
            case 5: {
                return "\u6269\u5c55\u62a5\u8868";
            }
            case 6: {
                return "\u6807\u51c6\u62a5\u8868";
            }
            case 7: {
                return "\u8c03\u5ea6\u6267\u884c";
            }
            case 8: {
                return "\u8054\u67e5\u6267\u884c";
            }
            case 9: {
                return "\u79fb\u52a8:" + reportInfo.getMobileName();
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRowSet executeQuery(Connection conn, String sql, Object[] params) throws SQLException {
        JdbcRowSet jdbcRowSet;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(sql);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
            }
            rs = ps.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, (Statement)ps);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        return jdbcRowSet;
    }
}

