/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.audittool;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.ui.worker.LongTaskWorker;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlreport.DefineReportInfo;
import com.kingdee.eas.rpts.ctrlreport.audittool.IReportAudit;
import com.kingdee.eas.rpts.ctrlreport.audittool.ReportAuditToolFrame;
import com.kingdee.eas.rpts.ctrlreport.mobile.server.PubAcctsDAO;
import com.kingdee.eas.rpts.ctrlreport.model.CommonTreeModel;
import com.kingdee.eas.rpts.ctrlsqldesign.factory.FacadeFactory;
import com.kingdee.eas.util.client.EASResource;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class ReportAuditImpl
implements IReportAudit {
    private KDTree reportTree;
    private int type = -1;
    private int orgIsolat = 1;
    private ArrayList<DefaultKingdeeTreeNode> noChildNodeList = new ArrayList();
    private KDCheckBox deployRptCheckBox;
    private KDCheckBox orgIsolatCheckBox;
    private Map<String, List> allReportInfosMap = new HashMap<String, List>();

    @Override
    public void setCheckBox(KDCheckBox deployRptCheckBox, KDCheckBox orgIsolatCheckBox) {
        this.deployRptCheckBox = deployRptCheckBox;
        this.orgIsolatCheckBox = orgIsolatCheckBox;
    }

    private void buildTree() {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"\u52aa\u529b\u52a0\u8f7d\u4e2d...");
        KingdeeTreeModel model = new KingdeeTreeModel((TreeNode)root);
        this.reportTree.setModel((TreeModel)model);
        TreeBuilder builder = new TreeBuilder();
        builder.start();
    }

    @Override
    public void initReportTree(KDTree reportTree, int type, int orgIsolat) {
        this.reportTree = reportTree;
        this.type = type;
        this.orgIsolat = orgIsolat;
        this.buildTree();
    }

    private DefaultKingdeeTreeNode convertToKingdeeTreeNode(IBriefViewTreeNode root, DefaultKingdeeTreeNode nodeRoot) {
        Enumeration enu = root.children();
        while (enu.hasMoreElements()) {
            IBriefViewTreeNode bvNode = (IBriefViewTreeNode)enu.nextElement();
            String strNodeName = bvNode.getAlias() + "(" + bvNode.getName() + ")";
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode();
            node.setText(strNodeName);
            node.setUserObject((Object)bvNode);
            nodeRoot.add((MutableTreeNode)node);
            this.convertToKingdeeTreeNode(bvNode, node);
        }
        this.setRptsNode(root, nodeRoot);
        return nodeRoot;
    }

    private void setRptsNode(IBriefViewTreeNode bvNode, DefaultKingdeeTreeNode nodeRoot) {
        String systemID = bvNode.getFullName();
        List infos = this.allReportInfosMap.get(systemID);
        int len = infos == null ? 0 : infos.size();
        int size = len;
        for (int i = 0; i < size; ++i) {
            DefineReportInfo info = (DefineReportInfo)infos.get(i);
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode();
            node.setText(info.getName());
            node.setUserObject((Object)info);
            nodeRoot.add((MutableTreeNode)node);
        }
        if (nodeRoot.getChildCount() <= 0) {
            nodeRoot.removeFromParent();
        }
    }

    private void createAllReportInfo() {
        this.allReportInfosMap.clear();
        ArrayList infos = new ArrayList();
        RptParams params = new RptParams();
        params.setString("FullName", "com.kingdee.eas.rpts.ctrlreport.audittool.ReportAuditDAO");
        params.setString("MethodName", "getAllReportInfos");
        params.setObject("reportInfo", infos);
        params.setString("orgId", SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
        params.setInt("requestRptType", this.type);
        params.setInt("orgIsolatType", this.orgIsolat);
        try {
            params = FacadeFactory.commonExecute(null, params);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        ArrayList reportInfos = (ArrayList)params.getObject("reportInfo");
        int size = reportInfos.size();
        for (int i = 0; i < size; ++i) {
            DefineReportInfo info = (DefineReportInfo)reportInfos.get(i);
            ArrayList<DefineReportInfo> list = this.allReportInfosMap.get(info.getSystemID());
            if (list == null) {
                list = new ArrayList<DefineReportInfo>();
            }
            list.add(info);
            this.allReportInfosMap.put(info.getSystemID(), list);
        }
    }

    private ArrayList getReportInfo(String systemID) {
        ArrayList infos = new ArrayList();
        RptParams params = new RptParams();
        params.setString("FullName", "com.kingdee.eas.rpts.ctrlreport.audittool.ReportAuditDAO");
        params.setString("MethodName", "getReportInfos");
        params.setObject("reportInfo", infos);
        params.setString("systemID", systemID);
        params.setString("orgId", SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
        params.setInt("requestRptType", this.type);
        params.setInt("orgIsolatType", this.orgIsolat);
        try {
            params = FacadeFactory.commonExecute(null, params);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return (ArrayList)params.getObject("reportInfo");
    }

    @Override
    public ArrayList queryRptAuditSum(ITreeNode selectedNode) {
        RptParams params = new RptParams();
        params.setInt("stat", 0);
        return this.queryRptAudit(selectedNode, params);
    }

    @Override
    public ArrayList queryRptAuditDetail(ITreeNode selectedNode, String statDate) {
        RptParams params = new RptParams();
        params.setInt("stat", 1);
        params.setString("clickCellValue", statDate);
        return this.queryRptAudit(selectedNode, params);
    }

    private ArrayList queryRptAudit(ITreeNode selectedNode, RptParams params) {
        ArrayList result = new ArrayList();
        String reportId = ((DefineReportInfo)((DefaultKingdeeTreeNode)selectedNode).getUserObject()).getId().toString();
        params.setString("FullName", "com.kingdee.eas.rpts.ctrlreport.audittool.ReportAuditDAO");
        params.setString("MethodName", "queryReportExecuted");
        params.setString("reportId", reportId);
        params.setObject("statResult", result);
        try {
            params = FacadeFactory.commonExecute(null, params);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return (ArrayList)params.getObject("statResult");
    }

    @Override
    public void updateAllViews() {
        RptParams params = new RptParams();
        params.setString("FullName", "com.kingdee.eas.rpts.ctrlreport.audittool.ReportAuditDAO");
        params.setString("MethodName", "updateAllViews");
        try {
            FacadeFactory.commonExecute(null, params);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private void setMobileRptsNode(DefaultKingdeeTreeNode nodeRoot) {
        if (!nodeRoot.isLeaf()) {
            Enumeration enume = nodeRoot.children();
            while (enume.hasMoreElements()) {
                DefaultKingdeeTreeNode repNode = (DefaultKingdeeTreeNode)enume.nextElement();
                this.setMobileRptsNode(repNode);
            }
            if (nodeRoot.isRoot()) {
                return;
            }
        }
        PubAcctsDAO.PubAcct pubAcct = (PubAcctsDAO.PubAcct)nodeRoot.getUserObject();
        ArrayList infos = this.getReportInfo(pubAcct.fid);
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            DefineReportInfo info = (DefineReportInfo)infos.get(i);
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode();
            node.setText(info.getName());
            node.setUserObject((Object)info);
            nodeRoot.add((MutableTreeNode)node);
        }
        if (nodeRoot.getChildCount() <= 0) {
            this.noChildNodeList.add(nodeRoot);
        }
    }

    private void deleteNoChildNode() {
        if (this.noChildNodeList.size() > 0) {
            for (int i = 0; i < this.noChildNodeList.size(); ++i) {
                this.noChildNodeList.get(i).removeFromParent();
            }
        }
        this.noChildNodeList.clear();
    }

    private class TreeBuilder
    extends LongTaskWorker {
        private TreeBuilder() {
        }

        public Object construct() {
            DefaultKingdeeTreeNode nodeRoot = new DefaultKingdeeTreeNode((Object)"EAS");
            if (ReportAuditToolFrame.getReportAuditType() == 0) {
                BOSObjectType[] types = new BOSObjectType[]{MetaDataTypeList.PACKAGE};
                long startTime = System.currentTimeMillis();
                IBriefViewTreeNode root = SubSystemUtils.getSubSystemByName((String)"com_kingdee_eas_packages", (BOSObjectType[])types);
                System.out.println("==================SubSystemUtils.getSubSystemByName time:" + (System.currentTimeMillis() - startTime));
                nodeRoot.setText(EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.ReportsResource", (String)"reportRoot"));
                nodeRoot.setUserObject((Object)root);
                startTime = System.currentTimeMillis();
                ReportAuditImpl.this.createAllReportInfo();
                nodeRoot = ReportAuditImpl.this.convertToKingdeeTreeNode(root, nodeRoot);
                System.out.println("==================convertToKingdeeTreeNode time:" + (System.currentTimeMillis() - startTime));
            } else if (ReportAuditToolFrame.getReportAuditType() == 1) {
                nodeRoot = CommonTreeModel.getMobileTreeModel();
                ReportAuditImpl.this.setMobileRptsNode(nodeRoot);
                ReportAuditImpl.this.deleteNoChildNode();
            }
            ReportAuditImpl.this.reportTree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)nodeRoot));
            ((KingdeeTreeModel)ReportAuditImpl.this.reportTree.getModel()).setAsksAllowsChildren(false);
            ReportAuditImpl.this.reportTree.getSelectionModel().setSelectionMode(1);
            ReportAuditImpl.this.reportTree.setAutoscrolls(true);
            ReportAuditImpl.this.reportTree.repaint();
            return null;
        }

        public void finished() {
            ReportAuditImpl.this.deployRptCheckBox.setEnabled(true);
            ReportAuditImpl.this.orgIsolatCheckBox.setEnabled(true);
        }
    }
}

