/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.bo;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.UID;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlreport.ReportFacadeFactory;
import com.kingdee.eas.rpts.ctrlreport.email.SendMailInfo;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.factory.FacadeFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import sun.misc.BASE64Encoder;

public class SendMailBO {
    private static Logger log = LogUtil.getPackageLogger(SendMailBO.class);
    private static String beanFullName = "com.kingdee.eas.rpts.ctrlreport.app.ReportAttemperControllerBean";
    private static HashMap mapCache = new HashMap();

    public static ArrayList getSendMailList(Context ctx) throws BOSException, SQLException {
        String sql = "select * from T_EXT_SendMailInfo";
        log.debug((Object)("getSendMailList sql = " + sql));
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getInfoListBySQL");
        pr.setString("sql", sql);
        pr.setObject("lstValue", new ArrayList());
        RptParams ps_r = FacadeFactory.commonExecuteNever(ctx, pr);
        ArrayList dataList = (ArrayList)ps_r.getObject("object");
        return dataList;
    }

    public static SendMailInfo[] getSendMailArr(Context ctx) {
        ArrayList list;
        try {
            list = SendMailBO.getSendMailList(ctx);
        }
        catch (Exception e) {
            return null;
        }
        SendMailInfo[] arr = new SendMailInfo[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            SendMailInfo info = new SendMailInfo();
            info.setMailAddress(CtrlReportUtil.getObjectString(map.get("fmailaddress")));
            info.setMailHost(CtrlReportUtil.getObjectString(map.get("fmailhost")));
            info.setMailUser(CtrlReportUtil.getObjectString(map.get("fmailuser")));
            info.setMailPassword(CtrlReportUtil.getObjectString(map.get("fmailpassword")));
            arr[i] = info;
        }
        return arr;
    }

    public static synchronized void cacheSendMail(Context ctx) throws BOSException, SQLException {
        mapCache.clear();
        ArrayList list = SendMailBO.getSendMailList(ctx);
        for (HashMap map : list) {
            SendMailInfo info = new SendMailInfo();
            info.setMailAddress(CtrlReportUtil.getObjectString(map.get("fmailaddress")));
            info.setMailHost(CtrlReportUtil.getObjectString(map.get("fmailhost")));
            info.setMailUser(CtrlReportUtil.getObjectString(map.get("fmailuser")));
            info.setMailPassword(CtrlReportUtil.getObjectString(map.get("fmailpassword")));
            mapCache.put(info.getMailAddress(), info);
        }
    }

    public static SendMailInfo getSendMailInfoFromCache(Context ctx, String mailAddress) throws BOSException, SQLException {
        if (mapCache.isEmpty()) {
            SendMailBO.refreshServerCache(ctx);
        }
        if (mapCache.containsKey(mailAddress)) {
            return (SendMailInfo)mapCache.get(mailAddress);
        }
        return null;
    }

    public static void refreshServerCache(Context ctx) throws BOSException {
        RptParams pr = new RptParams();
        pr.setString("FullName", beanFullName);
        pr.setString("MethodName", "refreshCache");
        FacadeFactory.commonExecuteNever(ctx, pr);
    }

    public static void testLinkMail(Context ctx, SendMailInfo vo) throws BOSException {
        try {
            RptParams pr = new RptParams();
            pr.setString("FullName", beanFullName);
            pr.setString("MethodName", "testLinkMail");
            pr.setObject("SendMailInfo", (Object)vo);
            RptParams ps_r = FacadeFactory.commonExecuteNever(ctx, pr);
            String msg = ps_r.getString("Message");
            MessageUtil.showInfo(msg, false);
        }
        catch (Exception ex) {
            MessageUtil.showDetailAndOK(null, "\u51fa\u73b0\u9519\u8bef", ex);
        }
    }

    public static void insert(SendMailInfo vo) throws BOSException {
        RptParams pr = new RptParams();
        ArrayList<Object> queryValue = new ArrayList<Object>();
        StringBuffer sb = new StringBuffer();
        sb.append("insert into T_EXT_SendMailInfo (FID, FMailAddress, FMailHost, FMailUser, FMailPassword,");
        sb.append(" FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime) values (?,?,?,?,?,?,?,?,?)");
        queryValue.add(UID.create((int)44));
        queryValue.add(vo.getMailAddress());
        queryValue.add(vo.getMailHost());
        queryValue.add(vo.getMailUser());
        queryValue.add(new BASE64Encoder().encodeBuffer(vo.getMailPassword().getBytes()));
        queryValue.add(vo.getCreatorId());
        queryValue.add(vo.getCreateTime());
        queryValue.add(vo.getLastUpdateUserId());
        queryValue.add(vo.getLastUpdateTime());
        pr.setString("sql", sb.toString());
        pr.setObject("lstValue", queryValue);
        pr.setString("MethodName", "maintainRecord");
        ReportFacadeFactory.getRemoteInstance().commonExecute(pr);
    }

    public static void update(SendMailInfo newInfo, SendMailInfo oldInfo) throws BOSException {
        RptParams pr = new RptParams();
        ArrayList<Object> queryValue = new ArrayList<Object>();
        StringBuffer sb = new StringBuffer();
        sb.append("update T_EXT_SendMailInfo set FMailAddress = ?, FMailHost = ?, FMailUser = ?, ");
        sb.append(" FMailPassword = ?, FLastUpdateUserID=?, FLastUpdateTime=?");
        sb.append("  where fid = ?");
        queryValue.add(newInfo.getMailAddress());
        queryValue.add(newInfo.getMailHost());
        queryValue.add(newInfo.getMailUser());
        queryValue.add(new BASE64Encoder().encodeBuffer(newInfo.getMailPassword().getBytes()));
        queryValue.add(newInfo.getLastUpdateUserId());
        queryValue.add(newInfo.getLastUpdateTime());
        queryValue.add(oldInfo.getId());
        pr.setString("sql", sb.toString());
        pr.setObject("lstValue", queryValue);
        pr.setString("MethodName", "maintainRecord");
        ReportFacadeFactory.getRemoteInstance().commonExecute(pr);
    }

    public static final void del(SendMailInfo info) throws EASBizException, BOSException {
        RptParams pr = new RptParams();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(info.getId());
        String sql = "delete T_EXT_SendMailInfo where Fid = ?";
        pr.setString("sql", sql);
        pr.setObject("lstValue", queryValue);
        pr.setString("MethodName", "maintainRecord");
        ReportFacadeFactory.getRemoteInstance().commonExecute(pr);
    }

    public static final boolean isExist(String newAddress, String oldAddress) throws BOSException {
        if (null == oldAddress) {
            if (mapCache.containsKey(newAddress)) {
                return true;
            }
        } else {
            if (newAddress.equals(oldAddress)) {
                return false;
            }
            if (mapCache.containsKey(newAddress)) {
                return true;
            }
        }
        return false;
    }

    public static ArrayList getSendMailListByCurUser(Context ctx, String curUserId) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer("select fid,FMailAddress,FMailHost,FMailUser,FMailPassword,FCreatorID,FLastUpdateUserID from T_EXT_SendMailInfo");
        sql.append(" where FCreatorID = ?");
        ArrayList<String> param = new ArrayList<String>(1);
        param.add(curUserId);
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getInfoListBySQL");
        pr.setString("sql", sql.toString());
        pr.setObject("lstValue", param);
        RptParams ps_r = FacadeFactory.commonExecuteNever(ctx, pr);
        ArrayList dataList = (ArrayList)ps_r.getObject("object");
        return dataList;
    }

    public static synchronized SendMailInfo getSendMailListById(Context ctx, String mailId) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer("select fid,FMailAddress,FMailHost,FMailUser,FMailPassword,FCreatorID,FLastUpdateUserID from T_EXT_SendMailInfo");
        sql.append(" where fid = ?");
        ArrayList<String> param = new ArrayList<String>(1);
        param.add(mailId);
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getInfoListBySQL");
        pr.setString("sql", sql.toString());
        pr.setObject("lstValue", param);
        RptParams ps_r = FacadeFactory.commonExecuteNever(ctx, pr);
        ArrayList dataList = (ArrayList)ps_r.getObject("object");
        if (dataList != null && dataList.size() > 0) {
            HashMap map = (HashMap)dataList.get(0);
            SendMailInfo sendMailInfo = new SendMailInfo();
            sendMailInfo.setId((String)map.get("fid"));
            sendMailInfo.setMailAddress((String)map.get("fmailaddress"));
            sendMailInfo.setMailHost((String)map.get("fmailhost"));
            sendMailInfo.setMailUser((String)map.get("fmailuser"));
            sendMailInfo.setMailPassword((String)map.get("fmailpassword"));
            return sendMailInfo;
        }
        return null;
    }
}

