/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.macro.model;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.rpts.ctrlreport.macro.exception.MacroDesignException;
import com.kingdee.eas.rpts.ctrlreport.macro.model.ExtRptMacro;
import com.kingdee.eas.rpts.ctrlreport.macro.model.ExtRptMacroType;
import com.kingdee.eas.rpts.ctrlreport.macro.model.IExtRptMacro;
import com.kingdee.eas.rpts.ctrlreport.macro.model.MacroVO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class ExtRptMacroIOFactory {
    private static final String MACRO_DESC_DATA_SPLIT = "#@MACRO_SPLIT@#";

    public static MacroVO[] toMacro(InputStream in) throws MacroDesignException {
        ZipInputStream zipIn = new ZipInputStream(in);
        try {
            ZipEntry entry;
            ArrayList<MacroVO> list = new ArrayList<MacroVO>();
            byte[] buffer = new byte[1024];
            while ((entry = zipIn.getNextEntry()) != null) {
                ByteArrayOutputStream descBuffer = new ByteArrayOutputStream();
                int len = zipIn.read(buffer);
                while (len > 0) {
                    descBuffer.write(buffer, 0, len);
                    len = zipIn.read(buffer);
                }
                entry = zipIn.getNextEntry();
                ByteArrayOutputStream defineBuffer = new ByteArrayOutputStream();
                len = zipIn.read(buffer);
                while (len > 0) {
                    defineBuffer.write(buffer, 0, len);
                    len = zipIn.read(buffer);
                }
                list.add(ExtRptMacroIOFactory.loadMacro(descBuffer.toByteArray(), defineBuffer.toByteArray()));
            }
            return list.toArray(new MacroVO[0]);
        }
        catch (IOException e) {
            throw MacroDesignException.newFailed2LoadMacroFileException(e);
        }
        catch (JDOMException e) {
            throw MacroDesignException.newFailed2LoadMacroFileException(e);
        }
    }

    public static byte[] toByte(MacroVO[] mList) throws MacroDesignException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ZipOutputStream zipOut = new ZipOutputStream(out);
        try {
            for (MacroVO vo : mList) {
                IExtRptMacro macro = vo.getMacro();
                String name = macro.name();
                ZipEntry entry = new ZipEntry(name + "/desc.xml");
                zipOut.putNextEntry(entry);
                Element root = new Element("desc");
                root.setAttribute("macroName", name);
                root.setAttribute("mType", macro.mType().name());
                root.setAttribute("vType", macro.vType().name());
                root.setText(vo.getDescription());
                new XMLOutputter().output(root, (OutputStream)zipOut);
                entry = new ZipEntry(name + "/data.data");
                zipOut.putNextEntry(entry);
                zipOut.write(vo.getMacro().define().getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw MacroDesignException.newFailed2SaveMacroFileException(e);
        }
        finally {
            try {
                zipOut.close();
            }
            catch (IOException e) {
                throw MacroDesignException.newFailed2SaveMacroFileException(e);
            }
        }
        return out.toByteArray();
    }

    public static MacroVO metaString2Macro(String metaString) throws JDOMException, IOException, BOSException {
        String[] metas = metaString.split(MACRO_DESC_DATA_SPLIT);
        if (metas.length != 2) {
            throw new BOSException("\u89e3\u6790\u62a5\u8868\u53c2\u6570\u7ed1\u5b9a\u7684\u5b8f\u51fa\u9519\uff01");
        }
        return ExtRptMacroIOFactory.loadMacro(metas[0].getBytes("UTF-8"), metas[1].getBytes("UTF-8"));
    }

    public static String macro2MetaString(MacroVO macroVO) {
        if (macroVO == null || macroVO.getMacro() == null) {
            return "";
        }
        StringBuffer metaString = new StringBuffer();
        IExtRptMacro extMacro = macroVO.getMacro();
        String name = extMacro.name();
        ExtRptMacroType.VType vt = extMacro.vType();
        ExtRptMacroType.MType mt = extMacro.mType();
        Element root = new Element("desc");
        root.setAttribute("macroName", name);
        root.setAttribute("mType", mt == null ? "" : mt.name());
        root.setAttribute("vType", vt == null ? "" : vt.name());
        root.setText(macroVO.getDescription());
        Format format = Format.getPrettyFormat();
        format.setIndent("\t");
        format.setEncoding("UTF-8");
        XMLOutputter outter = new XMLOutputter(format);
        metaString.append(outter.outputString(root));
        metaString.append(MACRO_DESC_DATA_SPLIT);
        metaString.append(extMacro.define());
        return metaString.toString();
    }

    private static MacroVO loadMacro(byte[] desc, byte[] define) throws JDOMException, IOException {
        Element root = new SAXBuilder().build((InputStream)new ByteArrayInputStream(desc)).getRootElement();
        return new MacroVO().setMacro(new ExtRptMacro(root.getAttributeValue("macroName"), new String(define, "UTF-8"), ExtRptMacroType.MType.valueOf(root.getAttributeValue("mType")), ExtRptMacroType.VType.valueOf(root.getAttributeValue("vType")))).setDescription(root.getText());
    }
}

