/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.macro.ui.action;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.rpts.ctrlreport.macro.exception.MacroDesignException;
import com.kingdee.eas.rpts.ctrlreport.macro.facade.ExtRptMacroControllerFacade;
import com.kingdee.eas.rpts.ctrlreport.macro.facade.IExtRptMacroController;
import com.kingdee.eas.rpts.ctrlreport.macro.resources.Resources;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.action.IExtRptMacroActionHost;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;

abstract class AbstractExtRptAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private IExtRptMacroActionHost host;
    private IExtRptMacroController controller;
    protected Window window;

    AbstractExtRptAction(IExtRptMacroActionHost host, String nameKey, String imageKey) throws MacroDesignException {
        super(Resources.getResourceString(nameKey), Resources.getResourceIcon(imageKey));
        this.putValue("ShortDescription", Resources.getResourceString(nameKey));
        this.host = host;
        try {
            this.controller = ExtRptMacroControllerFacade.getRemoteInst();
        }
        catch (BOSException e) {
            throw MacroDesignException.newStubFetchException(e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.window = SwingUtilities.getWindowAncestor((Component)e.getSource());
        if (this.actionPerformed(this.host, this.controller)) {
            this.host.afterAction();
        }
        if (this.window != null) {
            this.window.repaint();
        }
    }

    protected abstract boolean actionPerformed(IExtRptMacroActionHost var1, IExtRptMacroController var2);
}

