/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.macro.ui.action;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.eas.rpts.ctrlreport.macro.exception.MacroDesignException;
import com.kingdee.eas.rpts.ctrlreport.macro.facade.IExtRptMacroController;
import com.kingdee.eas.rpts.ctrlreport.macro.model.ExtRptMacroIOFactory;
import com.kingdee.eas.rpts.ctrlreport.macro.model.MacroVO;
import com.kingdee.eas.rpts.ctrlreport.macro.resources.Resources;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.IExtRptMacroSelectionAware;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.action.AbstractExtRptAction;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.action.IExtRptMacroActionHost;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

class ExportAction
extends AbstractExtRptAction
implements IExtRptMacroSelectionAware {
    private static final long serialVersionUID = 1L;
    private static Logger logger = CommonLogger.getLogger(ExportAction.class);
    private KDFileChooser fc;
    private File parentLoc;

    ExportAction(IExtRptMacroActionHost host) throws MacroDesignException {
        super(host, "\u5bfc\u51fa", "imgTbtn_output");
        host.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean actionPerformed(IExtRptMacroActionHost host, IExtRptMacroController controller) {
        if (this.fc == null) {
            this.fc = new KDFileChooser();
            FileFilter[] ff = this.fc.getChoosableFileFilters();
            for (int i = 0; i < ff.length; ++i) {
                this.fc.removeChoosableFileFilter(ff[i]);
            }
            this.fc.setFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return Resources.getResourceString("\u6269\u5c55\u62a5\u8868\u5b8f\u6587\u4ef6\uff08.macro\uff09");
                }

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getAbsolutePath().endsWith(".macro");
                }
            });
            this.fc.setDialogType(1);
        }
        MacroVO[] selections = host.getSelections();
        if (this.parentLoc == null) {
            this.parentLoc = this.fc.getFileSystemView().getDefaultDirectory();
        }
        this.fc.setSelectedFile(new File(this.parentLoc, selections[0].getMacro().name() + (selections.length > 1 ? Resources.getResourceString("\u7b49\u5b8f\u6587\u4ef6") : "") + ".macro"));
        if (0 == this.fc.showSaveDialog((Component)this.window)) {
            File selection = this.fc.getSelectedFile();
            String fileName = selection.getName();
            this.parentLoc = selection.getParentFile();
            if (!fileName.endsWith(".macro")) {
                selection = new File(this.parentLoc, fileName + ".macro");
            }
            boolean doExport = true;
            if (selection.exists()) {
                boolean bl = doExport = MessageUtil.msgboxOkCancel((Component)this.window, (String)Resources.getResourceString("\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u662f\u5426\u8986\u76d6\uff1f"));
            }
            if (doExport) {
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(selection);
                    out.write(ExtRptMacroIOFactory.toByte(host.getSelections()));
                    MessageUtil.msgboxInfo(null, (String)"\u5bfc\u51fa\u5b8c\u6210");
                }
                catch (FileNotFoundException e) {
                    logger.error((Object)e);
                    MessageUtil.msgboxWarning((Component)this.window, (String)Resources.getResourceString("\u5bfc\u51fa\u6587\u4ef6\u4e0d\u5b58\u5728\u3002"));
                }
                catch (IOException e) {
                    logger.error((Object)e);
                    MessageUtil.msgboxWarning((Component)this.window, (String)Resources.getResourceString("\u5bfc\u51fa\u5b8f\u6587\u4ef6\u5931\u8d25\u3002"));
                }
                catch (MacroDesignException e) {
                    logger.error((Object)e);
                    MessageUtil.msgboxWarning((Component)this.window, (String)Resources.getResourceString("\u5bfc\u51fa\u5b8f\u6587\u4ef6\u5931\u8d25\u3002"));
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            logger.error((Object)e);
                        }
                    }
                }
            }
        }
        return false;
    }

    @Override
    public void selectionChanged(MacroVO[] currentSelection) {
        this.setEnabled(currentSelection != null && currentSelection.length > 0);
    }
}

