/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.macro.ui.action;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.eas.rpts.ctrlreport.macro.exception.MacroDesignException;
import com.kingdee.eas.rpts.ctrlreport.macro.facade.IExtRptMacroController;
import com.kingdee.eas.rpts.ctrlreport.macro.model.ExtRptMacroIOFactory;
import com.kingdee.eas.rpts.ctrlreport.macro.model.MacroVO;
import com.kingdee.eas.rpts.ctrlreport.macro.resources.Resources;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.action.AbstractExtRptAction;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.action.IExtRptMacroActionHost;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

class ImportAction
extends AbstractExtRptAction {
    private static final long serialVersionUID = 1L;
    private static Logger logger = CommonLogger.getLogger(ImportAction.class);
    private KDFileChooser fc;

    ImportAction(IExtRptMacroActionHost host) throws MacroDesignException {
        super(host, "\u5bfc\u5165", "imgTbtn_input");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean actionPerformed(IExtRptMacroActionHost host, IExtRptMacroController controller) {
        if (this.fc == null) {
            this.fc = new KDFileChooser();
            FileFilter[] ff = this.fc.getChoosableFileFilters();
            for (int i = 0; i < ff.length; ++i) {
                this.fc.removeChoosableFileFilter(ff[i]);
            }
            this.fc.setFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return Resources.getResourceString("\u6269\u5c55\u62a5\u8868\u5b8f\u6587\u4ef6\uff08.macro\uff09");
                }

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getAbsolutePath().endsWith(".macro");
                }
            });
            this.fc.setDialogType(0);
        }
        if (0 == this.fc.showOpenDialog((Component)this.window)) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(this.fc.getSelectedFile());
                MacroVO[] list = ExtRptMacroIOFactory.toMacro(in);
                if (list == null || list.length == 0) {
                    MessageUtil.msgboxInfo((Component)this.window, (String)Resources.getResourceString("\u9519\u8bef\u7684\u5b8f\u6587\u4ef6\u683c\u5f0f"));
                }
                for (MacroVO vo : list) {
                    String name = vo.getMacro().name();
                    if (controller.e(name, null)) {
                        if (!MessageUtil.msgboxOkCancel((Component)this.window, (String)("\u3010" + vo.getMacro().name() + "\u3011" + Resources.getResourceString("\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u662f\u5426\u8986\u76d6\uff1f")))) continue;
                        controller.u(vo);
                        continue;
                    }
                    controller.c(vo);
                }
                boolean bl = true;
                return bl;
            }
            catch (FileNotFoundException e) {
                logger.error((Object)e);
                MessageUtil.msgboxWarning((Component)this.window, (String)Resources.getResourceString("\u5bfc\u5165\u6587\u4ef6\u4e0d\u5b58\u5728\u3002"));
                boolean bl = false;
                return bl;
            }
            catch (MacroDesignException e) {
                logger.error((Object)e);
                MessageUtil.msgboxWarning((Component)this.window, (String)Resources.getResourceString("\u5bfc\u5165\u5b8f\u6587\u4ef6\u5931\u8d25\u3002"));
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)e);
                    }
                }
            }
        }
        return false;
    }
}

