/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.macro.ui.action;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlreport.macro.exception.MacroDesignException;
import com.kingdee.eas.rpts.ctrlreport.macro.facade.IExtRptMacroController;
import com.kingdee.eas.rpts.ctrlreport.macro.model.MacroVO;
import com.kingdee.eas.rpts.ctrlreport.macro.resources.Resources;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.IExtRptMacroSelectionAware;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.action.AbstractExtRptAction;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.action.IExtRptMacroActionHost;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.designer.ExtRptMacroDesignUI;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.designer.PropertiesContentPanel;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.mutex.MacroMutexLockService;
import java.awt.Component;
import org.apache.log4j.Logger;

class PropertiesAction
extends AbstractExtRptAction
implements IExtRptMacroSelectionAware {
    private static Logger logger = CommonLogger.getLogger(PropertiesAction.class);
    private static final long serialVersionUID = 1L;
    private MacroVO macroVO;
    private PropertiesContentPanel panel;

    PropertiesAction(IExtRptMacroActionHost host) throws MacroDesignException {
        super(host, "\u4fee\u6539\u5c5e\u6027", "imgTbtn_rename");
        host.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean actionPerformed(IExtRptMacroActionHost host, final IExtRptMacroController controller) {
        this.macroVO = host.getSelections()[0];
        String macroName = this.macroVO.getMacro().name();
        if (!MacroMutexLockService.requestLock(macroName, host.getCoreUI())) {
            return false;
        }
        try {
            this.panel = new PropertiesContentPanel(this.macroVO, controller);
            ExtRptMacroDesignUI.newEmptyModalDialog(this.window, new ExtRptMacroDesignUI.IMiniDialogContentPane(){

                @Override
                public boolean btnConfirmActionPerformed() {
                    if (PropertiesAction.this.panel.verify()) {
                        try {
                            controller.u(PropertiesAction.this.macroVO);
                            return true;
                        }
                        catch (MacroDesignException e) {
                            logger.error((Object)e);
                            MessageUtil.msgboxWarning((Component)PropertiesAction.this.window, (String)Resources.getResourceString("\u52a0\u8f7d\u5b8f\u5217\u8868\u5931\u8d25\u3002"), (String)e.getMessage());
                        }
                    }
                    return false;
                }

                @Override
                public Component contentPane() {
                    return PropertiesAction.this.panel.getContentPanel();
                }

                @Override
                public String title() {
                    return Resources.getResourceString("\u4fee\u6539\u5c5e\u6027");
                }
            }).show();
        }
        finally {
            MacroMutexLockService.releaseLock(macroName);
        }
        return true;
    }

    @Override
    public void selectionChanged(MacroVO[] currentSelection) {
        this.setEnabled(currentSelection != null && currentSelection.length == 1);
    }
}

