/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.macro.ui.designer;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.rpts.ctrlreport.macro.exception.MacroDesignException;
import com.kingdee.eas.rpts.ctrlreport.macro.facade.IExtRptMacroController;
import com.kingdee.eas.rpts.ctrlreport.macro.model.ExtRptMacroType;
import com.kingdee.eas.rpts.ctrlreport.macro.model.MacroVO;
import com.kingdee.eas.rpts.ctrlreport.macro.resources.Resources;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.designer.ExtRptMacroDesignUI;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.designer.MacroValueDisplayPanel;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.designer.PropertiesContentPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

abstract class AbstractMacroDesignUI
extends KDPanel
implements ExtRptMacroDesignUI.IDialogContentPane {
    private static Logger logger = CommonLogger.getLogger(AbstractMacroDesignUI.class);
    private static final long serialVersionUID = 1L;
    private PropertiesContentPanel namePanel;
    private boolean verifyResult;
    protected MacroVO mVO;
    protected IExtRptMacroController controller;

    protected AbstractMacroDesignUI(MacroVO mVO, IExtRptMacroController controller) throws MacroDesignException {
        this.mVO = mVO;
        this.controller = controller;
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(800, 450));
        this.initUI();
    }

    protected abstract void initUI() throws MacroDesignException;

    protected abstract void beforeSaveAction() throws MacroDesignException;

    @Override
    public void btnPreviewActionPerformed() {
        try {
            this.beforeSaveAction();
            new MacroValueDisplayPanel(this.mVO).showInModalDialog(this.contentPane());
        }
        catch (Exception e) {
            logger.error((Object)e);
            MessageUtil.msgboxInfo((Component)this.contentPane(), (String)Resources.getResourceString("\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5b8f\u5b9a\u4e49\u3002"));
        }
    }

    @Override
    public boolean btnSaveActionPerformed() {
        try {
            this.beforeSaveAction();
            if (this.mVO.getUuid() == null) {
                if (!this.showNameFetcherUI()) {
                    return false;
                }
                this.controller.c(this.mVO);
            } else {
                this.controller.u(this.mVO);
            }
            return true;
        }
        catch (MacroDesignException e) {
            logger.error((Object)e);
            MessageUtil.msgboxInfo((Component)((Object)this), (String)Resources.getResourceString("\u4fdd\u5b58\u5b8f\u5b9a\u4e49\u5931\u8d25\u3002"));
            return false;
        }
    }

    @Override
    public boolean btnSaveAsActionPerformed() {
        String srcId = this.mVO.getUuid();
        this.mVO.setUuid(null);
        if (!this.showNameFetcherUI()) {
            this.mVO.setUuid(srcId);
            return false;
        }
        try {
            this.beforeSaveAction();
            this.controller.c(this.mVO);
            return true;
        }
        catch (MacroDesignException e) {
            logger.error((Object)e);
            MessageUtil.msgboxInfo((Component)((Object)this), (String)Resources.getResourceString("\u4fdd\u5b58\u5b8f\u5b9a\u4e49\u5931\u8d25\u3002"));
            return false;
        }
    }

    private boolean showNameFetcherUI() {
        this.namePanel = new PropertiesContentPanel(this.mVO, this.controller);
        this.verifyResult = false;
        ExtRptMacroDesignUI.newEmptyModalDialog(SwingUtilities.getWindowAncestor((Component)((Object)this)), new ExtRptMacroDesignUI.IMiniDialogContentPane(){

            @Override
            public boolean btnConfirmActionPerformed() {
                AbstractMacroDesignUI.this.verifyResult = AbstractMacroDesignUI.this.namePanel.verify();
                return AbstractMacroDesignUI.this.verifyResult;
            }

            @Override
            public Component contentPane() {
                return AbstractMacroDesignUI.this.namePanel.getContentPanel();
            }

            @Override
            public String title() {
                return Resources.getResourceString("\u540d\u79f0");
            }
        }).show();
        return this.verifyResult;
    }

    @Override
    public String title() {
        return (this.mVO.getUuid() == null ? "\u65b0\u5efa" : "\u7f16\u8f91") + (this.mVO.getMacro().mType() == ExtRptMacroType.MType.FUNCTION ? "\u516c\u5f0f\u5b8f" : "SQL\u5b8f") + (this.mVO.getUuid() == null ? "" : "\uff1a" + this.mVO.getMacro().name());
    }

    @Override
    public Component contentPane() {
        return this;
    }
}

