/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.macro.ui.designer;

import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.eas.rpts.ctrlreport.macro.exception.MacroDesignException;
import com.kingdee.eas.rpts.ctrlreport.macro.facade.IExtRptMacroController;
import com.kingdee.eas.rpts.ctrlreport.macro.model.ExtRptMacroFactory;
import com.kingdee.eas.rpts.ctrlreport.macro.model.ExtRptMacroType;
import com.kingdee.eas.rpts.ctrlreport.macro.model.MacroVO;
import com.kingdee.eas.rpts.ctrlreport.macro.resources.Resources;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.designer.FunctionMacroDesignUI;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.designer.SQLMacroDesignUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ExtRptMacroDesignUI {
    public static void showMacroDesigner(Window parent, MacroVO mVO, IExtRptMacroController controller) throws MacroDesignException {
        KDDialog dialog;
        switch (mVO.getMacro().mType()) {
            case FUNCTION: {
                dialog = ExtRptMacroDesignUI.newMacroDesignerModalDialog(parent, new FunctionMacroDesignUI(mVO, controller));
                break;
            }
            case SQL: {
                dialog = ExtRptMacroDesignUI.newMacroDesignerModalDialog(parent, new SQLMacroDesignUI(mVO, controller));
                break;
            }
            default: {
                throw MacroDesignException.newUnkownMacroTypeException();
            }
        }
        dialog.show();
    }

    public static void showMacroDesigner(Window parent, ExtRptMacroType.MType mt, IExtRptMacroController controller) throws MacroDesignException {
        ExtRptMacroDesignUI.showMacroDesigner(parent, ExtRptMacroFactory.emptyMacro(mt), controller);
    }

    public static KDDialog newEmptyModalDialog(Window parent, final IMiniDialogContentPane contentPane) {
        final KDDialog dialog = parent instanceof Frame ? new KDDialog((Frame)parent) : (parent instanceof Dialog ? new KDDialog((Dialog)parent) : new KDDialog());
        dialog.setDefaultCloseOperation(2);
        dialog.setModal(true);
        dialog.setResizable(false);
        dialog.setTitle(contentPane.title());
        KDPanel dialogPanel = new KDPanel();
        dialogPanel.setLayout((LayoutManager)new BorderLayout());
        dialogPanel.add(contentPane.contentPane());
        KDPanel outter = new KDPanel((LayoutManager)new BorderLayout());
        KDPanel panel = new KDPanel((LayoutManager)new FlowLayout(2, 6, 12));
        KDButton confirm = new KDButton(Resources.getResourceString("\u786e\u5b9a"));
        confirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (contentPane.btnConfirmActionPerformed()) {
                    dialog.dispose();
                }
            }
        });
        KDButton cancel = new KDButton(Resources.getResourceString("\u53d6\u6d88"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        panel.add((Component)confirm);
        panel.add((Component)cancel);
        outter.add((Component)new KDSeparator(), (Object)"North");
        outter.add((Component)panel, (Object)"South");
        dialogPanel.add((Component)outter, (Object)"South");
        dialog.setContentPane((Container)dialogPanel);
        dialog.pack();
        dialog.setLocationRelativeTo((Component)parent);
        return dialog;
    }

    private static KDDialog newMacroDesignerModalDialog(Window parent, final IDialogContentPane contentPane) {
        final KDDialog dialog = parent instanceof Frame ? new KDDialog((Frame)parent) : (parent instanceof Dialog ? new KDDialog((Dialog)parent) : new KDDialog());
        dialog.setDefaultCloseOperation(2);
        dialog.setModal(true);
        dialog.setResizable(true);
        dialog.setTitle(contentPane.title());
        KDPanel dialogPanel = new KDPanel();
        dialogPanel.setLayout((LayoutManager)new BorderLayout());
        dialogPanel.add(contentPane.contentPane());
        KDPanel outter = new KDPanel((LayoutManager)new BorderLayout());
        KDPanel panel = new KDPanel((LayoutManager)new FlowLayout(2, 6, 12));
        KDButton preivew = new KDButton(Resources.getResourceString("\u9884\u89c8"));
        preivew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                contentPane.btnPreviewActionPerformed();
            }
        });
        KDButton save = new KDButton(Resources.getResourceString("\u4fdd\u5b58"));
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (contentPane.btnSaveActionPerformed()) {
                    dialog.dispose();
                }
            }
        });
        KDButton saveAs = new KDButton(Resources.getResourceString("\u53e6\u5b58\u4e3a"));
        saveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (contentPane.btnSaveAsActionPerformed()) {
                    dialog.dispose();
                }
            }
        });
        KDButton cancel = new KDButton(Resources.getResourceString("\u53d6\u6d88"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        panel.add((Component)preivew);
        panel.add((Component)save);
        panel.add((Component)saveAs);
        panel.add((Component)cancel);
        outter.add((Component)new KDSeparator(), (Object)"North");
        outter.add((Component)panel, (Object)"South");
        dialogPanel.add((Component)outter, (Object)"South");
        dialog.setContentPane((Container)dialogPanel);
        dialog.pack();
        dialog.setLocationRelativeTo((Component)parent);
        return dialog;
    }

    static interface IDialogContentPane
    extends IContentProvider {
        public void btnPreviewActionPerformed();

        public boolean btnSaveActionPerformed();

        public boolean btnSaveAsActionPerformed();
    }

    public static interface IMiniDialogContentPane
    extends IContentProvider {
        public boolean btnConfirmActionPerformed();
    }

    public static interface IContentProvider {
        public String title();

        public Component contentPane();
    }
}

