/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.mobile.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.UID;
import com.kingdee.bos.ctrl.ext.ui.wizards.propelling.model.ScheduleModel;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlsqldesign.factory.FacadeFactory;
import com.kingdee.eas.rpts.snapshot.dispatch.pojo.ReportDispatchInfo;
import com.kingdee.eas.rpts.snapshot.dispatch.server.impl.ReportDispatchDAOImpl;
import com.kingdee.eas.rpts.snapshot.dispatch.service.impl.ReportDispatchServiceImpl;
import com.kingdee.eas.rpts.snapshot.dispatch.util.DispatchCommonUtil;
import com.kingdee.eas.rpts.sumreport.util.EASUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

public class MobileTemplateUtil {
    public static String loadExtMobileRptScheduleDefine(String rptId) {
        ReportDispatchServiceImpl reportCenterDispatchService = new ReportDispatchServiceImpl();
        try {
            List list = reportCenterDispatchService.getReportDispatchList(" and s.freportid='" + rptId + "' and s.Fcodingruleid='null' and s.fsendmessage is null");
            if (list.isEmpty()) {
                return null;
            }
            HashMap obj = (HashMap)list.get(0);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Element root = new Element("ScheduleModel");
            String[] contents = new String[]{"ffilterxml", "fschedulexml", "fhinttype", "fsendstartscheduletime", "fsendfinishscheduletime", "fstrategytype"};
            for (int i = 0; i < contents.length; ++i) {
                if (obj.get(contents[i]) == null) continue;
                CDATA cData = new CDATA(DispatchCommonUtil.clob2String(obj.get(contents[i])));
                Element content = new Element(contents[i]);
                content.addContent((Content)cData);
                root.addContent((Content)content);
            }
            if (obj.get("fisenabledispatchplan") != null) {
                int en = Integer.parseInt(obj.get("fisenabledispatchplan").toString());
                root.setAttribute("fisenabledispatchplan", String.valueOf(en == 1));
            }
            new XMLOutputter().output(root, (OutputStream)out);
            return new String(out.toByteArray(), "UTF-8");
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void installExtMobileRptScheduleDefine(Context easCtx, String rptId, String systemid, String rptName, byte[] templateData) {
        try {
            ReportDispatchDAOImpl dispatchDAO = new ReportDispatchDAOImpl(easCtx);
            List list = dispatchDAO.getReportDispatchList(easCtx, easCtx.getLocale().toString(), " and s.freportid='" + rptId + "' and s.Fcodingruleid='null' and s.fsendmessage is null");
            if (list.size() > 0) {
                return;
            }
            Book book = MiscUtil.unpack((byte[])templateData);
            String scheduleDefine = (String)book.getUserObjectValue("EXTReportScheduleModelString");
            if (StringUtil.isEmptyString((String)scheduleDefine)) {
                return;
            }
            ByteArrayInputStream in = new ByteArrayInputStream(scheduleDefine.getBytes("UTF-8"));
            Element root = new SAXBuilder().build((InputStream)in).getRootElement();
            if (!Boolean.valueOf(root.getAttributeValue("fisenabledispatchplan", "false")).booleanValue()) {
                return;
            }
            ReportDispatchInfo reportDispatchInfo = new ReportDispatchInfo();
            reportDispatchInfo.setName("\u9884\u8b66\u4e0e\u63a8\u9001-" + rptName, "l2");
            reportDispatchInfo.setName("\u9884\u8b66\u4e0e\u63a8\u9001-" + rptName, "l3");
            reportDispatchInfo.setFilterXML(MobileTemplateUtil.getContent(root.getChild("ffilterxml")));
            reportDispatchInfo.setEnableDispatchPlan(true);
            reportDispatchInfo.setReportId(rptId);
            reportDispatchInfo.setScheduleXML(MobileTemplateUtil.getContent(root.getChild("fschedulexml")));
            OrgUnitInfo orgInfo = ContextUtil.getCurrentOrgUnit((Context)easCtx);
            reportDispatchInfo.setOrgUnitId(orgInfo.getId().toString());
            reportDispatchInfo.setHinttype(ScheduleModel.MessagePushHint.valueOf((String)MobileTemplateUtil.getContent(root.getChild("fhinttype"))));
            reportDispatchInfo.setSendStartScheduleTime(MobileTemplateUtil.getContent(root.getChild("fsendstartscheduletime")));
            reportDispatchInfo.setSendFinishScheduleTime(MobileTemplateUtil.getContent(root.getChild("fsendfinishscheduletime")));
            String userId = ContextUtil.getCurrentUserInfo((Context)easCtx).getId().toString();
            reportDispatchInfo.setCreatorId(userId);
            reportDispatchInfo.setStrategy(ScheduleModel.StrategyType.valueOf((String)MobileTemplateUtil.getContent(root.getChild("fstrategytype"))));
            reportDispatchInfo.setId(UID.create((int)44));
            reportDispatchInfo.setCreatorId(userId);
            reportDispatchInfo.setLastUpdateUserId(userId);
            dispatchDAO.InsertReportDispatch(reportDispatchInfo);
            FunctionObjectInfo function = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)easCtx).getFunction((IMetaDataPK)new MetaDataPK("com.kingdee.eas.rpts.snapshot.dispatch.server.app.ReportDispatchFunction"));
            OperationInfo operation = function.getOperation().get(0);
            String fid = reportDispatchInfo.getId();
            ReportDispatchInfo infoDetail = dispatchDAO.getReportDispatchInfoById(fid, EASUtil.gelLoginLocal());
            String jobDefName = "_" + infoDetail.getName() + "_\u6267\u884c\u4e8b\u52a1";
            String defineXML = infoDetail.getScheduleXML();
            ScheduleDef sdef = KpdlParser.parseSchedule((String)defineXML);
            sdef.setInstructionType(0);
            defineXML = KpdlParser.scheduleToString((ScheduleDef)sdef);
            HashMap<String, String> jobContext = new HashMap<String, String>();
            jobContext.put("dipatchId", fid);
            jobContext.put("locale", easCtx.getLocale().toString());
            String jobProcessDefID = EnactmentServiceFactory.createEnactService((Context)easCtx).createJobProcessDef(jobDefName, function, operation, jobContext, defineXML, easCtx.getLocale());
            reportDispatchInfo.setJobProcessDefID(jobProcessDefID);
            StringBuffer sql = new StringBuffer();
            sql.append(" update T_EXT_SSReportDispatch set FJobProcessDefID=?");
            sql.append(" where fid=? ");
            ArrayList<String> params = new ArrayList<String>(2);
            params.add(jobProcessDefID);
            params.add(fid);
            RptParams pr = new RptParams();
            pr.setString("sql", sql.toString());
            pr.setObject("lstValue", params);
            pr.setString("MethodName", "maintainRecord");
            FacadeFactory.commonExecute(easCtx, pr);
            reportDispatchInfo.setCreatorId(userId);
            reportDispatchInfo.setLastUpdateUserId(userId);
            Timestamp curTime = new Timestamp(new Date().getTime());
            String updateSql = "update T_EXT_SSReportDispatch set FReportID = ? ,FEXCELPATH = ? ,FFOLDPATH = ? ,FFOLDTYPE = ? ,FEmail = ? ,FSendMail = ? ,FOrgID = ? ,FJobProcessDefID = ? ,FMsgSendType = ? ,FsnapShotSaveType = ? ,FIsTakeAttachment = ? ,FLastUpdateUserID = ? ,FLastUpdateTime = ? ,FFilterXml = ? ,FScheduleXml = ? ,Fhinttype=?,fsendstartscheduletime=?,fsendfinishscheduletime=?,fisEnableDispatchPlan=? ,FMailTitle=? ,FMailContent=? ,FStrategyType=? where fid= ?";
            Connection connection = EJBFactory.getConnection((Context)easCtx);
            PreparedStatement pstmt = connection.prepareStatement(updateSql);
            pstmt.setString(1, reportDispatchInfo.getReportId());
            pstmt.setString(2, reportDispatchInfo.getExcelPath());
            pstmt.setString(3, reportDispatchInfo.getFoldPath());
            pstmt.setInt(4, reportDispatchInfo.getFoldType());
            pstmt.setString(5, reportDispatchInfo.getEmail());
            pstmt.setString(6, reportDispatchInfo.getSendMail());
            pstmt.setString(7, reportDispatchInfo.getOrgUnitId());
            pstmt.setString(8, reportDispatchInfo.getJobProcessDefID());
            pstmt.setInt(9, reportDispatchInfo.getMsgSendType());
            pstmt.setInt(10, reportDispatchInfo.getSnapShotSaveType());
            if (reportDispatchInfo.isIsTakeAttachment()) {
                pstmt.setInt(11, 1);
            } else {
                pstmt.setInt(11, 0);
            }
            pstmt.setString(12, reportDispatchInfo.getLastUpdateUserId());
            pstmt.setTimestamp(13, curTime);
            pstmt.setObject(14, reportDispatchInfo.getFilterXML());
            pstmt.setObject(15, reportDispatchInfo.getScheduleXML());
            if (reportDispatchInfo.getHinttype() != null) {
                pstmt.setString(16, reportDispatchInfo.getHinttype().toString());
            } else {
                pstmt.setString(16, null);
            }
            pstmt.setString(17, reportDispatchInfo.getSendStartScheduleTime());
            pstmt.setString(18, reportDispatchInfo.getSendFinishScheduleTime());
            pstmt.setInt(19, reportDispatchInfo.isEnableDispatchPlan() ? 1 : 0);
            pstmt.setString(20, reportDispatchInfo.getMailTitle());
            pstmt.setString(21, reportDispatchInfo.getMailContent());
            if (reportDispatchInfo.getStrategy() != null) {
                pstmt.setString(22, reportDispatchInfo.getStrategy().toString());
            } else {
                pstmt.setString(22, null);
            }
            pstmt.setString(23, reportDispatchInfo.getId());
            pstmt.execute();
            DbUtil.closeConnection(connection);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static String getContent(Element e) {
        Object cdata;
        if (e == null) {
            return null;
        }
        List contents = e.getContent();
        if (contents != null && contents.size() > 0 && (cdata = contents.get(0)) instanceof CDATA) {
            return ((CDATA)cdata).getText();
        }
        return null;
    }
}

