/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.model;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.model.ExtReportConnVO;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import sun.misc.BASE64Decoder;

public class ExtReportConnection {
    public static final Logger logger = CommonLogger.getLogger(ExtReportConnection.class);
    public static final String ClassForName = "com.kingdee.bos.sql.shell.KDDriver";

    private static String getSqlServerUrl(String dbaddress, int dbport, String dbName) {
        String[] arr;
        String instanceName = null;
        if (dbaddress.indexOf("\\") != -1 && (arr = dbaddress.split("\\\\")).length == 2) {
            dbaddress = arr[0];
            instanceName = arr[1];
        }
        StringBuffer sb = new StringBuffer();
        if (!(instanceName = CtrlReportUtil.getObjectString(instanceName)).equals("")) {
            sb.append("jdbc:jtds:sqlserver://").append(dbaddress).append(":").append(dbport).append("/").append(dbName);
            sb.append(";instance=").append(instanceName).append(";prepareSQL=2;sendStringParametersAsUnicode=false;useCursors=true");
        } else {
            sb.append("jdbc:jtds:sqlserver://").append(dbaddress).append(":").append(dbport).append("/").append(dbName);
            sb.append(";prepareSQL=2;sendStringParametersAsUnicode=false;useCursors=true");
        }
        return sb.toString();
    }

    private static String getOracelUrl(String dbaddress, int dbport, String instanceName) {
        return "jdbc:oracle:thin:@" + dbaddress + ":" + dbport + ":" + instanceName;
    }

    private static String getDb2Url(String dbaddress, int dbport, String dbName) {
        return "jdbc:db2://" + dbaddress + ":" + dbport + "/" + dbName + ":retrieveMessagesFromServerOnGetMessage=true;";
    }

    public static String getJDBCUrl(ExtReportConnVO vo) {
        int dbType = vo.getDbType();
        if (dbType == 1) {
            return ExtReportConnection.getSqlServerUrl(vo.getDbAddress(), vo.getDbPort(), vo.getDbName());
        }
        if (dbType == 2) {
            return ExtReportConnection.getOracelUrl(vo.getDbAddress(), vo.getDbPort(), vo.getDbName());
        }
        if (dbType == 3) {
            return ExtReportConnection.getDb2Url(vo.getDbAddress(), vo.getDbPort(), vo.getDbName());
        }
        if (dbType == 6) {
            return ExtReportConnection.getMysql(vo.getDbAddress(), vo.getDbPort(), vo.getDbName());
        }
        if (dbType == 5) {
            return ExtReportConnection.getPostgreSQL(vo.getDbAddress(), vo.getDbPort(), vo.getDbName());
        }
        if (dbType == 7) {
            return ExtReportConnection.getKingbase(vo.getDbAddress(), vo.getDbPort(), vo.getDbName());
        }
        return null;
    }

    private static String getMysql(String dbaddress, int dbport, String dbName) {
        return "jdbc:mysql://" + dbaddress + ":" + dbport + "/" + dbName + "?useUnicode=true&characterEncoding=utf-8";
    }

    private static String getPostgreSQL(String dbaddress, int dbport, String dbName) {
        return "jdbc:postgresql://" + dbaddress + ":" + dbport + "/" + dbName;
    }

    private static String getKingbase(String dbaddress, int dbport, String dbName) {
        return "jdbc:kingbase8://" + dbaddress + ":" + dbport + "/" + dbName;
    }

    public static String getDriverClassName(int dbType) {
        switch (dbType) {
            case 1: {
                return "jdbc:ksql:net.sourceforge.jtds.jdbc.Driver:dbtype=mssqlserver";
            }
            case 2: {
                return "jdbc:ksql:oracle.jdbc.driver.OracleDriver:dbtype=oracle";
            }
            case 3: {
                return "jdbc:ksql:com.ibm.db2.jcc.DB2Driver:dbtype=db2";
            }
            case 6: {
                return "jdbc:ksql:com.mysql.jdbc.Driver:dbtype=mysql";
            }
            case 5: {
                return "jdbc:ksql:org.postgresql.Driver:dbtype=postgresql";
            }
            case 7: {
                return "jdbc:ksql:com.kingbase8.Driver:dbtype=kingbase";
            }
        }
        return null;
    }

    private static final boolean loadDrive() {
        logger.info((Object)"Load JDBC driver com.kingdee.bos.sql.shell.KDDriver");
        try {
            Class.forName(ClassForName);
        }
        catch (ClassNotFoundException ex) {
            logger.error((Object)ex, (Throwable)ex);
            return false;
        }
        logger.info((Object)"Load JDBC driver OK.");
        return true;
    }

    public static Connection openConnection(ExtReportConnVO vo) throws Exception {
        Connection conn = null;
        String connectUrl = ExtReportConnection.getDriverClassName(vo.getDbType()) + ":" + ExtReportConnection.getJDBCUrl(vo);
        ExtReportConnection.loadDrive();
        logger.info((Object)("Open DB-Connection " + connectUrl));
        conn = DriverManager.getConnection(connectUrl, vo.getUser(), new String(new BASE64Decoder().decodeBuffer(vo.getPwd())));
        logger.info((Object)"Open DB-Connection OK.");
        return conn;
    }

    public static void closeConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
                conn = null;
            }
            logger.info((Object)"Close DB-Connection OK.");
        }
        catch (SQLException ex) {
            logger.info((Object)"close DB-Connection faile.");
            ex.printStackTrace();
        }
    }

    public static void testLinkConn(ExtReportConnVO vo) throws Exception {
        Connection conn = ExtReportConnection.openConnection(vo);
        ExtReportConnection.closeConnection(conn);
    }

    public static void main(String[] args) {
        try {
            ExtReportConnVO vo = new ExtReportConnVO();
            vo.setDbAddress("192.168.61.29");
            vo.setDbPort(1521);
            vo.setDbName("orcl");
            vo.setDbType(2);
            vo.setUser("wm408_bosjo");
            vo.setPwd("eas");
            ExtReportConnection.testLinkConn(vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

